/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.themes.types.complex;

import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.themes.types.complex.Effect;
import inform.agent.schemes.converters.vsdx.themes.types.simple.FixedAngle;
import inform.agent.schemes.converters.vsdx.themes.types.simple.Percentage;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveCoordinate;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveFixedAngle;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveFixedPercentage;
import inform.agent.schemes.converters.vsdx.themes.types.simple.RectAlignment;

public class ReflectionEffect
implements Effect {
    private final RectAlignment reflectionAlignment;
    private final PositiveCoordinate blurRadius;
    private final PositiveFixedAngle direction;
    private final PositiveCoordinate distance;
    private final PositiveFixedAngle fadeDirection;
    private final PositiveFixedPercentage startOpacity;
    private final PositiveFixedPercentage startPosition;
    private final PositiveFixedPercentage endOpacity;
    private final PositiveFixedPercentage endPosition;
    private final boolean rotateWithShape;
    private final FixedAngle horizontalSkew;
    private final FixedAngle verticalSkew;
    private final Percentage horizontalRatio;
    private final Percentage verticalRatio;

    public ReflectionEffect(RectAlignment reflectionAlignment, PositiveCoordinate blurRadius, PositiveFixedAngle direction, PositiveCoordinate distance, PositiveFixedAngle fadeDirection, PositiveFixedPercentage startOpacity, PositiveFixedPercentage startPosition, PositiveFixedPercentage endOpacity, PositiveFixedPercentage endPosition, boolean rotateWithShape, FixedAngle horizontalSkew, FixedAngle verticalSkew, Percentage horizontalRatio, Percentage verticalRatio) {
        this.reflectionAlignment = reflectionAlignment;
        this.blurRadius = blurRadius;
        this.direction = direction;
        this.distance = distance;
        this.fadeDirection = fadeDirection;
        this.startOpacity = startOpacity;
        this.startPosition = startPosition;
        this.endOpacity = endOpacity;
        this.endPosition = endPosition;
        this.rotateWithShape = rotateWithShape;
        this.horizontalSkew = horizontalSkew;
        this.verticalSkew = verticalSkew;
        this.horizontalRatio = horizontalRatio;
        this.verticalRatio = verticalRatio;
    }

    @Override
    public void applyToShape(VsdxShape shape) {
        if ("Themed".equals(shape.ReflectionTrans)) {
            shape.ReflectionTrans = String.valueOf(1.0 - this.startOpacity.getFraction());
        }
        if ("Themed".equals(shape.ReflectionBlur)) {
            shape.ReflectionBlur = String.valueOf(this.blurRadius.getInches());
        }
        if ("Themed".equals(shape.ReflectionSize)) {
            shape.ReflectionSize = String.valueOf(this.endPosition.getFraction());
        }
        if ("Themed".equals(shape.ReflectionDist)) {
            shape.ReflectionDist = String.valueOf(this.distance.getInches());
        }
    }
}

