/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.Cache;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.TimeZoneHost;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DirectoryRowset;
import inform.agent.db.Row;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.utils.DirectoryRowsetCacheKey;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.scripts.BaseServerSideExecutable;
import inform.agent.scripts.CallableStatement;
import inform.agent.scripts.Closeables;
import inform.agent.scripts.ComponentList;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Database;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.Script;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.SqlStatement;
import inform.agent.scripts.Task;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.stat.DirectoryProfile;
import inform.common.SmartScriptableObject;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class AbstractScriptableTask
extends SmartScriptableObject
implements Task {
    protected final ComponentList components = new ComponentList();
    protected final BasicNode node;
    protected final ServerSideHost ssHost;
    protected final AbstractConnectionManager dbManager;
    protected final ParametersList parameters;
    protected final Constants constants;
    private final DoubleHash<Database> databases = new DoubleHash();
    private final byte[] constantsContent;
    private final Cache<DirectoryRowsetCacheKey, DirectoryRowset> directoryRowsetCache = new Cache();
    private final Collection<ScriptableObject> dynamical = new ArrayList<ScriptableObject>();
    private final AtomicInteger idGenerator = new AtomicInteger();
    private final Task parent;
    private Closeables closeables = null;
    private boolean datasourceProfile = false;
    private static final double D_RES = 1.0E-12;

    public AbstractScriptableTask(BasicNode node, Task parent, ServerSideHost ssHost, ParametersList parameters, Constants constants, byte[] constantsContent) throws IOException {
        this.node = node;
        this.parent = parent;
        this.ssHost = ssHost;
        this.dbManager = ConnectionManager.capture(-1, ssHost, this.getClass().getSimpleName());
        this.dbManager.rootConnectionMode(true);
        this.parameters = parameters;
        Constants constants2 = this.constants = constants != null ? constants : new Constants(ssHost.getUserID());
        if (constantsContent != null) {
            this.constants.load(constantsContent, (TimeZoneHost)ssHost);
        }
        this.constantsContent = constantsContent;
        parameters.setParentScope(this);
        this.defineFunctionProperties(BaseServerSideExecutable.systemJSFunctions, AbstractScriptableTask.class, 0);
        AbstractScriptableTask.putConstProperty(this, "parameters", parameters);
        AbstractScriptableTask.putConstProperty(this, "module", this);
        AbstractScriptableTask.putConstProperty(this, "METADATA_DB", 2.0);
        AbstractScriptableTask.putConstProperty(this, "TRANSACTION_READ_COMMITTED", AbstractConnectionManager.IsolationLevel.TRANSACTION_READ_COMMITTED.getValue());
        AbstractScriptableTask.putConstProperty(this, "TRANSACTION_REPEATABLE_READ", AbstractConnectionManager.IsolationLevel.TRANSACTION_REPEATABLE_READ.getValue());
        AbstractScriptableTask.putConstProperty(this, "TRANSACTION_SERIALIZABLE", AbstractConnectionManager.IsolationLevel.TRANSACTION_SERIALIZABLE.getValue());
    }

    @Override
    public double nodeId() {
        return this.node.getId();
    }

    @Override
    public Task parentTask() {
        return this.parent;
    }

    @Override
    public ServerSideHost getHost() {
        return this.ssHost;
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        return this.dbManager;
    }

    @Override
    public Database getDatabase(double dbId) {
        Database db = this.databases.get(dbId);
        if (db == null) {
            db = new Database(this, dbId);
            this.databases.add(db);
        }
        return db;
    }

    @Override
    public ParametersList getParameters() {
        return this.parameters;
    }

    @Override
    public Constants getConstants() {
        return this.constants;
    }

    @Override
    public byte[] getConstantsContent() {
        return this.constantsContent;
    }

    @Override
    public DirectoryRowset getDirectoryRowset(DirectoryRowsetCacheKey cacheKey) {
        DirectoryRowset result = this.directoryRowsetCache.get(cacheKey);
        if (result == null) {
            result = new DirectoryRowset(cacheKey);
            this.directoryRowsetCache.put(cacheKey, result);
        }
        return result;
    }

    @Override
    public int generateId() {
        return this.idGenerator.incrementAndGet();
    }

    @Override
    public void updateId(int id) {
        int current = this.idGenerator.get();
        if (current < id) {
            this.idGenerator.compareAndSet(current, id);
        }
    }

    @Override
    public Collection<ScriptableObject> getDynamical() {
        return this.dynamical;
    }

    @Override
    public void detach(Object o) {
    }

    @Override
    public void registerCloseable(Closeable closeable) {
        if (this.closeables == null) {
            this.closeables = new Closeables();
        }
        this.closeables.register(closeable);
    }

    @Override
    public void detachCloseable(Closeable closeable) {
        if (this.closeables != null) {
            this.closeables.detach(closeable);
        }
    }

    @Override
    public ComponentList getComponents() {
        return this.components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            for (ServerSideComponent c : this.components) {
                if (c instanceof Datasource) {
                    ((Datasource)c).close();
                    continue;
                }
                if (!(c instanceof Script)) continue;
                ((Script)c).close();
            }
            Iterator<ScriptableObject> i = this.dynamical.iterator();
            while (i.hasNext()) {
                ScriptableObject o = i.next();
                if (o instanceof Datasource) {
                    ((Datasource)o).internalClose();
                } else if (o instanceof Script) {
                    ((Script)o).internalClose();
                } else {
                    try {
                        if (o instanceof SqlStatement) {
                            ((SqlStatement)o).internalClose();
                        } else if (o instanceof CallableStatement) {
                            ((CallableStatement)o).internalClose();
                        }
                    }
                    catch (SQLException e) {
                        throw InformException.wrap(e);
                    }
                }
                i.remove();
            }
            if (this.closeables != null) {
                this.closeables.closeAll();
            }
        }
        finally {
            this.dbManager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(ExecuteAction<T> action) throws Exception {
        Context context = Core.asmoJsContextFactory.enterContext();
        try {
            ScriptableObject topLevelScope = ScriptableRequest.createTopLevelScope(context, this, this.ssHost, this.dbManager);
            this.setParentScope(topLevelScope);
            if (this.ssHost instanceof ScriptableHost) {
                ((ScriptableHost)((Object)this.ssHost)).setTopLevelScope(topLevelScope);
            }
            T result = action.execute(context);
            if (this.dbManager.hasModifications()) {
                StringBuilder message = new StringBuilder("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 ");
                message.append(this.node.toLogString());
                DoubleSet dsids = new DoubleSet();
                for (Row r : this.dbManager.getModifiedRows()) {
                    dsids.add(r.getTableDescriptor().getNodeId());
                }
                if (dsids.size() > 1) {
                    message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 ");
                } else {
                    message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ");
                }
                String delimiter = "";
                for (Cursor.Double i : dsids) {
                    message.append(String.format("%s%.0f", delimiter, i.value));
                    delimiter = ", ";
                }
                throw new InformException(message.toString());
            }
            this.dbManager.commit();
            T t = result;
            return t;
        }
        finally {
            Context.exit();
        }
    }

    public String toString() {
        String str = "%s(%s)";
        return String.format(str, this.getClassName(), NumberConverter.doubleToString(this.node.getId()));
    }

    public void startTransaction() {
    }

    public void commitTransaction() throws Exception {
        if (Ini.ReadonlyMode) {
            throw new InformException("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!");
        }
        this.ssHost.idle();
        this.dbManager.save(null);
        this.dbManager.commit();
    }

    public void rollbackTransaction() throws SQLException {
        this.ssHost.idle();
        this.dbManager.rollback();
    }

    public void save() throws Exception {
        if (Ini.ReadonlyMode) {
            throw new InformException("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!");
        }
        this.ssHost.idle();
        this.dbManager.save(null);
        this.ssHost.idle();
    }

    public void sleep(int n) throws InterruptedException {
        int sleep;
        do {
            this.ssHost.idle();
            sleep = Math.min(100, n);
            Thread.sleep(sleep);
        } while ((n -= sleep) > 0);
        this.ssHost.idle();
    }

    public Object createDatasource(double tableId, double searchId) throws InformException, IOException {
        if (Double.isNaN(tableId) && Double.isNaN(searchId)) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d ID \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0438\u043b\u0438 ID \u043f\u043e\u0438\u0441\u043a\u0430");
        }
        Datasource ds = new Datasource(null, this, tableId, searchId);
        this.dynamical.add(ds);
        ds.setParentScope(this);
        return ds;
    }

    public Object createScript(double nodeId) {
        try {
            Script s = new Script(this.ssHost.getSSContext(), this, nodeId);
            this.dynamical.add(s);
            s.setParentScope(this);
            return s;
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    public Scriptable createSqlStatement(double connectionID) throws SQLException {
        SqlStatement s = new SqlStatement(this, connectionID);
        this.dynamical.add(s);
        return s;
    }

    public Scriptable createCallableStatement(double connectionID) throws SQLException {
        CallableStatement s = new CallableStatement(this, connectionID);
        this.dynamical.add(s);
        return s;
    }

    public double roundTo(double value, int digits) {
        if (digits <= 0) {
            double shift = Math.pow(10.0, -digits);
            double d = Math.rint(value * shift);
            return d / shift;
        }
        double shift = Math.pow(10.0, digits);
        double d = Math.rint(value / shift);
        return d * shift;
    }

    public double Int(double val) {
        if (val > 0.0) {
            return Math.floor(val);
        }
        return Math.ceil(val);
    }

    public long getTickCount() {
        return Core.clock();
    }

    public boolean isNumberEquals(double a, double b, double eps) {
        return AbstractScriptableTask.sameValue(a, b, eps);
    }

    public boolean isNumberZero(double a, double eps) {
        if (Double.isNaN(eps) || eps == 0.0) {
            eps = 1.0E-12;
        }
        return Math.abs(a) <= eps;
    }

    public double simpleRoundTo(double value, int digits) {
        double vi;
        double shift = Math.pow(10.0, -digits);
        double v = Math.abs(value * shift);
        double frac = v - (vi = Math.floor(v));
        if (frac > 0.49999) {
            vi += 1.0;
        }
        double r = vi / shift;
        return value < 0.0 ? -r : r;
    }

    public String createGuid() {
        return UUID.randomUUID().toString().toUpperCase();
    }

    @Override
    public void setDatasourceProfile() {
        this.datasourceProfile = true;
    }

    @Override
    public boolean isDatasourceProfile() {
        return this.datasourceProfile;
    }

    @Override
    public DatasourceProfile addDatasourceProfile(int uid, double nodeId, double filterId, double moduleId) {
        return null;
    }

    @Override
    public DirectoryProfile addDirectory(double nodeId, double moduleId) {
        return null;
    }

    @Override
    public String getProfile() {
        return null;
    }

    public static boolean sameValue(double a, double b, double eps) {
        if (Double.isNaN(eps) || eps == 0.0) {
            eps = Math.max(Math.min(Math.abs(a), Math.abs(b)) * 1.0E-12, 1.0E-12);
        }
        if (a > b) {
            return a - b <= eps;
        }
        return b - a <= eps;
    }

    protected static interface ExecuteAction<T> {
        public T execute(Context var1) throws Exception;
    }
}

