/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.BigEndian;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.scripts.FileSystemLibrary;
import inform.common.Base64BinString;
import inform.common.Empty;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import org.mozilla.javascript.Context;

public class BinaryObject
extends SmartScriptableObject
implements FileSystemLibrary.BinaryReader {
    private byte[] buff;
    private int size;
    private int position;
    private boolean isBigEndian;

    private BinaryObject(byte[] data, boolean isBigEndian) {
        assert (data != null);
        this.buff = data;
        this.isBigEndian = isBigEndian;
        this.size = data.length;
    }

    public BinaryObject(byte[] data) {
        this(data == null ? Empty.byteArray : data, false);
    }

    public BinaryObject() {
        this(Empty.byteArray, false);
    }

    public byte[] getInternalBuffer() {
        return this.buff;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getEof() {
        return this.getPos() >= this.getSize();
    }

    @SmartScriptableObject.PropertyTag
    public int getSize() {
        return this.size;
    }

    @SmartScriptableObject.PropertyTag
    public int getPos() {
        return this.position;
    }

    @SmartScriptableObject.FunctionTag
    public void seek(int position) {
        this.position = position;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsBigEndian() {
        return this.isBigEndian;
    }

    public void setIsBigEndian(boolean isBigEndian) {
        this.isBigEndian = isBigEndian;
    }

    @SmartScriptableObject.FunctionTag
    public void clear() {
        this.buff = Empty.byteArray;
        this.size = 0;
        this.position = 0;
    }

    @SmartScriptableObject.FunctionTag
    public int readByte() throws IOException {
        if (this.getSize() - this.getPos() < 1) {
            throw new EOFException();
        }
        return this.buff[this.position++] & 0xFF;
    }

    @SmartScriptableObject.FunctionTag
    public void writeByte(int value) {
        this.ensureCapacity(this.position + 1);
        this.buff[this.position] = (byte)value;
        this.size = ++this.position;
    }

    @SmartScriptableObject.FunctionTag
    public short readInt16() throws IOException {
        if (this.getSize() - this.getPos() < 2) {
            throw new EOFException();
        }
        short r = this.isBigEndian ? BigEndian.getShort(this.buff, this.position) : LittleEndian.getShort(this.buff, this.position);
        this.position += 2;
        return r;
    }

    @SmartScriptableObject.FunctionTag
    public void writeInt16(int value) {
        this.ensureCapacity(this.position + 2);
        if (this.isBigEndian) {
            BigEndian.setShort((short)value, this.buff, this.position);
        } else {
            LittleEndian.setShort((short)value, this.buff, this.position);
        }
        this.size = this.position += 2;
    }

    @SmartScriptableObject.FunctionTag
    public int readInt32() throws IOException {
        if (this.getSize() - this.getPos() < 4) {
            throw new EOFException();
        }
        int r = this.isBigEndian ? BigEndian.getInt(this.buff, this.position) : LittleEndian.getInt(this.buff, this.position);
        this.position += 4;
        return r;
    }

    @SmartScriptableObject.FunctionTag
    public void writeInt32(int value) {
        this.ensureCapacity(this.position + 4);
        if (this.isBigEndian) {
            BigEndian.setInteger(value, this.buff, this.position);
        } else {
            LittleEndian.setInteger(value, this.buff, this.position);
        }
        this.size = this.position += 4;
    }

    @SmartScriptableObject.FunctionTag
    public long readInt64() throws IOException {
        if (this.getSize() - this.getPos() < 2) {
            throw new EOFException();
        }
        long r = this.isBigEndian ? BigEndian.getLong(this.buff, this.position) : LittleEndian.getLong(this.buff, this.position);
        this.position += 8;
        return r;
    }

    @SmartScriptableObject.FunctionTag
    public void writeInt64(double value) {
        this.ensureCapacity(this.position + 8);
        if (this.isBigEndian) {
            BigEndian.setLong((long)value, this.buff, this.position);
        } else {
            LittleEndian.setLong((long)value, this.buff, this.position);
        }
        this.size = this.position += 8;
    }

    @SmartScriptableObject.FunctionTag
    public long readUInt32() throws IOException {
        return (long)this.readInt32() & 0xFFFFFFFFL;
    }

    @SmartScriptableObject.FunctionTag
    public void writeUInt32(int value) {
        this.writeInt32(value);
    }

    @SmartScriptableObject.FunctionTag
    public float readSingle() throws IOException {
        return Float.intBitsToFloat(this.readInt32());
    }

    @SmartScriptableObject.FunctionTag
    public void writeSingle(double value) {
        this.writeInt32(Float.floatToRawIntBits((float)value));
    }

    @SmartScriptableObject.FunctionTag
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readInt64());
    }

    @SmartScriptableObject.FunctionTag
    public void writeDouble(double value) {
        this.writeInt64(Double.doubleToRawLongBits(value));
    }

    private void ensureCapacity(int capacity) {
        if (this.buff.length >= capacity) {
            return;
        }
        int nc = this.buff.length;
        while ((nc = nc * 2 + 1) < capacity) {
        }
        this.buff = Arrays.copyOf(this.buff, nc);
    }

    @SmartScriptableObject.FunctionTag
    public void loadFromStream(Object arg) throws IOException {
        InputStream in = (InputStream)Context.jsToJava(arg, InputStream.class);
        this.position = 0;
        int p = 0;
        while (true) {
            this.ensureCapacity(p + 4096);
            int r = in.read(this.buff, p, this.buff.length - p);
            if (r < 0) break;
            p += r;
        }
        this.size = p;
    }

    @SmartScriptableObject.FunctionTag
    public void saveToStream(Object arg) throws IOException {
        OutputStream out = (OutputStream)Context.jsToJava(arg, OutputStream.class);
        out.write(this.buff, 0, this.size);
    }

    @SmartScriptableObject.FunctionTag
    public void loadFromFile(String pathname) throws IOException, InformException {
        try (FileInputStream fin = new FileInputStream(Core.mountfs.resolve(new File(pathname)));){
            this.loadFromStream(fin);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void saveToFile(String pathname) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(Core.mountfs.resolve(new File(pathname)));){
            this.saveToStream(fout);
        }
    }

    @SmartScriptableObject.FunctionTag
    public String toBase64(Object arg) {
        return Base64BinString.Encode(this.buff, this.size);
    }

    public byte[] toByteArray() {
        if (this.size == this.buff.length) {
            return this.buff;
        }
        return Arrays.copyOf(this.buff, this.size);
    }

    @Override
    public String getClassName() {
        return "BinaryObject";
    }

    @SmartScriptableObject.FunctionTag
    public boolean equals(Object obj) {
        if (obj instanceof BinaryObject) {
            BinaryObject bin = (BinaryObject)obj;
            if (this.size != bin.size) {
                return false;
            }
            int length = this.size;
            byte[] a = this.buff;
            byte[] b = bin.buff;
            for (int i = 0; i < length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @SmartScriptableObject.FunctionTag
    public boolean isEqual(Object obj) {
        return this.equals(obj);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int r = Math.min(this.size - this.position, length);
        if (r == 0) {
            return -1;
        }
        System.arraycopy(this.buff, this.position, buffer, offset, r);
        this.position += r;
        return r;
    }

    @SmartScriptableObject.FunctionTag
    public Object inflate() throws IOException {
        InputStream input = BinaryObject.toInputStream(this);
        ByteArrayOutputStream inflated = new ByteArrayOutputStream();
        try (InflaterInputStream compression = new InflaterInputStream(input);){
            byte[] buffer = new byte[4096];
            int length = 0;
            do {
                if ((length = compression.read(buffer, 0, buffer.length)) <= 0) continue;
                inflated.write(buffer, 0, length);
            } while (length >= 0);
        }
        inflated.flush();
        return new BinaryObject(inflated.toByteArray());
    }

    public static InputStream toInputStream(BinaryObject obj) {
        return new ByteArrayInputStream(obj.buff, 0, obj.size);
    }
}

