/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.Core;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;

public class Closeables {
    private ArrayList<Closeable> closeables;

    public void register(Closeable c) {
        if (this.closeables == null) {
            this.closeables = new ArrayList();
        }
        this.closeables.add(c);
    }

    public void detach(Closeable c) {
        if (this.closeables == null) {
            return;
        }
        this.closeables.remove(c);
    }

    public void closeAll() {
        if (this.closeables == null) {
            return;
        }
        IOException exception = null;
        int cnt = 0;
        for (int i = this.closeables.size() - 1; i >= 0; --i) {
            try {
                this.closeables.get(i).close();
                continue;
            }
            catch (IOException e) {
                ++cnt;
                if (exception == null) {
                    exception = e;
                    continue;
                }
                Core.logger.error("close-error", e);
            }
        }
        if (exception != null) {
            if (cnt == 1) {
                throw InformException.wrap(exception);
            }
            Core.logger.error("close-error", exception);
            throw new InformException(String.format("\u041e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 %d \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u044b \u0432 \u043b\u043e\u0433 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.", cnt));
        }
        this.closeables.clear();
    }
}

