/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.scripts.spreadsheets.excel.ExcelWorkbook;
import inform.agent.scripts.textutils.TextExtractor;
import inform.common.SmartScriptableObject;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.mozilla.javascript.Scriptable;

public class ExcelLibrary
extends SmartScriptableObject {
    public static final int BORDERSIDE_TOP = 0;
    public static final int BORDERSIDE_RIGHT = 1;
    public static final int BORDERSIDE_BOTTOM = 2;
    public static final int BORDERSIDE_LEFT = 3;
    public static final int BORDERSIDE_ALL = 4;
    public static final int CELLTYPE_UNKNOWN = 0;
    public static final int CELLTYPE_BLANK = 1;
    public static final int CELLTYPE_NUMERIC = 2;
    public static final int CELLTYPE_STRING = 3;
    public static final int CELLTYPE_BOOLEAN = 4;
    public static final int CELLTYPE_DATE = 5;
    public static final int CELLTYPE_ERROR = 6;

    public ExcelLibrary(Scriptable scope) {
        this.setParentScope(scope);
        ExcelLibrary.putConstProperty(this, "FONT_OFFSET_NONE", (short)0);
        ExcelLibrary.putConstProperty(this, "FONT_OFFSET_SUBSCRIPT", (short)2);
        ExcelLibrary.putConstProperty(this, "FONT_OFFSET_SUPERSCRIPT", (short)1);
        ExcelLibrary.putConstProperty(this, "BORDER_SIDE_TOP", 0);
        ExcelLibrary.putConstProperty(this, "BORDER_SIDE_RIGHT", 1);
        ExcelLibrary.putConstProperty(this, "BORDER_SIDE_BOTTOM", 2);
        ExcelLibrary.putConstProperty(this, "BORDER_SIDE_LEFT", 3);
        ExcelLibrary.putConstProperty(this, "BORDER_SIDE_ALL", 4);
        ExcelLibrary.putConstProperty(this, "CELL_TYPE_UNKNOWN", 0);
        ExcelLibrary.putConstProperty(this, "CELL_TYPE_NUMERIC", 2);
        ExcelLibrary.putConstProperty(this, "CELL_TYPE_STRING", 3);
        ExcelLibrary.putConstProperty(this, "CELL_TYPE_BOOLEAN", 4);
        ExcelLibrary.putConstProperty(this, "CELL_TYPE_ERROR", 6);
        ExcelLibrary.putConstProperty(this, "CELL_TYPE_BLANK", 1);
        ExcelLibrary.putConstProperty(this, "CELL_TYPE_DATE", 5);
        for (FontUnderline fontUnderline : FontUnderline.values()) {
            ExcelLibrary.putConstProperty(this, "FONT_UNDERLINE_" + fontUnderline.name(), fontUnderline.getValue());
        }
        for (FontUnderline fontUnderline : HorizontalAlignment.values()) {
            ExcelLibrary.putConstProperty(this, "HORIZONTAL_ALIGN_" + fontUnderline.name(), fontUnderline.getCode());
        }
        for (FontUnderline fontUnderline : VerticalAlignment.values()) {
            ExcelLibrary.putConstProperty(this, "VERTICAL_ALIGN_" + fontUnderline.name(), fontUnderline.getCode());
        }
        for (FontUnderline fontUnderline : BorderStyle.values()) {
            ExcelLibrary.putConstProperty(this, "BORDER_STYLE_" + fontUnderline.name(), fontUnderline.getCode());
        }
        for (FontUnderline fontUnderline : FillPatternType.values()) {
            ExcelLibrary.putConstProperty(this, "FILL_" + fontUnderline.name(), fontUnderline.getCode());
        }
    }

    @Override
    public String getClassName() {
        return "Excel";
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook createWorkbook() {
        return ExcelWorkbook.createExcelWorkbook(this);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook createXlsWorkbook() {
        return ExcelWorkbook.createExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook createXlsxWorkbook() {
        return ExcelWorkbook.createExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook openWorkbook(Object dataSource) throws Exception {
        return ExcelWorkbook.openExcelWorkbook(this, dataSource);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook openXlsWorkbook(Object dataSource) throws Exception {
        return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS, dataSource);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook openXlsxWorkbook(Object dataSource) throws Exception {
        return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX, dataSource);
    }
}

