/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ScriptableBinaryFileReader;
import inform.agent.scripts.ScriptableBinaryFileWriter;
import inform.agent.scripts.ScriptableTextFileReader;
import inform.agent.scripts.ScriptableTextFileWriter;
import inform.agent.scripts.zip.GZipReader;
import inform.agent.scripts.zip.GZipWriter;
import inform.agent.scripts.zip.ZipReader;
import inform.agent.scripts.zip.ZipWriter;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.zip.ZipOutputStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class FileSystemLibrary
extends SmartScriptableObject {
    public static final Charset DEFAULT_CHARSET = Charset.forName("Cp1251");

    public FileSystemLibrary(Scriptable scope) {
        this.setParentScope(scope);
    }

    @Override
    public String getClassName() {
        return "FileSystem";
    }

    private File toFile(String pathname) throws IOException {
        return Core.mountfs.resolve(new File(pathname));
    }

    @SmartScriptableObject.FunctionTag
    public boolean deleteFile(String fileName) throws IOException {
        if (!this.isFileExists(fileName)) {
            return false;
        }
        File f = this.toFile(fileName);
        return f.delete();
    }

    @SmartScriptableObject.FunctionTag
    public static Object extractFileName(String filename) throws IOException {
        int lastSlashIndex = filename.lastIndexOf("/");
        int lastDotIndex = filename.lastIndexOf(".");
        if (lastSlashIndex != -1 && lastDotIndex != -1 && lastSlashIndex < filename.length() - 1) {
            return filename.substring(lastSlashIndex + 1);
        }
        return "";
    }

    @SmartScriptableObject.FunctionTag
    public static Object extractFilePath(String filename) throws IOException {
        int lastSlashIndex = filename.lastIndexOf("/");
        int lastDotIndex = filename.lastIndexOf(".");
        if (lastSlashIndex != -1 && lastDotIndex != -1 && lastSlashIndex < filename.length() - 1) {
            return filename.substring(0, lastSlashIndex + 1);
        }
        return "";
    }

    @SmartScriptableObject.FunctionTag
    public static Object extractFileExtention(String filename) throws IOException {
        int lastDotIndex = filename.lastIndexOf(".");
        if (lastDotIndex != -1 && lastDotIndex < filename.length() - 1) {
            return filename.substring(lastDotIndex);
        }
        return "";
    }

    @SmartScriptableObject.FunctionTag
    public boolean isFileExists(String pathname) throws IOException {
        File f = this.toFile(pathname);
        return f.exists() && !f.isDirectory();
    }

    @SmartScriptableObject.FunctionTag
    public boolean makeDirectoryPath(String pathname) throws IOException {
        File dir = this.toFile(pathname);
        return dir.mkdirs();
    }

    @SmartScriptableObject.FunctionTag
    public boolean renameFile(String srcPathName, String dstPathName) throws IOException {
        File srcFile = this.toFile(srcPathName);
        if (!srcFile.exists()) {
            throw new InformException("\u0424\u0430\u0439\u043b/\u041a\u0430\u0442\u0430\u043b\u043e\u0433 " + srcFile.getName() + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        File dstFile = this.toFile(dstPathName);
        if (dstFile.exists()) {
            throw new InformException("\u0424\u0430\u0439\u043b/\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0438\u043c\u0435\u043d\u0435\u043c (" + dstFile.getName() + ") \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        return srcFile.renameTo(dstFile);
    }

    @SmartScriptableObject.FunctionTag
    public boolean removeDirectory(String pathname) throws IOException {
        File dir = this.toFile(pathname);
        if (dir.isDirectory()) {
            return dir.delete();
        }
        return false;
    }

    @SmartScriptableObject.FunctionTag
    public boolean isDirectoryExists(String pathname) throws IOException {
        File f = this.toFile(pathname);
        return f.exists() && f.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public static Object copyFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, Exception, InformException {
        FileSystemLibrary fileSysLib = (FileSystemLibrary)thisObj;
        if (args.length < 2) {
            throw new InformException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432!");
        }
        String sourcePath = args[0].toString();
        String destPath = args[1].toString();
        boolean fileOverwrite = true;
        if (args.length > 2) {
            fileOverwrite = Boolean.parseBoolean(args[2].toString());
        }
        if (sourcePath.equalsIgnoreCase(destPath)) {
            throw new InformException("\u041d\u0435\u043b\u044c\u0437\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u0430\u043c \u0432 \u0441\u0435\u0431\u044f!");
        }
        if (!fileSysLib.isFileExists(sourcePath)) {
            throw new InformException("\u0424\u0430\u0439\u043b '" + sourcePath + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
        if (!fileSysLib.isFileExists(destPath) || fileOverwrite) {
            AbstractInterruptibleChannel sourceChannel = null;
            AbstractInterruptibleChannel destChannel = null;
            try {
                sourceChannel = new FileInputStream(fileSysLib.toFile(sourcePath)).getChannel();
                destChannel = new FileOutputStream(fileSysLib.toFile(destPath)).getChannel();
                ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            }
            finally {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (destChannel != null) {
                    destChannel.close();
                }
            }
        }
        return Undefined.instance;
    }

    public static String resolveUtf16Trable(String codePage) {
        return codePage.toLowerCase().replace("utf16", "utf-16").replace("utf-16", "utf-16le");
    }

    static Charset charsetByName(String codepage) throws Exception {
        try {
            return Charset.forName(FileSystemLibrary.resolveUtf16Trable(codepage));
        }
        catch (IllegalArgumentException e) {
            throw new Exception("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0438: " + codepage, e);
        }
    }

    @SmartScriptableObject.FunctionTag
    public static Object createTextFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, Exception, InformException {
        FileSystemLibrary fileSysLib = (FileSystemLibrary)thisObj;
        if (args.length == 0) {
            throw new InformException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432!");
        }
        String pathname = args[0].toString();
        Charset charset = DEFAULT_CHARSET;
        if (args.length > 1) {
            charset = FileSystemLibrary.charsetByName(args[1].toString());
        }
        File file = fileSysLib.toFile(pathname);
        return new ScriptableTextFileWriter(thisObj, new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset), pathname);
    }

    @SmartScriptableObject.FunctionTag
    public Object openTextFile(Object obj, Object cs) throws IOException {
        Charset charset;
        Charset charset2 = charset = cs instanceof String ? Charset.forName(FileSystemLibrary.resolveUtf16Trable((String)cs)) : DEFAULT_CHARSET;
        if (obj instanceof String) {
            String pathname = (String)obj;
            return new ScriptableTextFileReader((Scriptable)this, new InputStreamReader((InputStream)new FileInputStream(this.toFile(pathname)), charset));
        }
        if (obj instanceof BinaryObject) {
            BinaryObject blob = (BinaryObject)obj;
            ByteArrayInputStream stream = new ByteArrayInputStream(blob.toByteArray());
            return new ScriptableTextFileReader((Scriptable)this, new InputStreamReader((InputStream)stream, charset));
        }
        throw new InformException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b!");
    }

    @SmartScriptableObject.FunctionTag
    public Object openBinaryFile(String pathname) throws IOException {
        return new ScriptableBinaryFileReader((Scriptable)this, new FileInputStream(this.toFile(pathname)));
    }

    @SmartScriptableObject.FunctionTag
    public Object readDirectory(String pathname) throws IOException {
        File[] files = this.toFile(pathname).listFiles();
        Object[] names = new String[files == null ? 0 : files.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = files[i].getName();
        }
        return new NativeArray(names);
    }

    @SmartScriptableObject.FunctionTag
    public String determineFileType(Object reader) throws IOException {
        byte[] buf = new byte[10];
        ((BinaryReader)reader).read(buf, 0, buf.length);
        return FileSystemLibrary.getFileType(buf);
    }

    @SmartScriptableObject.FunctionTag
    public Object createBinaryFile(String pathname) throws IOException {
        return new ScriptableBinaryFileWriter(new FileOutputStream(this.toFile(pathname)));
    }

    public static String getFileType(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        if (bytes.length >= 4 && bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "png";
        }
        if (bytes.length >= 3 && bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "gif";
        }
        if (bytes.length >= 2 && bytes[0] == 66 && bytes[1] == 77) {
            return "bmp";
        }
        if (bytes.length >= 10 && bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "jpeg";
        }
        return "";
    }

    @SmartScriptableObject.FunctionTag
    public Object createZipWriter(String fileName) throws IOException, InformException {
        if (fileName == null || fileName.isEmpty()) {
            return new ZipWriter();
        }
        return new ZipWriter(new ZipOutputStream(new FileOutputStream(this.toFile(fileName))));
    }

    private Object createZipReaderFromDatasourceField(DatasetField field, Charset charset) throws Exception, IOException, InformException {
        if (field.getIsNull()) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c zip-\u0430\u0440\u0445\u0438\u0432 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        switch (field.getDataType()) {
            case BLOB: {
                BinaryObject blobBinary = null;
                blobBinary = field instanceof Parameter ? ((Parameter)field).getAsBinary() : ((BlobField)field).getAsBinary();
                return this.createZipReaderFromBinaryObject(blobBinary, charset);
            }
            case FILE: {
                return this.createZipReaderFromBlobFile((BlobFileField)field, charset);
            }
        }
        throw new InformException(String.format("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c zip-\u0430\u0440\u0445\u0438\u0432 \u0438\u0437 \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'", new Object[]{field.getDataType()}));
    }

    private Object createZipReaderFromBinaryObject(BinaryObject binary, Charset charset) throws IOException, InformException {
        if (binary == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
        }
        File file = File.createTempFile("blob_zip", ".zip");
        String path = file.getPath();
        try (FileOutputStream fos = new FileOutputStream(path);){
            fos.write(binary.toByteArray());
            fos.flush();
        }
        return new ZipReader(file, charset);
    }

    private Object createZipReaderFromBlobFile(BlobFileField field, Charset charset) throws IOException, InformException {
        File file = field.getBlobFile();
        if (file == null) {
            file = File.createTempFile("blob_zip", ".zip");
        }
        return new ZipReader(file, charset);
    }

    private Charset toZipCharset(Object codepage) {
        if (codepage == null || codepage == Undefined.instance) {
            return ZipReader.DEFAULT_CHARSET;
        }
        String cp = codepage.toString();
        return Charset.forName(cp);
    }

    @SmartScriptableObject.FunctionTag
    public Object createZipReader(Object obj, Object codepage) throws Exception, IOException, InformException {
        Charset charset = this.toZipCharset(codepage);
        if (obj instanceof String) {
            return new ZipReader((String)obj, charset);
        }
        if (obj instanceof BinaryObject) {
            return this.createZipReaderFromBinaryObject((BinaryObject)obj, charset);
        }
        if (obj instanceof DatasetField) {
            return this.createZipReaderFromDatasourceField((DatasetField)obj, charset);
        }
        String MESSAGE_BADTYPE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c zip-\u0430\u0440\u0445\u0438\u0432 \u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0442\u0438\u043f\u043e\u043c '%s'. \u041f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c, \u043f\u043e\u043b\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b (\u0441 \u0442\u0438\u043f\u043e\u043c Blob \u0438\u043b\u0438 BlobFile) \u0438\u043b\u0438 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u0444\u0430\u0439\u043b\u0430.";
        throw new InformException(String.format(MESSAGE_BADTYPE, obj == null ? "null" : obj.getClass().getName()));
    }

    @SmartScriptableObject.FunctionTag
    public Object createGZipReader(String fileName) throws IOException, InformException {
        return new GZipReader(fileName);
    }

    @SmartScriptableObject.FunctionTag
    public Object createGZipWriter(String fileName) throws IOException, InformException {
        return new GZipWriter(fileName);
    }

    @SmartScriptableObject.FunctionTag
    public EnumDirectory enumDirectory(String pathname) throws IOException {
        File f = this.toFile(pathname);
        if (!f.exists() && !f.isDirectory()) {
            return null;
        }
        return new EnumDirectory(this, pathname, f);
    }

    private class EnumDirectory
    extends SmartScriptableObject {
        private final File[] files;
        private int index = -1;
        private final String path;

        public EnumDirectory(Scriptable scope, String path, File file) {
            this.setParentScope(scope);
            this.path = path;
            this.files = file.listFiles();
        }

        @Override
        public String getClassName() {
            return "EnumDirectory";
        }

        private File currentFile() {
            return this.index >= 0 && this.index < this.files.length ? this.files[this.index] : null;
        }

        @SmartScriptableObject.PropertyTag
        public String getName() {
            File f = this.currentFile();
            return f != null ? f.getName() : null;
        }

        @SmartScriptableObject.PropertyTag
        public String getPathName() {
            File f = this.currentFile();
            return f != null ? this.path + File.separator + f.getName() : null;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getIsDirectory() {
            File f = this.currentFile();
            return f != null ? f.isDirectory() : false;
        }

        @SmartScriptableObject.PropertyTag
        public double getSize() {
            File f = this.currentFile();
            return f != null && !f.isDirectory() ? (double)f.length() : 0.0;
        }

        @SmartScriptableObject.PropertyTag
        public double getModificationTime() {
            File f = this.currentFile();
            return f != null ? DateTime.fromUnixTime(f.lastModified()) : 0.0;
        }

        @SmartScriptableObject.FunctionTag
        public void reset() {
            this.index = -1;
        }

        @SmartScriptableObject.FunctionTag
        public boolean next() {
            ++this.index;
            return this.index < this.files.length;
        }

        @SmartScriptableObject.FunctionTag
        public EnumDirectory enumDirectory() {
            File f = this.currentFile();
            if (f == null || !f.isDirectory()) {
                return null;
            }
            return new EnumDirectory(this, this.path + File.separator + f.getName(), f);
        }
    }

    public static interface BinaryReader {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface TextReader {
        public int read(char[] var1, int var2, int var3) throws IOException;
    }
}

