/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.ServerSideHost;
import inform.agent.web.utils.Font;
import inform.common.SmartScriptableObject;
import org.mozilla.javascript.Scriptable;

public class FontsLibrary
extends SmartScriptableObject {
    public static final int FONT_BOLD = 1;
    public static final int FONT_ITALIC = 2;
    private final ServerSideHost ssHost;

    FontsLibrary(Scriptable scope, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.setParentScope(scope);
        for (FontStyle fontStyle : FontStyle.values()) {
            FontsLibrary.putConstProperty(this, fontStyle.name(), fontStyle.id);
        }
        for (Enum enum_ : FontName.values()) {
            FontsLibrary.putConstProperty(this, enum_.name(), ((FontName)enum_).id);
        }
    }

    @Override
    public String getClassName() {
        return "Fonts";
    }

    @SmartScriptableObject.FunctionTag
    public Font createFont() {
        return new Font(this.getParentScope());
    }

    public static enum FontName {
        DEFAULT_FONT_NAME("Times New Roman"),
        SANS_SERIF_FONT_NAME("Arial"),
        SERIF_FONT_NAME("Times New Roman"),
        MONOSPACE_FONT_NAME("Courier New");

        public final String id;

        private FontName(String id) {
            this.id = id;
        }
    }

    public static enum FontStyle {
        DEFAULT_FONT_STYLE(0),
        BOLD(1),
        ITALIC(2),
        UNDERLINE(4),
        STRIKEOUT(8);

        public final int id;

        private FontStyle(int id) {
            this.id = id;
        }
    }

    public static enum FontSize {
        DEFAULT_FONT_SIZE(10);

        public final int id;

        private FontSize(int id) {
            this.id = id;
        }
    }
}

