/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.LogLibrary;
import inform.agent.scripts.QueryNodeRequestException;
import inform.agent.scripts.RequestStateDialog;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.SysLogLibrary;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryKind;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GetSqlQueryNodeRequest
extends ScriptableRequest {
    private byte[] bindedParametersContent = null;
    private byte[] constantsContent = null;
    private byte[] queryContent = null;
    protected int nullSortType = 0;
    protected final RequestResult result = new RequestResult(this);
    protected AbstractConnectionManager dbManager;
    protected Query query = null;
    boolean parameterizedTable = false;

    public GetSqlQueryNodeRequest(RequestHeader rq) {
        super(rq);
    }

    protected void execute(Context context) throws Exception {
        String sqlText = this.query.generateSqlText(context, null);
        StringBuilder paramText = new StringBuilder();
        this.query.getSqlParameters().getLog(paramText);
        TaggedWriter out = this.result.getWriter();
        out.putAnsi(1, sqlText);
        StringBuilder debugBuilder = this.query.getDebugBuilder();
        if (debugBuilder != null && debugBuilder.length() != 0) {
            paramText.append("\r\n/*\r\n").append((CharSequence)debugBuilder).append("\r\n*/");
        }
        out.putAnsiIf(2, paramText.toString());
        out.flush();
        this.result.sendResult();
    }

    protected void executeInContext(Context context) throws Throwable {
        this.setConstants(this.query.getConstants());
        ScriptableObject.putConstProperty(this.query, "requestState", new RequestStateDialog(this));
        ScriptableObject.putConstProperty(this.query, "Log", new LogLibrary((Scriptable)this.query, this));
        ScriptableObject.putConstProperty(this.query, "SysLog", new SysLogLibrary((Scriptable)this.query, this));
        this.execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        Context context = Core.asmoJsContextFactory.enterContext();
        this.dbManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:GetSqlQueryNodeRequest");
        Throwable exception = null;
        try {
            try {
                this.topLevelScope = context.initStandardObjects();
                Node nodeInfo = MtdEngine.getValidNode(this.getNodeID());
                this.query = new Query((ServerSideHost)this, this.nullSortType);
                try {
                    this.loadRequestContent(this.createRequestContentReader());
                }
                catch (QueryNodeRequestException e) {
                    if (e.code == 0) {
                        throw e;
                    }
                    Core.logger.error(null, e);
                }
                this.query.setParentScope(this.getTopLevelScope());
                if (this.parameterizedTable) {
                    this.query.createParameterizedTable(this.getNodeID());
                } else if (this.queryContent != null) {
                    this.query.loadFromStream(this.getNodeID(), nodeInfo, new TaggedReader(this.queryContent));
                } else {
                    this.query.loadFromMetadata(this.getNodeID(), nodeInfo);
                }
                if (this.constantsContent != null) {
                    this.query.setConstantsContent(this.constantsContent);
                }
                if (this.bindedParametersContent != null) {
                    this.query.getInputParameters().loadParametersValues(this.query.getConstants(), new TaggedReader(this.bindedParametersContent), this);
                }
                this.executeInContext(context);
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
                exception = ex;
            }
        }
        finally {
            try {
                this.dbManager.release();
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            Context.exit();
            if (exception != null) {
                throw exception;
            }
        }
    }

    protected void loadTag(int tag, TaggedReader reader) throws IOException, InformException, QueryNodeRequestException {
        switch (tag) {
            case 14: {
                this.queryContent = reader.getRaw();
                break;
            }
            case 32: {
                this.constantsContent = new byte[reader.getCurrentTagSize()];
                reader.getRaw(this.constantsContent, this.constantsContent.length);
                break;
            }
            case 36: {
                this.bindedParametersContent = new byte[reader.getCurrentTagSize()];
                reader.getRaw(this.bindedParametersContent, this.bindedParametersContent.length);
                break;
            }
            case 30: {
                this.query.setInlineParams(true);
                break;
            }
            case 34: {
                this.query.setDebugBuilder(new StringBuilder());
                break;
            }
            case 45: {
                this.parameterizedTable = true;
                break;
            }
            case 12: {
                this.query.addSortField(reader);
                break;
            }
            case 23: {
                int limit = reader.getInt();
                this.query.setFetchLimit(limit);
                break;
            }
            case 48: {
                this.query.setPagedFetch();
                break;
            }
            case 22: {
                if (this.query.getQueryKind() == QueryKind.SQL) {
                    this.query.throwError("\u0421\u0432\u044f\u0437\u044c \u0438 \u0441\u0432\u044f\u0437\u044c \u043f\u043e \u043f\u043e\u043b\u044f\u043c \u0441 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0441 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u043c \u0432 \u0432\u0438\u0434\u0435 SQL \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f");
                }
                TaggedReader stream = reader.getStreamReader();
                LinkDescriptor relations = new LinkDescriptor();
                relations.loadRelations(stream);
                this.query.setTableRelations(relations);
                break;
            }
            case 50: {
                this.nullSortType = reader.getInt();
                this.query.setNullSortKind(this.nullSortType);
            }
        }
    }

    private void loadRequestContent(TaggedReader reader) throws IOException, InformException, QueryNodeRequestException {
        int tag;
        do {
            tag = reader.getNextTag();
            this.loadTag(tag, reader);
        } while (tag != 0);
    }
}

