/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.ServerSideHost;
import inform.agent.db.types.ValueCaster;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class LogLibrary
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"write", "writeLine", "clear"};
    private ServerSideHost ssHost;
    private StringBuilder logLine = new StringBuilder();

    LogLibrary(Scriptable scope, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    @Override
    public String getClassName() {
        return "Log";
    }

    public String toString() {
        return this.getClassName();
    }

    public static Object write(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException, Exception {
        LogLibrary lib = (LogLibrary)thisObj;
        lib.appendToHostLogLine(args);
        return Undefined.instance;
    }

    public static Object writeLine(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        LogLibrary lib = (LogLibrary)thisObj;
        lib.appendToLogLine(args);
        String msg = lib.logLine.toString();
        lib.logLine.setLength(0);
        lib.ssHost.writeLogLine(msg);
        return Undefined.instance;
    }

    public void clear() {
    }

    private void appendToLogLine(Object[] args) throws InformException {
        String delimiter = "";
        for (Object o : args) {
            this.logLine.append(delimiter);
            this.logLine.append(ValueCaster.toString(o));
            delimiter = " ";
        }
    }

    private void appendToHostLogLine(Object[] args) throws InformException, Exception {
        String delimiter = "";
        for (Object o : args) {
            this.ssHost.appendToLog(delimiter);
            this.ssHost.appendToLog(ValueCaster.toString(o));
            delimiter = " ";
        }
    }
}

