/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.document.HTMLParser;
import inform.agent.document.IObserverPicture;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.MailAttachment;
import inform.agent.scripts.MailAttachmentsList;
import inform.agent.scripts.MailRecipient;
import inform.agent.scripts.MailRecipientList;
import inform.agent.scripts.POP3Connection;
import jakarta.mail.Address;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Enumeration;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.universalchardet.UniversalDetector;

public class MailMessage
extends ScriptableObject
implements IObserverPicture {
    private static final String[] availJSFunctionsNames = new String[]{"markDelete", "toBinary", "saveToBlob", "toAsmoDoc"};
    private static final String[] jsRWProperties = new String[]{"deleted", "text", "textHtml", "subject", "fromAddress", "toAddress", "ccAddress", "bccAddress", "attachments"};
    private static final String[] jsRProperties = new String[]{"dateTime", "headers", "messageID", "toAddressList", "ccAddressList", "bccAddressList", "fromAddressList"};
    private int number = -1;
    private String text = "";
    private String textHtml = "";
    private String subject = "";
    private String toAddress = "";
    private String ccAddress = "";
    private String bccAddress = "";
    private String fromAddress = "";
    private MailRecipientList toAddressList;
    private MailRecipientList ccAddressList;
    private MailRecipientList bccAddressList;
    private MailRecipientList fromAddressList;
    private Date dateTime;
    private double dateTimeValue = 0.0;
    private POP3Connection pop3conn = null;
    private Message msg = null;
    private boolean loaded = false;
    private boolean deleted;
    private MailAttachmentsList attachments = new MailAttachmentsList();
    private final Headers headers;
    private String messageId = null;
    int dumpPartLevel = 0;
    boolean envelopeDumped;

    MailMessage(Message msg) {
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
        for (String propertyName : jsRWProperties) {
            this.defineProperty(propertyName, MailMessage.class, 0);
        }
        for (String propertyName : jsRProperties) {
            this.defineProperty(propertyName, MailMessage.class, 1);
        }
        this.msg = msg;
        this.headers = new Headers();
        this.initHeaders(msg);
        MailMessage.putConstProperty(this, "headers", this.headers);
    }

    public Message internalMessage() {
        return this.msg;
    }

    public void initHeaders(Message msg) {
        if (msg == null) {
            return;
        }
        try {
            Enumeration<Header> msgHeaders = msg.getAllHeaders();
            if (msgHeaders != null) {
                while (msgHeaders.hasMoreElements()) {
                    Header h = msgHeaders.nextElement();
                    if (h == null) continue;
                    MailMessage.putProperty((Scriptable)this.headers, MimeUtility.decodeText(h.getName()), (Object)MimeUtility.decodeText(h.getValue()));
                }
            }
        }
        catch (MessagingException | UnsupportedEncodingException ex) {
            throw InformException.wrap(ex);
        }
    }

    private void load() throws Exception {
        if (!this.loaded && this.msg != null) {
            this.loaded = true;
            this.dumpPartLevel = 0;
            MailMessage.dumpPart(this.msg, this);
            for (MailAttachment a : this.attachments.getAttc()) {
                a.decodeFileName();
            }
        }
    }

    @Override
    public String getClassName() {
        return "MailMessage";
    }

    public void setText(String value) {
        this.text = value;
    }

    public String getText() throws Exception {
        this.load();
        return this.text;
    }

    public boolean isTextPresent() throws Exception {
        this.load();
        return this.text != null && !this.text.isEmpty();
    }

    public String getTextHtml() throws Exception {
        this.load();
        return this.textHtml;
    }

    public void setTextHtml(String textHtml) {
        this.textHtml = textHtml;
    }

    public boolean isTextHtmlPresent() throws Exception {
        this.load();
        return this.textHtml != null && !this.textHtml.isEmpty();
    }

    public boolean isTextAndHtmlPresent() throws Exception {
        return this.isTextPresent() && this.isTextHtmlPresent();
    }

    public boolean _isEmpty() throws Exception {
        this.load();
        return !(this.textHtml != null && !this.textHtml.isEmpty() || this.text != null && !this.text.isEmpty() || this.getAttachments().getCount() > 0);
    }

    public String getSubject() throws InformException {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public double getDateTime() {
        if (this.dateTimeValue != 0.0) {
            return this.dateTimeValue;
        }
        if (this.dateTime == null) {
            return 0.0;
        }
        this.dateTimeValue = DateTime.fromUnixTime(this.dateTime.getTime());
        return this.dateTimeValue;
    }

    public Boolean getDeleted() {
        return this.isDeleted();
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
        this.dateTimeValue = 0.0;
    }

    public POP3Connection getPop3conn() {
        return this.pop3conn;
    }

    public void setPop3conn(POP3Connection pop3conn) {
        this.pop3conn = pop3conn;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public MailRecipientList getFromAddressList() {
        return this.fromAddressList;
    }

    public void setFromAddressList(Address[] addresses) {
        this.fromAddressList = new MailRecipientList();
        if (addresses != null) {
            for (Address address : addresses) {
                MailRecipient recipient = new MailRecipient(address);
                this.fromAddressList.add(recipient);
            }
        }
    }

    public MailRecipientList getToAddressList() {
        return this.toAddressList;
    }

    public void setToAddressList(Address[] addresses) {
        this.toAddressList = new MailRecipientList();
        if (addresses != null) {
            for (Address address : addresses) {
                MailRecipient recipient = new MailRecipient(address);
                this.toAddressList.add(recipient);
            }
        }
    }

    public MailRecipientList getCcAddressList() {
        return this.ccAddressList;
    }

    public void setCcAddressList(Address[] addresses) {
        this.ccAddressList = new MailRecipientList();
        if (addresses != null) {
            for (Address address : addresses) {
                MailRecipient recipient = new MailRecipient(address);
                this.ccAddressList.add(recipient);
            }
        }
    }

    public MailRecipientList getBccAddressList() {
        return this.bccAddressList;
    }

    public void setBccAddressList(Address[] addresses) {
        this.bccAddressList = new MailRecipientList();
        if (addresses != null) {
            for (Address address : addresses) {
                MailRecipient recipient = new MailRecipient(address);
                this.bccAddressList.add(recipient);
            }
        }
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getCcAddress() {
        return this.ccAddress;
    }

    public void setCcAddress(String ccAddress) {
        this.ccAddress = ccAddress;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void setBccAddress(String bccAddress) {
        this.bccAddress = bccAddress;
    }

    public MailAttachmentsList getAttachments() throws Exception {
        this.load();
        return this.attachments;
    }

    public void setAttachments(MailAttachmentsList attachments) {
        this.attachments = attachments;
    }

    public static void markDelete(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws MessagingException {
        MailMessage self = (MailMessage)thisObj;
        self.setDeleted(true);
    }

    public BinaryObject toBinary() throws Exception {
        if (this.msg == null) {
            throw new InformException("toBinary: MailMessage \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f");
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        this.msg.writeTo(bs);
        byte[] content = bs.toByteArray();
        BinaryObject blob = new BinaryObject(content);
        return blob;
    }

    public BinaryObject toAsmoDoc() throws Throwable {
        if (this.msg == null) {
            throw new InformException("toBinary: MailMessage \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f");
        }
        byte[] content = HTMLParser.getInstance().parse(this.getTextHtml(), this);
        return new BinaryObject(content);
    }

    public void saveToBlob(DatasourceField field) throws Exception {
        if (field == null) {
            throw new InformException("saveToBlob \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043f\u043e\u043b\u0435");
        }
        BinaryObject bin = this.toBinary();
        field.setAsBinary(bin);
    }

    public String getAssignedMessageID() {
        return this.messageId;
    }

    public String getMessageID() throws Exception {
        MimeMessage msg;
        String result;
        if (this.messageId != null) {
            return this.messageId;
        }
        if (this.msg instanceof MimeMessage && (result = (msg = (MimeMessage)this.msg).getMessageID()) != null) {
            return result;
        }
        return "";
    }

    public void setMessageID(String messageId) {
        this.messageId = messageId;
    }

    public final Headers getHeaders() {
        return this.headers;
    }

    public boolean turnInMessage() {
        return this.msg != null;
    }

    public static void dumpPart(Part p, MailMessage msg) throws Exception {
        if (!msg.envelopeDumped && p instanceof Message) {
            MailMessage.dumpEnvelope((Message)p, msg);
        }
        boolean checkAttachment = msg.dumpPartLevel > 0;
        String disp = p.getDisposition();
        if (p.isMimeType("text/plain") && disp == null) {
            msg.setText(p.getContent().toString());
            checkAttachment = false;
        } else if (p.isMimeType("text/html")) {
            msg.setTextHtml(p.getContent().toString());
            checkAttachment = false;
        } else if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            ++msg.dumpPartLevel;
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                MailMessage.dumpPart(mp.getBodyPart(i), msg);
            }
            --msg.dumpPartLevel;
            checkAttachment = false;
        } else if (p.isMimeType("message/rfc822")) {
            ++msg.dumpPartLevel;
            MailMessage.dumpPart((Part)p.getContent(), msg);
            --msg.dumpPartLevel;
        }
        if (checkAttachment && p instanceof MimeBodyPart) {
            boolean existAttachment;
            MimeBodyPart bp = (MimeBodyPart)p;
            boolean bl = existAttachment = disp != null;
            if (!existAttachment) {
                String contentID = bp.getContentID();
                boolean bl2 = existAttachment = !Strings.isVoid(contentID);
            }
            if (existAttachment) {
                MailAttachment at = new MailAttachment();
                at.setContent(bp);
                msg.getAttachments().getAttc().add(at);
            }
        }
    }

    private static String addressListToString(Address[] list) {
        if (list == null || list.length == 0) {
            return "";
        }
        return InternetAddress.toUnicodeString(list);
    }

    public static boolean is7BitEncoding(String input) {
        for (char c : input.toCharArray()) {
            if (c > '\u007f') continue;
            return false;
        }
        return true;
    }

    private static String getSubjectContent(Message message) throws MessagingException, IOException {
        CharSequence[] subjectHeader = message.getHeader("Subject");
        if (subjectHeader == null || subjectHeader.length == 0) {
            return "";
        }
        String subject = subjectHeader[0];
        if (subject != null && subject.equals(MimeUtility.decodeText(subject)) && !MailMessage.is7BitEncoding(subject)) {
            String contentTypeHeader;
            String[] header = message.getHeader("Content-Type");
            String string = contentTypeHeader = header != null ? header[0] : null;
            if (contentTypeHeader == null) {
                byte[] bytes = new byte[subject.length()];
                subject.getBytes(0, subject.length(), bytes, 0);
                String encoding = MailMessage.getCharset(subject);
                if (encoding != null) {
                    return new String(bytes, Charset.forName(encoding));
                }
                return message.getSubject();
            }
            ContentType type = new ContentType(contentTypeHeader);
            String charsetValue = type.getParameter("charset");
            if (charsetValue == null || !Charset.isSupported(charsetValue)) {
                return message.getSubject();
            }
            String joinSubject = String.join((CharSequence)" ", subjectHeader).trim();
            byte[] bytes = new byte[joinSubject.length()];
            joinSubject.getBytes(0, joinSubject.length(), bytes, 0);
            return new String(bytes, Charset.forName(charsetValue));
        }
        return message.getSubject();
    }

    public static String getCharset(String value) {
        byte[] bytes = new byte[value.length()];
        value.getBytes(0, value.length(), bytes, 0);
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(bytes, 0, bytes.length);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        detector.reset();
        return encoding;
    }

    public static void dumpEnvelope(Message m, MailMessage msg) throws Exception {
        msg.setFromAddress(MailMessage.addressListToString(m.getFrom()));
        msg.setToAddress(MailMessage.addressListToString(m.getAllRecipients()));
        msg.setSubject(MailMessage.getSubjectContent(m));
        msg.setDateTime(m.getSentDate());
        msg.setNumber(m.getMessageNumber());
        msg.setFromAddressList(m.getFrom());
        msg.setToAddressList(m.getRecipients(Message.RecipientType.TO));
        msg.setCcAddressList(m.getRecipients(Message.RecipientType.CC));
        msg.setBccAddressList(m.getRecipients(Message.RecipientType.BCC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getImageContentById(String cid) throws Throwable {
        byte[] result = null;
        MailAttachmentsList maList = this.getAttachments();
        for (int i = 0; i < maList.getCount(); ++i) {
            MailAttachment ma = maList.getAttc().get(i);
            if (ma == null) continue;
            String maCid = ma.getContentID();
            if (maCid.startsWith("<")) {
                maCid = maCid.substring(1);
            }
            if (maCid.endsWith(">")) {
                maCid = maCid.substring(0, maCid.length() - 1);
            }
            if (maCid.compareTo(cid) != 0) continue;
            MimeBodyPart part = ma.getContent();
            if (part == null) break;
            byte[] buf = new byte[1024];
            InputStream is = part.getInputStream();
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            try {
                int n;
                while ((n = is.read(buf, 0, 1024)) > -1) {
                    fos.write(buf, 0, n);
                }
                break;
            }
            finally {
                result = fos.toByteArray();
                fos.close();
            }
        }
        return result;
    }

    static class Headers
    extends ScriptableObject {
        Headers() {
        }

        @Override
        public String getClassName() {
            return "Headers";
        }
    }
}

