/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.ObjectSizer;
import inform.adt.TimeInfo;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Constants;
import inform.agent.scripts.CursorParents;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.ParametersDatasource;
import inform.agent.scripts.ScriptableValue;
import inform.agent.scripts.Task;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.util.Binding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.jetty.util.ajax.JSON;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

@ObjectSizer.HintSharedProperties(value={"parentScopeObject"})
public class Parameter
extends ScriptableObject
implements ScriptableValue,
DatasetField,
IntegerHash.Entry {
    static final int HEADER_LENGTH = 8;
    private static final String[] availJSFunctionsNames = new String[]{"toString", "clear", "valueByIndex", "addValue", "addMultiple", "setIgnore", "loadFromStream", "loadFromFile", "saveToFile", "contains", "clearBinding", "assign"};
    private static final String[] availJSPropertiesNames = new String[]{"value", "asArray", "asBinary", "blobSize", "asDate", "asDateValue", "asString", "asNumber", "asBoolean", "isIgnored", "bindIndex"};
    private DataType dataType;
    private int id;
    private String name;
    private String caption;
    private Object value;
    private boolean isIgnored;
    private int formatId;
    private boolean isNotNull;
    private boolean isOneValue;
    private boolean returnValue;
    private boolean isHidden;
    private int fieldAssoc;
    private int selectedField;
    private int datasourceBinding;
    private int fieldBinding;
    private int paramBinding;
    private QueryNode bindedToQueryNode;
    private boolean modified = false;
    private boolean add_multiple = false;
    private int bindIndex = -1;
    double refTableId = 0.0;
    private DirectoryField directoryField = null;
    int parameterIndex = -1;
    boolean binded;
    int souCtrlID;
    IntegerSet metadataFilter;
    private boolean withNull;
    private boolean withNullActual;
    boolean withDateTimeInterval = false;
    int missingConstantId = 0;

    protected Parameter(int id, int dataTypeId, int bindIndex) {
        this.id = id;
        this.dataType = DataType.getDataTypeById(dataTypeId);
        this.bindIndex = bindIndex;
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, Parameter.class, 0);
        }
        this.defineProperty("id", this.getClass(), 1);
        this.defineProperty("name", this.getClass(), 1);
        this.defineProperty("caption", this.getClass(), 1);
        this.defineProperty("isNull", this.getClass(), 1);
        this.defineProperty("valueCount", this.getClass(), 1);
        Parameter.putConstProperty(this, "dataType", dataTypeId);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    public Object getSingleValue() {
        Object v = this.getRawValue();
        Object r = v instanceof Object[] ? ((Object[])v)[0] : v;
        return r;
    }

    public Object getRawValueByIndex(int idx) {
        Object v = this.getRawValue();
        Object r = v instanceof Object[] ? (idx < ((Object[])v).length ? ((Object[])v)[idx] : ((Object[])v)[0]) : v;
        return r;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Object getAvailableValue() throws Exception {
        if (this.isIgnored) {
            return null;
        }
        return this.getSingleValue();
    }

    public boolean notNull() {
        return this.isNotNull;
    }

    void setIsNotNull(boolean isNotNull) {
        this.isNotNull = isNotNull;
    }

    public int getDatasourceBinding() {
        return this.datasourceBinding;
    }

    public void setDatasourceBinding(int datasourceBinding) {
        this.datasourceBinding = datasourceBinding;
        this.missingConstantId = 0;
    }

    public int getFieldBinding() {
        return this.fieldBinding;
    }

    public void setFieldBinding(int fieldBinding) {
        this.fieldBinding = fieldBinding;
        this.missingConstantId = 0;
    }

    public QueryNode getBindedToQueryNode() {
        return this.bindedToQueryNode;
    }

    public void setBindedToQueryNode(QueryNode bindedToQueryNode) {
        this.bindedToQueryNode = bindedToQueryNode;
    }

    public boolean hidden() {
        return this.isHidden;
    }

    public void hidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public int selectedField() {
        return this.selectedField;
    }

    void selectedField(int field) {
        this.selectedField = field;
    }

    public int fieldAssoc() {
        return this.fieldAssoc;
    }

    void fieldAssoc(int field) {
        this.fieldAssoc = field;
    }

    public double refTableId() {
        return this.refTableId;
    }

    public boolean oneValue() {
        return this.isOneValue;
    }

    void setIsOneValue(boolean isOneValue) {
        this.isOneValue = isOneValue;
    }

    @Override
    public Object getRawValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof ScriptableValue) {
            return ((ScriptableValue)this.value).getRawValue();
        }
        return this.value;
    }

    public void setRawValue(Object newValue) {
        this.value = newValue;
        this.isIgnored = false;
        this.missingConstantId = 0;
        this.paramBinding = 0;
        this.modified = true;
    }

    @Override
    public Object getValue() {
        if (this.isIgnored || this.getIsNull()) {
            return null;
        }
        Object value = this.getSingleValue();
        if (value instanceof DateTimeInterval) {
            return ((DateTimeInterval)value).getStartDate();
        }
        return value;
    }

    public void setValue(Object v) throws InformException {
        if (v == null) {
            this.setRawValue(null);
        } else {
            this.setRawValue(ValueCaster.getCastedValue(this.dataType, v));
        }
    }

    public static Object assign(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException, Exception {
        Parameter self = (Parameter)thisObj;
        self.paramBinding = 0;
        if (args.length == 0) {
            return null;
        }
        if (args.length > 1) {
            self.clear();
            self.add_multiple = true;
            for (int i = 0; i < args.length; ++i) {
                self.internalAddValue(args[i]);
            }
        } else if (args[0] instanceof Parameter) {
            self.assignParameter((Parameter)args[0]);
        } else if (args[0] instanceof DatasourceField) {
            self.setValue(((DatasourceField)args[0]).getAvailableValue());
        } else {
            self.setValue(args[0]);
        }
        self.modified = true;
        return null;
    }

    public void assignParameter(Parameter p) throws InformException {
        this.add_multiple = false;
        this.paramBinding = 0;
        if (p.isIgnored) {
            this.value = null;
            this.setIsIgnored(true);
        } else {
            if (p.getValueCount() <= 1) {
                this.setValue(p.getValue());
            } else {
                this.add_multiple = true;
                if (p.getDataType() == this.getDataType()) {
                    this.setRawValue(p.value);
                } else {
                    this.setIsIgnored(false);
                    Object[] array = new Object[p.getValueCount()];
                    for (int i = 0; i < p.getValueCount(); ++i) {
                        array[i] = ValueCaster.getCastedValue(this.dataType, p.valueByIndex(i));
                    }
                    this.setRawValue(array);
                }
            }
            this.setIsIgnored(false);
        }
        this.modified = true;
    }

    void setInitValue(Object initValue) {
        this.value = initValue;
    }

    void setInitConstant(int constantId, Constant constant) {
        if (constant == null) {
            this.missingConstantId = constantId;
        } else {
            this.setInitValue(constant);
        }
    }

    void setInitConstant(int constantId, Constants constants) {
        this.setInitConstant(constantId, constants != null ? constants.get(constantId) : null);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    void setName(String newName) {
        this.name = newName;
    }

    public String getCaption() {
        return this.caption;
    }

    void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    public boolean getIsIgnored() {
        if (this.isIgnored) {
            return true;
        }
        if (this.value != null && this.value instanceof ScriptableValue) {
            return ((ScriptableValue)this.value).getIsIgnored();
        }
        return this.isIgnored;
    }

    public void setIsIgnored(boolean isIgnored) {
        this.add_multiple = false;
        if (this.isIgnored != isIgnored) {
            this.modified = true;
        }
        this.isIgnored = isIgnored;
        this.missingConstantId = 0;
        if (isIgnored) {
            this.value = null;
        }
    }

    public boolean returnValue() {
        return this.returnValue;
    }

    void setReturnValue(boolean returnValue) {
        this.returnValue = returnValue;
    }

    public int getFormatId() {
        return this.formatId;
    }

    void setFormatId(int formatId) {
        this.formatId = formatId;
    }

    public Scriptable getAsDate() throws InformException {
        Date d = ValueCaster.toDate(this.getSingleValue());
        Context cx = Context.getCurrentContext();
        Object[] ctorArgs = new Object[]{d.getTime()};
        return cx.newObject(this, "Date", ctorArgs);
    }

    public void setAsDate(Scriptable value) throws InformException {
        Date d = (Date)Context.jsToJava(value, Date.class);
        this.setRawValue(ValueCaster.getCastedValue(this.dataType, d));
    }

    public double getAsDateValue() throws InformException {
        return ValueCaster.toNumber(this.getSingleValue()).doubleValue();
    }

    public double getAsDateValueByIndex(int idx) throws InformException {
        return ValueCaster.toNumber(this.getRawValueByIndex(idx)).doubleValue();
    }

    public void setAsDateValue(double value) throws InformException {
        this.setRawValue(ValueCaster.getCastedValue(this.dataType, value));
    }

    @Override
    public String getAsString() throws InformException {
        return ValueCaster.toString(this.getSingleValue());
    }

    public String getAsStringByIndex(int idx) throws InformException {
        return ValueCaster.toString(this.getRawValueByIndex(idx));
    }

    public void setAsString(String value) throws InformException {
        this.setRawValue(ValueCaster.getCastedValue(this.dataType, value));
    }

    @Override
    public double getAsNumber() throws InformException {
        return ValueCaster.toNumber(this.getSingleValue()).doubleValue();
    }

    public double getAsNumberByIndex(int idx) throws InformException {
        return ValueCaster.toNumber(this.getRawValueByIndex(idx)).doubleValue();
    }

    public int getAsIntNumberByIndex(int idx) throws InformException {
        return ValueCaster.toNumber(this.getSingleValue()).intValue();
    }

    public void setAsNumber(Double value) throws InformException {
        this.setRawValue(ValueCaster.getCastedValue(this.dataType, value));
    }

    public boolean getAsBoolean() throws InformException {
        return ValueCaster.toBoolean(this.getSingleValue());
    }

    public boolean getAsBooleanByIndex(int idx) throws InformException {
        return ValueCaster.toBoolean(this.getRawValueByIndex(idx));
    }

    public void setAsBoolean(boolean value) throws InformException {
        this.setRawValue(ValueCaster.getCastedValue(this.dataType, value));
    }

    public Object getAsArray() throws InformException {
        Object v = this.value instanceof Constant ? ((Constant)this.value).getRawValue() : this.value;
        return Context.javaToJS(v, this);
    }

    public Object jsVal(Scriptable scope) {
        Object v = this.value instanceof Constant ? ((Constant)this.value).getRawValue() : this.value;
        return Context.javaToJS(v, scope);
    }

    public void setAsArray(Scriptable value) throws InformException {
        this.setRawValue(Context.jsToJava(value, Object[].class));
    }

    @Override
    public BinaryObject getAsBinary() throws InformException {
        if (this.dataType != DataType.BLOB) {
            throw new InformException(String.format("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0443 asBinary \u0443 \u043d\u0435-BLOB \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 %s", this.name));
        }
        Object value = this.getSingleValue();
        if (value != null && !(value instanceof byte[])) {
            throw new InformException(String.format("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044e %s \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 %s \u043a\u0430\u043a \u043a \u0431\u043b\u043e\u0431\u0443", value.getClass().getCanonicalName(), this.name));
        }
        return new BinaryObject((byte[])value);
    }

    public byte[] getBinaryBlob() throws InformException {
        if (this.dataType != DataType.BLOB) {
            throw new InformException(String.format("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0443 asBinary \u0443 \u043d\u0435-BLOB \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 %s", this.name));
        }
        Object value = this.getSingleValue();
        if (value != null && !(value instanceof byte[])) {
            throw new InformException(String.format("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044e %s \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 %s \u043a\u0430\u043a \u043a \u0431\u043b\u043e\u0431\u0443", value.getClass().getCanonicalName(), this.name));
        }
        return (byte[])value;
    }

    public void setAsBinary(Object value) throws InformException {
        if (this.dataType != DataType.BLOB) {
            throw new InformException(String.format("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0443 asBinary \u0443 \u043d\u0435-BLOB \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 %s", this.name));
        }
        this.setRawValue(((BinaryObject)Context.jsToJava(value, BinaryObject.class)).toByteArray());
    }

    public int getBlobLength() {
        if (this.dataType != DataType.BLOB) {
            return 0;
        }
        Object value = this.getSingleValue();
        if (value == null) {
            return 0;
        }
        if (!(value instanceof byte[])) {
            return 0;
        }
        return ((byte[])value).length;
    }

    @Override
    public boolean getIsNull() {
        return this.getRawValue() == null;
    }

    public void clear() {
        this.add_multiple = false;
        if (this.value != null) {
            this.modified = true;
        }
        this.value = null;
        this.setIsIgnored(false);
    }

    public int getValueCount() {
        if (this.getIsIgnored()) {
            return 0;
        }
        Object rawValue = this.getRawValue();
        if (!(rawValue instanceof Object[])) {
            return 1;
        }
        return Array.getLength(rawValue);
    }

    private boolean compareValue(Object v, Object value) {
        try {
            if (v == null) {
                return value == null;
            }
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean v1 = ValueCaster.toBoolean(v);
                    boolean v2 = ValueCaster.toBoolean(value);
                    return v1 == v2;
                }
                case DATE_TIME: 
                case DIRECTORY: 
                case FLOAT: 
                case INTEGER: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    double v1 = ValueCaster.toNumber(v).doubleValue();
                    double v2 = ValueCaster.toNumber(value).doubleValue();
                    return v1 == v2;
                }
                case BIG_NUMBER: 
                case UNICODE: 
                case STRING: {
                    String v1 = ValueCaster.toString(v);
                    String v2 = ValueCaster.toString(value);
                    return v1.equals(v2);
                }
            }
            return false;
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            return false;
        }
    }

    public boolean contains(Object value) {
        if (this.isIgnored) {
            return false;
        }
        if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                if (!this.contains(v)) continue;
                return true;
            }
            return false;
        }
        if (this.value instanceof Object[]) {
            for (Object v : (Object[])this.value) {
                if (!this.compareValue(v, value)) continue;
                return true;
            }
            return false;
        }
        return this.compareValue(this.value, value);
    }

    public Object valueByIndex(int index) throws InformException {
        if (this.value == null && index == 0) {
            return null;
        }
        if (!(this.value instanceof Object[]) && index > 0) {
            throw new IndexOutOfBoundsException();
        }
        Object v = null;
        v = !(this.value instanceof Object[]) && index == 0 ? this.getSingleValue() : ((Object[])this.value)[index];
        if (v == null) {
            return null;
        }
        switch (this.dataType) {
            case BLOB: {
                return v;
            }
            case BOOLEAN: {
                return ValueCaster.toBoolean(v);
            }
            case DATE_TIME: {
                return ValueCaster.toDate(v);
            }
            case DIRECTORY: 
            case FLOAT: 
            case INTEGER: 
            case METATREE_NODE: 
            case PRIMARY_KEY: 
            case INTERVAL: {
                return ValueCaster.toNumber(v);
            }
            case BIG_NUMBER: 
            case UNICODE: 
            case STRING: {
                return ValueCaster.toString(v);
            }
        }
        return Undefined.instance;
    }

    public void internalAddValue(Object value) throws InformException {
        Object[] array;
        if (!this.add_multiple) {
            if (value == null) {
                this.clear();
            } else {
                this.setValue(value);
            }
            this.add_multiple = true;
            return;
        }
        boolean isO = this.value instanceof Object[] && !this.isIgnored;
        boolean isN = value instanceof Object[];
        if (!isO && !isN) {
            value = ValueCaster.getCastedValue(this.dataType, value);
            array = this.isIgnored ? new Object[]{value} : new Object[]{this.value, value};
        } else if (!isO && isN) {
            if (this.isIgnored) {
                array = new Object[((Object[])value).length];
                for (int i = 0; i < ((Object[])value).length; ++i) {
                    Object v = ((Object[])value)[i];
                    array[i] = v == null ? null : ValueCaster.getCastedValue(this.dataType, v);
                }
            } else {
                array = new Object[((Object[])value).length + 1];
                array[0] = this.value;
                for (int i = 0; i < ((Object[])value).length; ++i) {
                    Object v = ((Object[])value)[i];
                    array[i + 1] = v == null ? null : ValueCaster.getCastedValue(this.dataType, v);
                }
            }
        } else if (isO && !isN) {
            array = new Object[((Object[])this.value).length + 1];
            for (int i = 0; i < ((Object[])this.value).length; ++i) {
                array[i] = ((Object[])this.value)[i];
            }
            array[array.length - 1] = ValueCaster.getCastedValue(this.dataType, value);
        } else {
            array = new Object[((Object[])value).length + ((Object[])this.value).length];
            for (int i = 0; i < ((Object[])this.value).length; ++i) {
                array[i] = ((Object[])this.value)[i];
            }
            for (int j = 0; j < ((Object[])value).length; ++j) {
                array[i + j] = ValueCaster.getCastedValue(this.dataType, ((Object[])value)[j]);
            }
        }
        this.isIgnored = false;
        this.missingConstantId = 0;
        this.value = array;
        this.modified = true;
    }

    public static Object addMultiple(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        Parameter self = (Parameter)thisObj;
        self.add_multiple = true;
        self.internalAddValue(args);
        return null;
    }

    public static Object addValue(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        Parameter self = (Parameter)thisObj;
        for (Object a : args) {
            self.internalAddValue(a);
        }
        return null;
    }

    public void setIgnore() {
        this.setIsIgnored(true);
    }

    public int getParamBinding() {
        return this.paramBinding;
    }

    public void setParamBinding(int paramId) {
        this.withDateTimeInterval = false;
        this.paramBinding = paramId;
        this.missingConstantId = 0;
    }

    public void applyParamBinding(Parameter binding) {
        this.dataType = binding.dataType;
        this.value = binding.value;
        this.withNull = binding.withNull;
        this.withNullActual = binding.withNullActual;
        this.withDateTimeInterval = binding.withDateTimeInterval;
        this.isIgnored = binding.isIgnored;
        this.missingConstantId = 0;
        this.formatId = binding.formatId;
        this.modified = true;
        this.bindedToQueryNode = binding.bindedToQueryNode;
        this.datasourceBinding = binding.datasourceBinding;
        this.fieldBinding = binding.fieldBinding;
        this.paramBinding = 0;
    }

    public void updateBindingType(DataType type) {
        if (this.dataType == null) {
            this.dataType = type;
        } else if (this.dataType == DataType.FLOAT && type == DataType.INTEGER) {
            this.dataType = type;
        }
    }

    public void applyDatasourceBindings(Task task, CursorParents parents) throws Exception {
        if (this.value != null && this.value instanceof Binding) {
            ((Binding)this.value).apply(task, parents);
        }
    }

    public Object getInternalValue() {
        return this.value;
    }

    private void checkBlobType(String prop) throws InformException {
        if (this.dataType != DataType.BLOB) {
            throw new InformException(String.format("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a %s \u0443 \u043d\u0435-BLOB \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 %s", prop, this.name));
        }
    }

    public void loadFromStream(Object arg) throws InformException, IOException {
        int bytesRead;
        this.checkBlobType("loadFromStream");
        InputStream in = (InputStream)Context.jsToJava(arg, InputStream.class);
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream sucker = new ByteArrayOutputStream();
        do {
            if ((bytesRead = in.read(buffer)) <= -1) continue;
            sucker.write(buffer, 0, bytesRead);
        } while (bytesRead > -1);
        this.setRawValue(sucker.toByteArray());
    }

    public void loadFromFile(String pathname) throws IOException, InformException {
        this.checkBlobType("loadFromFile");
        BinaryObject value = new BinaryObject();
        value.loadFromFile(pathname);
        this.setRawValue(value.toByteArray());
    }

    public void saveToFile(String pathname) throws IOException, InformException, SQLException {
        this.checkBlobType("saveToFile");
        this.getAsBinary().saveToFile(pathname);
    }

    public long getBlobSize() throws InformException {
        this.checkBlobType("blobSize");
        Object value = this.getSingleValue();
        if (value == null || !(value instanceof byte[])) {
            return 0L;
        }
        return ((byte[])value).length;
    }

    public void clearModified() {
        this.modified = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean binded() {
        return this.binded;
    }

    @Override
    public String getClassName() {
        return "Parameter";
    }

    public String toString() {
        return "Parameter " + this.getName();
    }

    public int getBindIndex() {
        return this.bindIndex;
    }

    public void setBindIndex(int bindIndex) {
        this.bindIndex = bindIndex;
    }

    public void clearBinding() {
        this.bindIndex = -1;
    }

    private Object cast(Object v) throws ParseException, InformException {
        if (v != null && this.dataType == DataType.DATE_TIME) {
            return v instanceof Number ? v : ValueCaster.getCastedValue(this.dataType, DateTime.fromString(v.toString()));
        }
        return ValueCaster.getCastedValue(this.dataType, v);
    }

    public void setAsmoWebValue(String v) throws InformException, ParseException {
        if ("#".equals(v) || "{}".equals(v)) {
            this.setIgnore();
            return;
        }
        Object[] o = JSON.parse((String)v);
        if ("".equals(o)) {
            o = null;
        }
        if (o != null && o.getClass().isArray()) {
            Object[] oo = o;
            for (int i = 0; i < oo.length; ++i) {
                oo[i] = this.cast(oo[i]);
            }
            o = oo;
        } else {
            o = this.cast(o);
        }
        this.setRawValue(o);
    }

    public void setWebValue(String v) throws InformException, ParseException {
        this.setRawValue(this.cast(v));
    }

    public DatasetField findFieldPath(Task task, ParametersDatasource datasource, int[] path) throws InformException {
        if (path == null || path.length == 0) {
            return null;
        }
        if (path.length == 1) {
            return this;
        }
        switch (this.dataType) {
            case DIRECTORY: 
            case PRIMARY_KEY: {
                int fieldId;
                if (this.directoryField == null) {
                    if (this.refTableId == 0.0) {
                        return null;
                    }
                    TableDescriptor tableDescriptor = TableDescriptor.getIfExists(this.refTableId);
                    if (tableDescriptor == null) {
                        return null;
                    }
                    FieldDescriptor fieldDescriptor = new FieldDescriptor(this.id, this.parameterIndex, this.name, this.caption, this.refTableId);
                    this.directoryField = new DirectoryField(datasource.ssContext, fieldDescriptor, task, datasource);
                }
                DatasourceField field = this.directoryField;
                for (int i = 1; i < path.length && field != null; field = field.getDirectoryField(fieldId), ++i) {
                    fieldId = path[i];
                    if (field instanceof DirectoryField) continue;
                    field = null;
                    break;
                }
                return field;
            }
        }
        return null;
    }

    @Override
    public int key() {
        return this.id;
    }

    public int souCtrlID() {
        return this.souCtrlID;
    }

    public int[] metadataFilter() {
        return this.metadataFilter == null ? new int[]{} : this.metadataFilter.toArray();
    }

    public boolean isWithNull() {
        return this.withNull;
    }

    public boolean isWithDateTimeInterval() {
        return this.withDateTimeInterval;
    }

    public void compactNulls() {
        if (this.withNullActual) {
            return;
        }
        this.withNullActual = true;
        this.withNull = false;
        int count = this.getValueCount();
        if (count <= 1 || this.getDatasourceBinding() != 0 || this.getFieldBinding() != 0) {
            return;
        }
        Object rawValue = this.getRawValue();
        if (rawValue instanceof Object[]) {
            Object[] values;
            for (Object v : values = (Object[])rawValue) {
                if (v != null) continue;
                this.withNull = true;
                break;
            }
            if (this.withNull) {
                Object[] newValues = new Object[values.length];
                int newCount = 0;
                for (Object v : values) {
                    if (v == null) continue;
                    newValues[newCount++] = v;
                }
                if (newCount == 0) {
                    this.value = null;
                    this.withNull = false;
                } else {
                    this.value = Arrays.copyOf(newValues, newCount);
                }
            }
        }
    }

    public static DateTimeInterval wrapUpValue(int formatId, Object value) {
        TimeInfo p1 = new TimeInfo();
        DateTime.toTimeInfo(ValueCaster.toDouble(value), p1);
        int d2 = p1.day;
        int m2 = p1.month;
        int y2 = p1.year;
        int ms2 = 0;
        switch (formatId) {
            case 401: 
            case 412: 
            case 451: {
                d2 = p1.day;
                m2 = p1.month;
                y2 = p1.year;
                ms2 = 86400000;
                break;
            }
            case 402: 
            case 452: {
                p1.day = 1;
                d2 = DateTime.daysInMonth(m2, y2);
                break;
            }
            case 403: {
                p1.day = 1;
                d2 = 1;
                p1.month = 1;
                d2 = 31;
                m2 = 12;
                break;
            }
            case 411: {
                p1.day = 1;
                if (p1.month < 4) {
                    p1.month = 1;
                    m2 = 3;
                    d2 = DateTime.daysInMonth(m2, y2);
                    break;
                }
                if (p1.month < 7) {
                    p1.month = 4;
                    m2 = 6;
                    d2 = DateTime.daysInMonth(m2, y2);
                    break;
                }
                if (p1.month < 10) {
                    p1.month = 7;
                    m2 = 9;
                    d2 = DateTime.daysInMonth(m2, y2);
                    break;
                }
                p1.month = 10;
                m2 = 12;
                d2 = DateTime.daysInMonth(m2, y2);
            }
        }
        DateTimeInterval dti = new DateTimeInterval();
        dti.setStartDate(DateTime.createDateTime(p1.year, p1.month, p1.day, 0, 0, 0, 0));
        dti.setEndDate(DateTime.createDateTime(y2, m2, d2, 0, 0, 0, ms2));
        return dti;
    }

    public void makeWrapUp() {
        if (this.withDateTimeInterval) {
            return;
        }
        if (this.dataType != DataType.DATE_TIME) {
            return;
        }
        if (this.isIgnored) {
            return;
        }
        if (this.paramBinding != 0) {
            return;
        }
        if (this.datasourceBinding != 0) {
            return;
        }
        Object rawValue = this.getRawValue();
        if (rawValue == null) {
            return;
        }
        if (rawValue instanceof DateTimeInterval) {
            this.withDateTimeInterval = true;
            return;
        }
        switch (this.formatId) {
            case 401: 
            case 402: 
            case 403: 
            case 411: 
            case 412: 
            case 451: 
            case 452: {
                break;
            }
            default: {
                return;
            }
        }
        if (rawValue instanceof Object[]) {
            Object[] values = (Object[])rawValue;
            for (int i = 0; i < values.length; ++i) {
                Object v = values[i];
                if (v == null) continue;
                this.withDateTimeInterval = true;
                if (v instanceof DateTimeInterval) {
                    return;
                }
                values[i] = Parameter.wrapUpValue(this.formatId, v);
            }
        } else {
            this.withDateTimeInterval = true;
            this.value = Parameter.wrapUpValue(this.formatId, rawValue);
        }
    }

    public void unwrap() {
        this.withDateTimeInterval = false;
        Object rawValue = this.getRawValue();
        if (rawValue == null) {
            return;
        }
        if (rawValue instanceof Object[]) {
            Object[] values = (Object[])rawValue;
            for (int i = 0; i < values.length; ++i) {
                Object v = values[i];
                if (v == null || !(v instanceof DateTimeInterval)) continue;
                values[i] = ((DateTimeInterval)v).getStartDate();
            }
        } else if (rawValue instanceof DateTimeInterval) {
            this.value = ((DateTimeInterval)rawValue).getStartDate();
        }
    }
}

