/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.ParmetersRow;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.scripts.ActualPoint;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.Task;
import inform.agent.scripts.format.FormatManager;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ServerSideTableStorer
extends ServerSideExecutable {
    private final BasicNode node;
    private final TableRecord record;
    private Scriptable topLevelScope;
    private String onAppend;
    private String onChange;
    private String onDelete;
    private TableDescriptor tableDescriptor;
    private boolean virtualTable;

    public ServerSideTableStorer(SSContext parentConext, BasicNode node, ServerSideHost ssHost, AbstractConnectionManager dbManager) throws IOException, TaggedReaderException, InformException {
        super(parentConext, 7, node.getId(), ssHost, dbManager, null);
        if (this.ssContext != null) {
            this.ssContext.nodeId = this.nodeID;
            this.ssContext.script = "table";
        }
        this.node = node;
        this.load();
        this.record = new TableRecord(this.ssContext, this.tableDescriptor, this);
        ServerSideTableStorer.putConstProperty(this, "table", this.record);
    }

    public TableDescriptor tableDescriptor() {
        return this.tableDescriptor;
    }

    public boolean virtualTable() {
        return this.virtualTable;
    }

    public void applyAppend(double rid, byte[] modifiedFields) throws IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.callInContext(this.onAppend, "onAppend", rid, modifiedFields, null);
    }

    public void applyChange(double rid, byte[] modifiedFields, byte[] originalFields) throws IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.callInContext(this.onChange, "onChange", rid, modifiedFields, originalFields);
    }

    public void applyDelete(double rid, byte[] originalFields) throws IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.callInContext(this.onDelete, "onDelete", rid, null, originalFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callInContext(String on, String eventName, double rid, byte[] modifiedFields, byte[] originalFields) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (Strings.isVoid(on)) {
            if (!this.tableDescriptor.isOperableTable()) {
                throw new InformException("\u041d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 " + eventName);
            }
            return;
        }
        this.record.reloadFields(rid, modifiedFields, originalFields);
        Context cx = Core.asmoJsContextFactory.enterContext();
        cx.setLanguageVersion(200);
        try {
            if (this.topLevelScope == null) {
                this.topLevelScope = ScriptableRequest.createTopLevelScope(cx, this, this.getHost(), this.getDBManager());
                this.setParentScope(this.topLevelScope);
                this.executeScript(cx);
            }
            ScriptableObject.callMethod(cx, this, on, new Object[0]);
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public String getClassName() {
        return "ServerSideTable";
    }

    @Override
    protected void loadTag(int tag, TaggedReader reader) throws IOException, InformException {
        switch (tag) {
            case 6: {
                reader.skip();
                double tableId = reader.getDouble(151);
                this.tableDescriptor = TableDescriptor.get(tableId);
                this.virtualTable = this.tableDescriptor.getKind() == TableDescriptor.Kind.VIRTUAL;
                break;
            }
            case 9: {
                this.onAppend = reader.getAnsi();
                break;
            }
            case 10: {
                this.onChange = reader.getAnsi();
                break;
            }
            case 11: {
                this.onDelete = reader.getAnsi();
            }
        }
    }

    private static class TableRecord
    extends SmartScriptableObject {
        static final Method GET_OLDVALUE;
        final TableDescriptor table;
        final TimeZoneHost timeZoneHost;
        final ParametersList curr;
        final ParametersList orig;
        final Row crow;

        TableRecord(SSContext ssContext, TableDescriptor table, Task task) {
            this.table = table;
            this.timeZoneHost = task.getHost();
            this.curr = new ParametersList();
            this.orig = new ParametersList();
            this.crow = new Row(this.curr, task);
            for (FieldDescriptor fd : table.getFields()) {
                this.orig.createParameterByField(fd);
                this.curr.createParameterByField(fd);
                if (Strings.isVoid(fd.getIdent())) continue;
                DatasourceField field = DatasourceField.createInstance(ssContext, this, fd, task, this.crow);
                TableRecord.putConstProperty(this, fd.getIdent(), field);
                field.defineProperty("oldvalue", this, GET_OLDVALUE, null, 5);
            }
            this.defineProperty("recordID", this.getClass(), 5);
        }

        Object getOldValue(Scriptable obj) {
            DatasourceField f = (DatasourceField)obj;
            Parameter p = this.orig.get(f.desc.getId());
            return p == null ? null : p.getValue();
        }

        void reloadFields(double rid, byte[] modified, byte[] original) throws IOException {
            this.crow.setId(rid);
            for (Parameter p : this.orig.values()) {
                p.setRawValue(null);
            }
            this.reloadFields(this.orig, original);
            for (Parameter p : this.curr.values()) {
                p.setRawValue(null);
            }
            this.reloadFields(this.curr, original);
            for (Parameter p : this.curr.values()) {
                p.clearModified();
            }
            this.reloadFields(this.curr, modified);
        }

        void reloadFields(ParametersList plist, byte[] fvalues) throws IOException {
            if (fvalues == null) {
                return;
            }
            Parameter p = null;
            TaggedReader reader = new TaggedReader(fvalues);
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 4: {
                        int fid = reader.getInt();
                        p = plist.get(fid);
                        break;
                    }
                    case 10: {
                        p.setRawValue(null);
                        break;
                    }
                    case 11: {
                        p.setAsNumber(Double.valueOf(reader.getInt()));
                        break;
                    }
                    case 12: {
                        p.setAsNumber(reader.getDouble());
                        break;
                    }
                    case 14: {
                        p.setAsDateValue(FormatManager.toServerTime(reader.getDouble(), p.getFormatId(), this.timeZoneHost));
                        break;
                    }
                    case 34: {
                        byte b = reader.getByte();
                        p.setAsBoolean(b != 0);
                        break;
                    }
                    case 13: {
                        p.setAsString(reader.getString());
                        break;
                    }
                    case 24: {
                        p.setAsString(reader.getUnicode());
                    }
                }
            }
        }

        public double getRecordID() {
            return this.crow.getId();
        }

        static {
            try {
                GET_OLDVALUE = TableRecord.class.getDeclaredMethod("getOldValue", Scriptable.class);
            }
            catch (NoSuchMethodException e) {
                throw InformException.wrap(e);
            }
        }

        static class Row
        extends ParmetersRow
        implements RowsetAccessor {
            final Task task;

            Row(ParametersList plist, Task task) {
                super(plist);
                this.task = task;
            }

            void setId(double rid) {
                this.id = rid;
            }

            @Override
            public Row getCurrentRow() {
                return this;
            }

            @Override
            public boolean isCurrentRowAvailable() {
                return true;
            }

            @Override
            public AbstractConnectionManager getDBManager() {
                return this.task.getDBManager();
            }

            @Override
            public ServerSideHost getHost() {
                return this.task.getHost();
            }

            @Override
            public boolean internStrings() {
                return false;
            }

            @Override
            public ActualPoint getPeriodicBind() {
                return null;
            }

            @Override
            public void notifySortingFieldModified(Object field) {
            }

            @Override
            public TableDescriptor getTableDescriptor() {
                return null;
            }

            @Override
            public int getNullSortKind() {
                return 0;
            }

            @Override
            public DatasourceField findfieldById(int fieldId) {
                return null;
            }

            @Override
            public void enableFieldValueGenerator(int fieldIndex, boolean value) {
            }
        }
    }
}

