/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.Cache;
import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.RequestStatistics;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DirectoryRowset;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Rowset;
import inform.agent.db.SortDirection;
import inform.agent.db.SortingField;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.utils.DirectoryRowsetCacheKey;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.agent.scripts.Closeables;
import inform.agent.scripts.ComponentList;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Database;
import inform.agent.scripts.ITableDataResult;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerSideTable;
import inform.agent.scripts.Task;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.stat.DirectoryProfile;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ServerTableExecutor
implements ServerSideHost,
ScriptableHost,
ITableDataResult,
Task {
    private final double nodeID;
    private final Task task;
    private final ServerSideHost ssHost;
    private final AbstractConnectionManager dbManager;
    private Scriptable topLevelScope = null;
    private byte[] bindedParametersContent = null;
    private byte[] constantsContent = null;
    private Constants constants = null;
    private ParametersList inputParams = null;
    private Collection<SortInfo> sorting;
    private DoubleHash<Database> databases = null;
    private Cache<DirectoryRowsetCacheKey, DirectoryRowset> directoryRowsetCache = null;
    private AtomicInteger idGenerator = null;
    private Closeables closeables = null;
    protected final SSContext ssContext;
    private final int nullSortKind;

    public ServerTableExecutor(SSContext ssContext, double nodeID, ServerSideHost host, AbstractConnectionManager connectionManager, Task task, int nullSortKind) {
        this.nodeID = nodeID;
        this.task = task;
        this.ssHost = host;
        this.dbManager = connectionManager;
        this.ssContext = ssContext;
        this.nullSortKind = nullSortKind;
    }

    @Override
    public SSContext getRootContext() {
        return this.ssContext;
    }

    public void setBindedParametersContent(byte[] bindedParametersContent) {
        this.bindedParametersContent = bindedParametersContent;
    }

    public void setConstantsContent(byte[] constantsContent) {
        this.constantsContent = constantsContent;
    }

    public void setInputParams(ParametersList inputParams) {
        this.inputParams = inputParams;
    }

    public void setSorting(Collection<SortInfo> sorting) {
        this.sorting = sorting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rowset execute() throws IOException, InformException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Context cx = Core.asmoJsContextFactory.enterContext();
        try {
            Rowset rowset;
            Node nodeInfo = MtdEngine.getValidNode(this.nodeID);
            ServerSideTable node = new ServerSideTable(this.ssContext, this.nullSortKind, this.nodeID, this, this.dbManager, this.task);
            try {
                Collection<SortingField> sortings;
                this.topLevelScope = ScriptableRequest.createTopLevelScope(cx, node, this.ssHost, this.dbManager);
                if (this.constantsContent != null) {
                    node.setConstantsContent(this.constantsContent);
                }
                node.load();
                if (this.bindedParametersContent != null) {
                    node.getParameters().loadParametersValues(node.getConstants(), new TaggedReader(this.bindedParametersContent), this.ssHost);
                }
                if (this.inputParams != null) {
                    ParametersList tableParams = node.getParameters();
                    for (Parameter p : this.inputParams.values()) {
                        Parameter tableParam = tableParams.get(p.getId());
                        if (tableParam == null) continue;
                        tableParam.applyParamBinding(p);
                    }
                }
                if (this.sorting != null && (sortings = ServerTableExecutor.sortingInfoToSortingFields(node.getTable().getTableDescriptor(), this.nullSortKind, this.sorting)) != null) {
                    node.setSorting(sortings);
                }
                node.setParentScope(this.getTopLevelScope());
                this.setConstants(node.getConstants());
                node.executeScript(cx);
                if (node.getOnQueryData() == null || node.getOnQueryData().length() <= 0) {
                    throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u044f onQueryData \u0434\u043b\u044f %s", nodeInfo.toLogString()));
                }
                ScriptableObject.callMethod(node, node.getOnQueryData(), null);
                Rowset rowset2 = node.getResultRowset();
                if (node.isSorting()) {
                    rowset2.sort(node.getSorting());
                }
                rowset = rowset2;
            }
            catch (Throwable throwable) {
                node.close();
                throw throwable;
            }
            node.close();
            return rowset;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public double getUserID() {
        return this.ssHost.getUserID();
    }

    @Override
    public int getTimeZoneOffset() {
        return this.ssHost.getTimeZoneOffset();
    }

    @Override
    public double getEffectiveUserID() {
        return this.ssHost.getEffectiveUserID();
    }

    @Override
    public void idle() {
        this.ssHost.idle();
    }

    @Override
    public long getHostID() {
        return this.ssHost.getHostID();
    }

    @Override
    public boolean isCancelled() {
        return this.ssHost.isCancelled();
    }

    @Override
    public String toLogString() {
        return this.ssHost.toLogString();
    }

    @Override
    public String getCancelReason() {
        if (this.ssHost == null) {
            return null;
        }
        return this.ssHost.getCancelReason();
    }

    @Override
    public void putRequestStateCaption(String caption) throws Exception {
    }

    @Override
    public void putRequestStateText(String msg) throws Exception {
    }

    @Override
    public void putRequestStateResultText(String text) throws Exception {
    }

    @Override
    public void putRequestStateInstruction(String message) throws Exception {
    }

    @Override
    public void putRequestStateProgressMin(int min) throws Exception {
    }

    @Override
    public void putRequestStateProgressMax(int max) throws Exception {
    }

    @Override
    public void putRequestStateProgressPosition(int pos) throws Exception {
    }

    @Override
    public void putRequestStateProgressVisible(boolean isVisible) throws Exception {
    }

    @Override
    public void putRequestStateLog(String msg) throws Exception {
        this.ssHost.putRequestStateLog(msg);
    }

    @Override
    public void putRequestStateEnter() throws Exception {
    }

    @Override
    public void putRequestStateLeave() throws Exception {
    }

    @Override
    public void sendTraceLabel(SSContext context, String text) throws Exception {
        if (this.ssHost != null) {
            this.ssHost.sendTraceLabel(context, text);
        }
    }

    @Override
    public void writeLog(String msg) throws Exception {
        this.ssHost.writeLog(msg);
    }

    @Override
    public void writeLogLine(String msg) throws Exception {
        this.ssHost.writeLogLine(msg);
    }

    @Override
    public Scriptable getTopLevelScope() {
        return this.topLevelScope;
    }

    @Override
    public void setTopLevelScope(Scriptable topLevelScope) {
    }

    @Override
    public boolean isCurrentRowFiltered() throws Exception {
        return true;
    }

    @Override
    public void sendTableData(Rowset rowset, boolean flush, boolean alreadyFiltered) throws IOException, InformException {
    }

    @Override
    public VersionInfo getClientVersion() {
        return this.ssHost.getClientVersion();
    }

    @Override
    public double getNodeID() {
        return this.ssHost.getNodeID();
    }

    @Override
    public double getSessionID() {
        return this.ssHost.getSessionID();
    }

    @Override
    public void sendResult() throws Exception {
    }

    @Override
    public Client client() {
        return this.ssHost.client();
    }

    @Override
    public Security security() {
        return this.ssHost.security();
    }

    @Override
    public void appendToLog(String msg) throws Exception {
    }

    @Override
    public double nodeId() {
        if (this.task != null) {
            return this.task.nodeId();
        }
        return this.nodeID;
    }

    @Override
    public Task parentTask() {
        return this.task;
    }

    @Override
    public ServerSideHost getHost() {
        return this.ssHost;
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        return this.dbManager;
    }

    @Override
    public Database getDatabase(double dbId) {
        Database db;
        if (this.task != null) {
            return this.task.getDatabase(dbId);
        }
        if (this.databases == null) {
            this.databases = new DoubleHash();
        }
        if ((db = this.databases.get(dbId)) == null) {
            db = new Database(this, dbId);
            this.databases.add(db);
        }
        return db;
    }

    @Override
    public ParametersList getParameters() {
        if (this.task != null) {
            return this.task.getParameters();
        }
        return null;
    }

    @Override
    public Constants getConstants() {
        if (this.task != null) {
            return this.task.getConstants();
        }
        return this.constants;
    }

    @Override
    public byte[] getConstantsContent() {
        if (this.task != null) {
            return this.task.getConstantsContent();
        }
        return null;
    }

    @Override
    public DirectoryRowset getDirectoryRowset(DirectoryRowsetCacheKey cacheKey) {
        DirectoryRowset result;
        if (this.task != null) {
            return this.task.getDirectoryRowset(cacheKey);
        }
        if (this.directoryRowsetCache == null) {
            this.directoryRowsetCache = new Cache();
        }
        if ((result = this.directoryRowsetCache.get(cacheKey)) == null) {
            result = new DirectoryRowset(cacheKey);
            this.directoryRowsetCache.put(cacheKey, result);
        }
        return result;
    }

    @Override
    public int generateId() {
        if (this.task != null) {
            return this.task.generateId();
        }
        if (this.idGenerator == null) {
            this.idGenerator = new AtomicInteger();
        }
        return this.idGenerator.incrementAndGet();
    }

    @Override
    public void updateId(int id) {
        int current;
        if (this.task != null) {
            this.task.updateId(id);
        }
        if (this.idGenerator == null) {
            this.idGenerator = new AtomicInteger();
        }
        if ((current = this.idGenerator.get()) < id) {
            this.idGenerator.compareAndSet(current, id);
        }
    }

    @Override
    public void detach(Object o) {
    }

    @Override
    public void registerCloseable(Closeable closeable) {
        if (this.task != null) {
            this.task.registerCloseable(closeable);
        } else {
            if (this.closeables == null) {
                this.closeables = new Closeables();
            }
            this.closeables.register(closeable);
        }
    }

    @Override
    public void detachCloseable(Closeable closeable) {
        if (this.task != null) {
            this.task.detachCloseable(closeable);
        }
        if (this.closeables != null) {
            this.closeables.detach(closeable);
        }
    }

    @Override
    public void setDatasourceProfile() {
    }

    @Override
    public boolean isDatasourceProfile() {
        if (this.task != null) {
            return this.task.isDatasourceProfile();
        }
        return false;
    }

    @Override
    public DatasourceProfile addDatasourceProfile(int uid, double nodeId, double filterId, double moduleId) {
        if (this.task != null) {
            return this.task.addDatasourceProfile(uid, nodeId, filterId, this.nodeId());
        }
        return null;
    }

    @Override
    public DirectoryProfile addDirectory(double nodeId, double moduleId) {
        if (this.task != null) {
            return this.task.addDirectory(nodeId, this.nodeId());
        }
        return null;
    }

    @Override
    public String getProfile() {
        if (this.task != null) {
            return this.task.getProfile();
        }
        return null;
    }

    @Override
    public void setConstants(Constants constants) {
        this.constants = constants;
    }

    @Override
    public DatabaseDescriptor getDBLogin(DatabaseDescriptor db) throws SQLException {
        if (this.ssHost == null) {
            return null;
        }
        return this.ssHost.getDBLogin(db);
    }

    @Override
    public ComponentList getComponents() {
        if (this.task != null) {
            return this.task.getComponents();
        }
        return null;
    }

    @Override
    public Collection<ScriptableObject> getDynamical() {
        return null;
    }

    @Override
    public RequestStatistics.Value rqstat() {
        return this.ssHost.rqstat();
    }

    @Override
    public void rqstat(RequestStatistics.Value value) {
        this.ssHost.rqstat(value);
    }

    @Override
    public void personalSessionCreated(ConnectionManager cm) {
        this.ssHost.personalSessionCreated(cm);
    }

    @Override
    public void personalSessionClosed(ConnectionManager cm) {
        this.ssHost.personalSessionClosed(cm);
    }

    @Override
    public void standing(long time) {
        this.ssHost.standing(time);
    }

    @Override
    public SSContext getSSContext() {
        return this.ssContext;
    }

    public static Collection<SortingField> sortingInfoToSortingFields(TableDescriptor tableDescriptor, int nullSortKind, Collection<SortInfo> sortInfoFields) {
        if (sortInfoFields == null || sortInfoFields.isEmpty()) {
            return null;
        }
        ArrayList<SortingField> sorting = new ArrayList<SortingField>();
        for (SortInfo sf : sortInfoFields) {
            FieldDescriptor fieldToSort = tableDescriptor.getFieldDescriptor(sf.path[0]);
            if (fieldToSort == null) continue;
            SortingField field = new SortingField(tableDescriptor, nullSortKind, fieldToSort, sf.direction, sf.path);
            sorting.add(field);
        }
        if (sorting.isEmpty()) {
            return null;
        }
        return sorting;
    }

    public static class SortInfo {
        private final int[] path;
        private final SortDirection direction;

        public SortInfo(int[] path, SortDirection direction) {
            this.path = path;
            this.direction = direction;
        }
    }
}

