/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.spreadsheets.excel.ExcelWorkbook;
import inform.agent.scripts.spreadsheets.ods.OdsWorkbook;
import inform.agent.scripts.textutils.TextExtractor;
import inform.common.SmartScriptableObject;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class SpreadsheetsLibrary
extends SmartScriptableObject {
    public static final int BORDERSIDE_TOP = 0;
    public static final int BORDERSIDE_RIGHT = 1;
    public static final int BORDERSIDE_BOTTOM = 2;
    public static final int BORDERSIDE_LEFT = 3;
    public static final int BORDERSIDE_ALL = 4;
    public static final int CELLTYPE_UNKNOWN = 0;
    public static final int CELLTYPE_BLANK = 1;
    public static final int CELLTYPE_NUMERIC = 2;
    public static final int CELLTYPE_STRING = 3;
    public static final int CELLTYPE_BOOLEAN = 4;
    public static final int CELLTYPE_DATE = 5;
    private static final String MESSAGE_BADTYPE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0442\u0438\u043f\u043e\u043c '%s'. \u041f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c, \u043f\u043e\u043b\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b (\u0441 \u0442\u0438\u043f\u043e\u043c Blob \u0438\u043b\u0438 BlobFile) \u0438\u043b\u0438 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u0444\u0430\u0439\u043b\u0430.";

    public SpreadsheetsLibrary(Scriptable scope) {
        this.setParentScope(scope);
        SpreadsheetsLibrary.putConstProperty(this, "BORDER_SIDE_TOP", 0);
        SpreadsheetsLibrary.putConstProperty(this, "BORDER_SIDE_RIGHT", 1);
        SpreadsheetsLibrary.putConstProperty(this, "BORDER_SIDE_BOTTOM", 2);
        SpreadsheetsLibrary.putConstProperty(this, "BORDER_SIDE_LEFT", 3);
        SpreadsheetsLibrary.putConstProperty(this, "BORDER_SIDE_ALL", 4);
        SpreadsheetsLibrary.putConstProperty(this, "CELL_TYPE_UNKNOWN", 0);
        SpreadsheetsLibrary.putConstProperty(this, "CELL_TYPE_NUMERIC", 2);
        SpreadsheetsLibrary.putConstProperty(this, "CELL_TYPE_STRING", 3);
        SpreadsheetsLibrary.putConstProperty(this, "CELL_TYPE_BOOLEAN", 4);
        SpreadsheetsLibrary.putConstProperty(this, "CELL_TYPE_BLANK", 1);
        SpreadsheetsLibrary.putConstProperty(this, "CELL_TYPE_DATE", 5);
        for (FontUnderline fontUnderline : FontUnderline.values()) {
            SpreadsheetsLibrary.putConstProperty(this, "FONT_UNDERLINE_" + fontUnderline.name(), fontUnderline.getValue());
        }
        for (FontUnderline fontUnderline : HorizontalAlignment.values()) {
            SpreadsheetsLibrary.putConstProperty(this, "HORIZONTAL_ALIGN_" + fontUnderline.name(), fontUnderline.getCode());
        }
        for (FontUnderline fontUnderline : VerticalAlignment.values()) {
            SpreadsheetsLibrary.putConstProperty(this, "VERTICAL_ALIGN_" + fontUnderline.name(), fontUnderline.getCode());
        }
        for (FontUnderline fontUnderline : BorderStyle.values()) {
            SpreadsheetsLibrary.putConstProperty(this, "BORDER_STYLE_" + fontUnderline.name(), fontUnderline.getCode());
        }
        for (FontUnderline fontUnderline : FillPatternType.values()) {
            SpreadsheetsLibrary.putConstProperty(this, "FILL_" + fontUnderline.name(), fontUnderline.getCode());
        }
    }

    @Override
    public String getClassName() {
        return "Spreadsheets";
    }

    @SmartScriptableObject.FunctionTag
    public OdsWorkbook createOdsWorkbook() throws Exception {
        return OdsWorkbook.createOdsWorkbook(this);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook createXlsWorkbook() {
        return ExcelWorkbook.createExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelWorkbook createXlsxWorkbook() {
        return ExcelWorkbook.createExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX);
    }

    @SmartScriptableObject.FunctionTag
    public Object openWorkbook(Object dataSource, Object documentFormat) throws Exception {
        String fileFormat;
        if (documentFormat instanceof Undefined) {
            fileFormat = this.getFileFormat(dataSource.toString());
            if (fileFormat.equals("")) {
                throw new InformException(String.format(MESSAGE_BADTYPE, dataSource.getClass().getName()));
            }
        } else if (!(documentFormat.toString().equalsIgnoreCase("ODS") || documentFormat.toString().equalsIgnoreCase("XLS") || documentFormat.toString().equalsIgnoreCase("XLSX"))) {
            fileFormat = this.getFileFormat(documentFormat.toString());
            if (fileFormat.equals("")) {
                throw new InformException(String.format(MESSAGE_BADTYPE, dataSource.getClass().getName()));
            }
        } else {
            fileFormat = documentFormat.toString();
        }
        if (fileFormat != null) {
            if (fileFormat.equalsIgnoreCase("ODS")) {
                if (dataSource instanceof BinaryObject) {
                    return OdsWorkbook.openOdsWorkbook((Scriptable)this, (BinaryObject)dataSource);
                }
                if (dataSource instanceof DatasourceField) {
                    return OdsWorkbook.openOdsWorkbook((Scriptable)this, (DatasourceField)dataSource);
                }
                return OdsWorkbook.openOdsWorkbook((Scriptable)this, dataSource.toString());
            }
            if (fileFormat.equalsIgnoreCase("XLS")) {
                if (dataSource instanceof BinaryObject) {
                    return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS, (BinaryObject)dataSource);
                }
                if (dataSource instanceof DatasourceField) {
                    return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS, (DatasourceField)dataSource);
                }
                return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLS, dataSource.toString());
            }
            if (fileFormat.equalsIgnoreCase("XLSX")) {
                if (dataSource instanceof BinaryObject) {
                    return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX, (BinaryObject)dataSource);
                }
                if (dataSource instanceof DatasourceField) {
                    return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX, (DatasourceField)dataSource);
                }
                return ExcelWorkbook.openExcelWorkbook(this, TextExtractor.DOCUMENT_FORMAT.DOCUMENT_XLSX, dataSource.toString());
            }
        }
        throw new InformException(String.format(MESSAGE_BADTYPE, dataSource.getClass().getName()));
    }

    private String getFileFormat(String filePath) {
        int lastDotIndex = filePath.lastIndexOf(".");
        if (lastDotIndex != -1 && lastDotIndex < filePath.length() - 1) {
            return filePath.substring(lastDotIndex + 1);
        }
        return "";
    }
}

