/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.RequestMonitor;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class SysLogLibrary
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"writeLine", "traceLabel"};
    private StringBuilder logLine = new StringBuilder();
    private final ServerSideHost ssHost;
    private final SSContext ssContext;

    SysLogLibrary(Scriptable scope, ServerSideHost ssHost) {
        SSContext context = ssHost != null ? (ssHost instanceof ScriptableHost ? ((ScriptableHost)((Object)ssHost)).getRootContext() : ssHost.getSSContext()) : null;
        this.ssHost = ssHost;
        this.ssContext = context;
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, SysLogLibrary.class, 0);
    }

    @Override
    public String getClassName() {
        return "SysLog";
    }

    public void innerTraceLabel(String label) throws Exception {
        SSContext.Component context = new SSContext.Component(this.ssContext, 1);
        RequestMonitor.Stat rqStat = new RequestMonitor.Stat(context, label);
        rqStat.startTime = System.currentTimeMillis();
        rqStat.startTimeNano = rqStat.closeTimeNano = System.nanoTime();
        RequestMonitor.putRequest(rqStat);
        if (this.ssHost != null) {
            this.ssHost.sendTraceLabel(context, label);
        }
    }

    public static Object traceLabel(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        SysLogLibrary lib = (SysLogLibrary)thisObj;
        lib.logLine.setLength(0);
        boolean separator = false;
        for (Object o : args) {
            if (separator) {
                lib.logLine.append(" ");
            }
            separator = true;
            lib.logLine.append(ValueCaster.toString(o));
        }
        lib.innerTraceLabel(lib.logLine.toString());
        lib.logLine.delete(0, lib.logLine.length());
        return Undefined.instance;
    }

    public static Object writeLine(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException {
        SysLogLibrary lib = (SysLogLibrary)thisObj;
        lib.internalWriteLine(args);
        return Undefined.instance;
    }

    private void internalWriteLine(Object[] args) throws InformException {
        this.logLine.setLength(0);
        this.logLine.append("[JS]");
        for (Object o : args) {
            this.logLine.append(" ");
            this.logLine.append(ValueCaster.toString(o));
        }
        Core.logger.info(this.logLine.toString());
    }
}

