/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.crypto.CryptoCertificate;
import inform.common.SmartScriptableObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class CryptoStore
extends SmartScriptableObject {
    protected final KeyStore keyStore;

    public CryptoStore(Scriptable scope, String storeTypeName, String storeFilePath, Object storePassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        this.setParentScope(scope);
        char[] storePass = storePassword instanceof String && !((String)storePassword).isEmpty() ? ((String)storePassword).toCharArray() : null;
        this.keyStore = KeyStore.getInstance(storeTypeName, "JCP");
        if (storeFilePath != null && !storeFilePath.isEmpty()) {
            try (FileInputStream is = new FileInputStream(new File(storeFilePath));){
                this.keyStore.load(is, storePass);
            }
        } else {
            this.keyStore.load(null, storePass);
        }
    }

    @Override
    public String getClassName() {
        return "CryptoStore";
    }

    public KeyManagerFactory getKeyManagerFactory(String algorithmName, String keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithmName);
        kmf.init(this.keyStore, keyPassword == null || keyPassword.isEmpty() ? null : keyPassword.toCharArray());
        return kmf;
    }

    public TrustManagerFactory getTrustManagerFactory(String algorithmName) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithmName);
        tmf.init(this.keyStore);
        return tmf;
    }

    @SmartScriptableObject.PropertyTag
    public Object getAliases() throws KeyStoreException {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            list.add(aliases.nextElement());
        }
        Collections.sort(list);
        return Context.javaToJS(list.toArray(), this);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoCertificate getCertificate(String aliasName) throws KeyStoreException {
        Certificate certificate = this.keyStore.getCertificate(aliasName);
        return certificate == null ? null : new CryptoCertificate((Scriptable)this, certificate);
    }

    @SmartScriptableObject.FunctionTag
    public Object getCertificateChain(String aliasName) throws KeyStoreException {
        Certificate[] certificateChain = this.keyStore.getCertificateChain(aliasName);
        ArrayList<CryptoCertificate> list = new ArrayList<CryptoCertificate>();
        if (certificateChain != null) {
            for (Certificate certificate : certificateChain) {
                list.add(new CryptoCertificate((Scriptable)this, certificate));
            }
        }
        return Context.javaToJS(list.toArray(), this);
    }
}

