/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.expr;

import inform.adt.DateTime;
import inform.adt.TimeInfo;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.expr.Expression;
import inform.agent.expr.OperationTerm;
import inform.agent.scripts.DateLibrary;
import inform.agent.scripts.expr.SSTableArgument;
import inform.agent.scripts.expr.SSTableEvaluator;
import inform.agent.scripts.expr.SSTableOperation;

public class SSTableCompare
extends SSTableOperation {
    final OperationTerm operationTerm;
    final DateLibrary dates = new DateLibrary(null);

    public SSTableCompare(OperationTerm term, SSTableEvaluator left, SSTableEvaluator right) {
        super(term, left, right);
        this.operationTerm = term;
    }

    @Override
    public boolean execute() throws Exception {
        if (this.isIgnored()) {
            return true;
        }
        if (!(this.left instanceof SSTableArgument) || !(this.right instanceof SSTableArgument)) {
            return false;
        }
        SSTableArgument a1 = (SSTableArgument)this.left;
        SSTableArgument a2 = (SSTableArgument)this.right;
        DataType dataType = SSTableCompare.normalizeType(a1.getDataType());
        switch (this.term.getToken()) {
            case less: {
                a1.compactNonNulls(false, this.operationTerm.getRangeId() == 5);
                a2.compactNonNulls(true, this.operationTerm.getRangeId() == 5);
                break;
            }
            case greater: {
                a1.compactNonNulls(false, this.operationTerm.getRangeId() == 5);
                a2.compactNonNulls(true, this.operationTerm.getRangeId() == 5);
                break;
            }
            case lessEqual: {
                a1.compactNonNulls(false, this.operationTerm.getRangeId() == 5);
                a2.compactNonNulls(true, this.operationTerm.getRangeId() == 5);
                break;
            }
            case greaterEqual: {
                a1.compactNonNulls(false, this.operationTerm.getRangeId() == 5);
                a2.compactNonNulls(true, this.operationTerm.getRangeId() == 5);
                break;
            }
            case like: {
                a1.compactNulls();
                a2.compactNulls();
                break;
            }
            case notLike: {
                a1.compactNulls();
                a2.compactNulls();
                break;
            }
            case startWith: {
                a1.compactNulls();
                a2.compactNulls();
                break;
            }
            case notStartWith: {
                a1.compactNulls();
                a2.compactNulls();
            }
        }
        if (a2.valueCount() > 1) {
            return this.executeMultiple(dataType, a1.getValue(), (Object[])a2.getValue());
        }
        if (a1.isNull() || a2.isNull()) {
            return this.executeNull(a1.isNull(), a2.isNull());
        }
        switch (dataType) {
            case FLOAT: 
            case METATREE_NODE: {
                return this.executeNumber(a1.getValue(), a2.getValue());
            }
            case DATE_TIME: {
                return this.executeDate(a1.getValue(), a2.getValue());
            }
            case BOOLEAN: {
                return this.executeBool(a1.getValue(), a2.getValue());
            }
            case STRING: {
                return this.executeString(a1.getValue(), a2.getValue());
            }
        }
        return false;
    }

    boolean executeMultiple(DataType dataType, Object f, Object[] values) throws Exception {
        if (f == null) {
            Expression.Token op = this.term.getToken();
            switch (op) {
                case like: 
                case equal: {
                    for (Object v : values) {
                        if (v != null) continue;
                        return true;
                    }
                }
                case notLike: 
                case notEqual: {
                    for (Object v : values) {
                        if (v == null) continue;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        switch (dataType) {
            case FLOAT: 
            case METATREE_NODE: {
                for (Object v : values) {
                    if (!this.executeNumber(f, v)) continue;
                    return true;
                }
                return false;
            }
            case DATE_TIME: {
                for (Object v : values) {
                    if (!this.executeDate(f, v)) continue;
                    return true;
                }
                return false;
            }
            case BOOLEAN: {
                for (Object v : values) {
                    if (!this.executeBool(f, v)) continue;
                    return true;
                }
                return false;
            }
        }
        switch (this.term.getToken()) {
            case notLike: 
            case notStartWith: 
            case notEqual: {
                for (Object v : values) {
                    if (this.executeString(f, v)) continue;
                    return false;
                }
                return true;
            }
        }
        for (Object v : values) {
            if (!this.executeString(f, v)) continue;
            return true;
        }
        return false;
    }

    boolean executeNull(boolean a1, boolean a2) throws Exception {
        if (a1 && a2) {
            return this.term.getToken() == Expression.Token.equal;
        }
        switch (this.term.getToken()) {
            case notLike: 
            case notStartWith: 
            case notEqual: {
                return true;
            }
        }
        return false;
    }

    boolean executeNumber(Object field, Object value) throws Exception {
        Expression.Token op = this.term.getToken();
        if (field == null && value == null) {
            return op == Expression.Token.equal || op == Expression.Token.like;
        }
        if (field == null || value == null) {
            return op == Expression.Token.notEqual || op == Expression.Token.notLike;
        }
        double f = ValueCaster.toDouble(field);
        double v = ValueCaster.toDouble(value);
        switch (op) {
            case like: 
            case equal: {
                return f == v;
            }
            case notLike: 
            case notEqual: {
                return f != v;
            }
            case greater: {
                return f > v;
            }
            case greaterEqual: {
                return f >= v;
            }
            case less: {
                return f < v;
            }
            case lessEqual: {
                return f <= v;
            }
        }
        return false;
    }

    boolean executeDate(Object field, Object value) throws Exception {
        double v2;
        double v1;
        Expression.Token op = this.term.getToken();
        if (field == null && value == null) {
            return op == Expression.Token.equal || op == Expression.Token.like;
        }
        if (field == null || value == null) {
            return op == Expression.Token.notEqual || op == Expression.Token.notLike;
        }
        double f = ValueCaster.toDouble(field);
        double v = ValueCaster.toDouble(value);
        boolean hasRange = true;
        switch (this.operationTerm.getRangeId()) {
            case 1: {
                v1 = this.dates.dateOf(v);
                v2 = v1 + 1.0;
                break;
            }
            case 2: {
                v1 = this.dates.beginOfMonth(v);
                Object[] args = new Object[]{v1, 1};
                v2 = DateLibrary.incMonth(null, null, args, null);
                break;
            }
            case 3: {
                TimeInfo time = new TimeInfo();
                DateTime.toTimeInfo(v, time);
                time.day = 1;
                time.month = time.month < 4 ? 1 : (time.month < 7 ? 4 : (time.month < 10 ? 7 : 10));
                v1 = DateTime.create(time.year, time.month, time.day);
                Object[] args = new Object[]{v1, 3};
                v2 = DateLibrary.incMonth(null, null, args, null);
                break;
            }
            case 4: {
                v1 = this.dates.beginOfYear(v);
                Object[] args = new Object[]{v1, 1};
                v2 = DateLibrary.incYear(null, null, args, null);
                break;
            }
            default: {
                v1 = v2 = v;
                hasRange = false;
            }
        }
        switch (op) {
            case like: 
            case equal: {
                if (hasRange) {
                    return v1 <= f && f < v2;
                }
                return f == v;
            }
            case notLike: 
            case notEqual: {
                if (hasRange) {
                    return !(v1 <= f) || !(f < v2);
                }
                return f != v;
            }
            case greater: {
                if (hasRange) {
                    return f >= v2;
                }
                return f > v;
            }
            case greaterEqual: {
                if (hasRange) {
                    return f >= v1;
                }
                return f >= v;
            }
            case less: {
                if (hasRange) {
                    return f < v1;
                }
                return f < v;
            }
            case lessEqual: {
                if (hasRange) {
                    return f < v2;
                }
                return f <= v;
            }
        }
        return false;
    }

    boolean executeBool(Object field, Object value) throws Exception {
        Expression.Token op = this.term.getToken();
        if (field == null && value == null) {
            return op == Expression.Token.equal || op == Expression.Token.like;
        }
        if (field == null || value == null) {
            return op == Expression.Token.notEqual || op == Expression.Token.notLike;
        }
        boolean f = ValueCaster.toBoolean(field) != false;
        boolean v = ValueCaster.toBoolean(value) != false;
        switch (op) {
            case like: 
            case equal: {
                return f == v;
            }
            case notLike: 
            case notEqual: {
                return f != v;
            }
            case greater: {
                return f > v;
            }
            case greaterEqual: {
                return f >= v;
            }
            case less: {
                return f < v;
            }
            case lessEqual: {
                return f <= v;
            }
        }
        return false;
    }

    boolean executeString(Object field, Object value) throws Exception {
        Expression.Token op = this.term.getToken();
        if (field == null && value == null) {
            return op == Expression.Token.equal || op == Expression.Token.like;
        }
        if (field == null || value == null) {
            return op == Expression.Token.notEqual || op == Expression.Token.notLike;
        }
        String f = ValueCaster.toString(field);
        String v = ValueCaster.toString(value);
        if (this.operationTerm.getRangeId() == 5) {
            f = f.toLowerCase();
            v = v.toLowerCase();
        }
        switch (op) {
            case like: {
                return f.contains(v);
            }
            case equal: {
                return f.equals(v);
            }
            case notLike: {
                return !f.contains(v);
            }
            case notEqual: {
                return !f.equals(v);
            }
            case greater: {
                return f.compareTo(v) > 0;
            }
            case greaterEqual: {
                return f.compareTo(v) >= 0;
            }
            case less: {
                return f.compareTo(v) < 0;
            }
            case lessEqual: {
                return f.compareTo(v) <= 0;
            }
            case startWith: {
                return f.startsWith(v);
            }
            case notStartWith: {
                return !f.startsWith(v);
            }
        }
        return false;
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.left.isIgnored() || this.right.isIgnored();
    }
}

