/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

public class CurrencyFormat {
    public static final int snkFull = 0;
    public static final int snkInt = 1;
    public static final int snkFrac = 2;
    static final int crRus = 1;
    static final int crUs = 2;
    static final int crNone = 3;

    private static String NumberToSpell(String s) {
        return CurrencyFormat.NumberToSpell(s, false);
    }

    private static String EndingOfNumber(String val) {
        String[] wordEnding = new String[]{"\u044b\u0445", "\u0430\u044f", "\u044b\u0445", "\u044b\u0445", "\u044b\u0445", "\u044b\u0445", "\u044b\u0445", "\u044b\u0445", "\u044b\u0445", "\u044b\u0445"};
        int index = val.length() - 1;
        int lastChar = index > 0 && val.charAt(index) == '1' ? 49 : val.charAt(index);
        return wordEnding[Integer.parseInt(String.valueOf((char)lastChar))];
    }

    private static char IIF(boolean i, char s1, char s2) {
        return i ? s1 : s2;
    }

    private static String IIF(boolean i, String s1, String s2) {
        return i ? s1 : s2;
    }

    private static String Num000toStr(String s, boolean woman) {
        String[] c100 = new String[]{"", "\u0441\u0442\u043e ", "\u0434\u0432\u0435\u0441\u0442\u0438 ", "\u0442\u0440\u0438\u0441\u0442\u0430 ", "\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430 ", "\u043f\u044f\u0442\u044c\u0441\u043e\u0442 ", "\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442 ", "\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ", "\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ", "\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442 "};
        String[] c10 = new String[]{"", "\u0434\u0435\u0441\u044f\u0442\u044c ", "\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c ", "\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c ", "\u0441\u043e\u0440\u043e\u043a ", "\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ", "\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ", "\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ", "\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ", "\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e "};
        String[] c11 = new String[]{"", "\u043e\u0434\u0438\u043d", "\u0434\u0432\u0435", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u044b\u0440", "\u043f\u044f\u0442", "\u0448\u0435\u0441\u0442", "\u0441\u0435\u043c", "\u0432\u043e\u0441\u0435\u043c", "\u0434\u0435\u0432\u044f\u0442"};
        String[] c1f = new String[]{"", "\u043e\u0434\u0438\u043d ", "\u0434\u0432\u0430 ", "\u0442\u0440\u0438 ", "\u0447\u0435\u0442\u044b\u0440\u0435 ", "\u043f\u044f\u0442\u044c ", "\u0448\u0435\u0441\u0442\u044c ", "\u0441\u0435\u043c\u044c ", "\u0432\u043e\u0441\u0435\u043c\u044c ", "\u0434\u0435\u0432\u044f\u0442\u044c "};
        String[] c1t = new String[]{"", "\u043e\u0434\u043d\u0430 ", "\u0434\u0432\u0435 ", "\u0442\u0440\u0438 ", "\u0447\u0435\u0442\u044b\u0440\u0435 ", "\u043f\u044f\u0442\u044c ", "\u0448\u0435\u0441\u0442\u044c ", "\u0441\u0435\u043c\u044c ", "\u0432\u043e\u0441\u0435\u043c\u044c ", "\u0434\u0435\u0432\u044f\u0442\u044c "};
        int zero_c = Integer.parseInt(String.valueOf(s.charAt(0)));
        int first_c = Integer.parseInt(String.valueOf(s.charAt(1)));
        int second_c = Integer.parseInt(String.valueOf(s.charAt(2)));
        return c100[zero_c] + CurrencyFormat.IIF(s.charAt(1) == '1' && s.charAt(2) > '0', c11[second_c] + "\u043d\u0430\u0434\u0446\u0430\u0442\u044c ", c10[first_c] + (woman ? c1t[second_c] : c1f[second_c]));
    }

    private static String NumberToSpell(String s, boolean isIntPart) {
        boolean is_minus;
        int Max000 = 6;
        int MaxPosition = 18;
        String[] c1000 = new String[]{"", "\u0442\u044b\u0441\u044f\u0447", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d"};
        boolean[] c1000w = new boolean[]{false, true, false, false, false, false, false};
        String[] wf = new String[]{"\u043e\u0432 ", " ", "\u0430 ", "\u0430 ", "\u0430 ", "\u043e\u0432 ", "\u043e\u0432 ", "\u043e\u0432 ", "\u043e\u0432 ", "\u043e\u0432 "};
        String[] wt = new String[]{" ", "\u0430 ", "\u0438 ", "\u0438 ", "\u0438 ", " ", " ", " ", " ", " "};
        Object result = "";
        int i = 0;
        boolean bl = is_minus = !s.isEmpty() && s.charAt(0) == '-';
        if (is_minus) {
            s = s.substring(1, s.length() - 1);
        }
        while (!((double)i >= Math.ceil((double)s.length() / 3.0)) && i < 6) {
            String tmp = "00" + s;
            int start_index = s.length() - i * 3 - 1;
            String s000 = tmp.substring(start_index, start_index + 3);
            boolean isw = c1000w[i];
            if (i > 0 && !"000".equals(s000)) {
                int iff = Integer.parseInt(String.valueOf(CurrencyFormat.IIF(s000.charAt(1) == '1', '0', s000.charAt(2))));
                result = c1000[i] + (isw ? wt[iff] : wf[iff]) + (String)result;
            }
            result = CurrencyFormat.Num000toStr(s000, isw) + (String)result;
            ++i;
        }
        if (((String)result).isEmpty()) {
            result = "\u043d\u043e\u043b\u044c";
        }
        if (is_minus) {
            result = "\u043c\u0438\u043d\u0443\u0441 " + (String)result;
        }
        return result;
    }

    public static String NumberToSpelledString(double num, int prec, int kind, boolean showWhole) {
        String frac_part;
        String int_part;
        int dot_pos;
        String[] fracWord = new String[]{" ", " \u0434\u0435\u0441\u044f\u0442", " \u0441\u043e\u0442", " \u0442\u044b\u0441\u044f\u0447\u043d", " \u0434\u0435\u0441\u044f\u0442\u0438\u0442\u044b\u0441\u044f\u0447", " \u0441\u0442\u043e\u0442\u044b\u0441\u044f\u0447\u043d", " \u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043d", " \u0434\u0435\u0441\u044f\u0442\u0438\u043c\u0438\u043b\u0438\u043d\u043d", " \u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043d"};
        Object result = "";
        if (prec < 0) {
            prec = 0;
        }
        if (prec > 8) {
            prec = 8;
        }
        String numStr = String.format("%100." + prec + "f", num).trim();
        int index = numStr.length() - 1;
        for (int i = numStr.length() - 1; i > 0; --i) {
            if (numStr.charAt(i) == '0') continue;
            index = i + 1;
            break;
        }
        if ((dot_pos = (numStr = numStr.substring(0, index)).indexOf(44)) < 1) {
            int_part = numStr;
            frac_part = "";
            kind = 1;
        } else {
            int_part = numStr.substring(0, dot_pos);
            frac_part = numStr.substring(dot_pos + 1, numStr.length());
        }
        switch (kind) {
            case 0: {
                result = CurrencyFormat.NumberToSpell(int_part) + " \u0446\u0435\u043b" + CurrencyFormat.EndingOfNumber(int_part);
                if (frac_part.isEmpty()) {
                    frac_part = "0";
                }
                result = (String)result + " " + CurrencyFormat.NumberToSpell(frac_part) + fracWord[frac_part.length()] + CurrencyFormat.EndingOfNumber(frac_part);
                break;
            }
            case 1: {
                if (showWhole) {
                    result = CurrencyFormat.NumberToSpell(int_part) + " \u0446\u0435\u043b" + CurrencyFormat.EndingOfNumber(int_part);
                    break;
                }
                result = CurrencyFormat.NumberToSpell(int_part, true);
                break;
            }
            case 2: {
                if (frac_part.isEmpty()) {
                    frac_part = "0";
                }
                result = " " + CurrencyFormat.NumberToSpell(frac_part) + fracWord[frac_part.length()] + CurrencyFormat.EndingOfNumber(frac_part);
            }
        }
        return result;
    }

    private static String EndingDolPart(String val, int currency) {
        String[] rubEnding = new String[]{"\u0435\u0439", "\u044c", "\u044f", "\u044f", "\u044f", "\u0435\u0439", "\u0435\u0439", "\u0435\u0439", "\u0435\u0439", "\u0435\u0439"};
        String[] dolEnding = new String[]{"\u043e\u0432", "", "\u0430", "\u0430", "\u0430", "\u043e\u0432", "\u043e\u0432", "\u043e\u0432", "\u043e\u0432", "\u043e\u0432"};
        int index = val.length() - 1;
        int _index = index - 1;
        char lastChar = index > 0 && val.charAt(index) == '1' ? (char)'1' : val.charAt(index);
        int prevChar = _index >= 0 ? (int)val.charAt(_index) : 48;
        if (prevChar == 49) {
            switch (currency) {
                case 1: {
                    return "\u0440\u0443\u0431\u043b\u0435\u0439";
                }
                case 2: {
                    return "\u0434\u043e\u043b\u043b\u0430\u0440\u043e\u0432";
                }
            }
        } else {
            int idx = Integer.parseInt(String.valueOf(lastChar));
            switch (currency) {
                case 1: {
                    return "\u0440\u0443\u0431\u043b" + rubEnding[idx];
                }
                case 2: {
                    return "\u0434\u043e\u043b\u043b\u0430\u0440" + dolEnding[idx];
                }
            }
        }
        return "";
    }

    private static String EndingCentPart(String val, int currency) {
        String[] copEnding = new String[]{"\u0435\u043a", "\u0439\u043a\u0430", "\u0439\u043a\u0438", "\u0439\u043a\u0438", "\u0439\u043a\u0438", "\u0435\u043a", "\u0435\u043a", "\u0435\u043a", "\u0435\u043a", "\u0435\u043a"};
        String[] centEnding = new String[]{"\u043e\u0432", "", "\u0430", "\u0430", "\u0430", "\u043e\u0432", "\u043e\u0432", "\u043e\u0432", "\u043e\u0432", "\u043e\u0432"};
        int index = val.length() - 1;
        int lastChar = index > 0 && val.charAt(index) == '1' ? 49 : val.charAt(index);
        int idx = Integer.parseInt(String.valueOf((char)lastChar));
        switch (currency) {
            case 1: {
                return "\u043a\u043e\u043f\u0435" + copEnding[idx];
            }
            case 2: {
                return "\u0446\u0435\u043d\u0442" + centEnding[idx];
            }
        }
        return "";
    }

    public static String NumberToMoneyString(double num, boolean show_cents, int currency) {
        String frac_part;
        String int_part;
        int dot_pos;
        Object result = "";
        String numStr = String.format("%100.2f", num).trim();
        int index = numStr.length() - 1;
        for (int i = numStr.length() - 1; i > 0; --i) {
            if (numStr.charAt(i) == '0') continue;
            index = i + 1;
            break;
        }
        if ((dot_pos = (numStr = numStr.substring(0, index)).indexOf(44)) < 1) {
            int_part = numStr;
            frac_part = "";
        } else {
            int_part = numStr.substring(0, dot_pos);
            frac_part = numStr.substring(dot_pos + 1, numStr.length());
        }
        result = CurrencyFormat.NumberToSpell(int_part, true) + CurrencyFormat.EndingDolPart(int_part, currency);
        if (show_cents && !frac_part.isEmpty()) {
            result = (String)result + " " + CurrencyFormat.NumberToSpell(frac_part) + CurrencyFormat.EndingCentPart(frac_part, currency);
        }
        return result;
    }
}

