/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.InformException;
import inform.adt.collections.IntegerList;
import inform.agent.Core;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.metadata.ScriptNode;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class InetAddList
extends ScriptableObject {
    private static final String MSG_IVALID_IP_ADDRESS = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 ip \u0430\u0434\u0440\u0435\u0441 (%s)";
    private ScriptNode node;
    private IntegerList ips;
    private int tag;
    private static final String[] jsMethods = new String[]{"add", "clear"};
    private static final String[] jsReadonlyProperties = new String[]{"count"};

    public InetAddList(ScriptNode node, int tag, IntegerList ips) {
        this.setParentScope(node);
        this.defineFunctionProperties(jsMethods, InetAddList.class, 0);
        for (String propertyName : jsReadonlyProperties) {
            this.defineProperty(propertyName, InetAddList.class, 1);
        }
        this.node = node;
        this.tag = tag;
        this.ips = ips == null ? new IntegerList(4) : new IntegerList(ips);
    }

    private void setModified() {
        this.node.setAttrTagModified(this.tag);
    }

    private String ipToString(int v) {
        return String.format("%d.%d.%d.%d", v & 0xFF, (v & 0xFF00) >> 8, (v & 0xFF0000) >> 16, (v & 0xFF000000) >> 24);
    }

    private int stringToIP(String v) throws IOException {
        String value = v.replace('.', ':');
        StreamTokenizer parser = new StreamTokenizer(new StringReader(value));
        parser.resetSyntax();
        parser.parseNumbers();
        parser.ordinaryChar(46);
        parser.ordinaryChar(45);
        int ip = 0;
        if (parser.nextToken() != -2) {
            throw new InformException(String.format(MSG_IVALID_IP_ADDRESS, v));
        }
        ip |= (int)parser.nval & 0xFF;
        parser.nextToken();
        if (parser.nextToken() != -2) {
            throw new InformException(String.format(MSG_IVALID_IP_ADDRESS, v));
        }
        ip |= ((int)parser.nval & 0xFF) << 8;
        parser.nextToken();
        if (parser.nextToken() != -2) {
            throw new InformException(String.format(MSG_IVALID_IP_ADDRESS, v));
        }
        ip |= ((int)parser.nval & 0xFF) << 16;
        parser.nextToken();
        if (parser.nextToken() != -2) {
            throw new InformException(String.format(MSG_IVALID_IP_ADDRESS, v));
        }
        return ip |= ((int)parser.nval & 0xFF) << 24;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (index < 0 || index >= this.ips.size()) {
            return Scriptable.NOT_FOUND;
        }
        return this.ipToString(this.ips.get(index));
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (index < 0 || index >= this.ips.size()) {
            return;
        }
        try {
            this.ips.set(index, this.stringToIP(ValueCaster.toString(value)));
            this.setModified();
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            Context.reportError(ex.toString());
        }
    }

    public void add(String v) throws IOException {
        this.ips.add(this.stringToIP(v));
        this.setModified();
    }

    public void clear() {
        if (this.ips.empty()) {
            return;
        }
        this.ips.clear();
        this.setModified();
    }

    public int getCount() {
        return this.ips.size();
    }

    public IntegerList getIps() {
        if (this.ips.empty()) {
            return null;
        }
        return new IntegerList(this.ips);
    }

    @Override
    public String getClassName() {
        return "InetAddList";
    }
}

