/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.ScriptNode;
import inform.agent.scripts.metadata.ScriptUserNode;
import java.io.IOException;
import java.sql.SQLException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ScriptCustomNode
extends ScriptNode {
    protected Acl acl;
    protected boolean inheritedAcl = true;
    private byte[] inlineContent;
    private double pinNodeId;
    private static final String[] jsMethods = new String[]{"getAccessMask"};

    public ScriptCustomNode(MetadataLibrary metadataLibrary, MetadataNodeReader metadataNode) {
        super(metadataLibrary, metadataNode);
        this.defineFunctionProperties(jsMethods, ScriptCustomNode.class, 0);
    }

    public static Object getAccessMask(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException, SQLException {
        if (args.length == 0) {
            return 0;
        }
        ScriptCustomNode self = (ScriptCustomNode)thisObj;
        if (args[0] instanceof ScriptUserNode) {
            return self.calculateAccessMask((ScriptUserNode)args[0]);
        }
        double userId = ValueCaster.toDouble(args[0]);
        return self.calculateAccessMask(userId);
    }

    int calculateAccessMask(ScriptUserNode userNode) throws IOException, InformException, SQLException {
        this.idle();
        int mask = 0;
        switch (userNode.getUserRole()) {
            case ADMIN: {
                mask = -671088640;
            }
        }
        if (this.inheritedAcl) {
            if (this.getParentID() == userNode.getId()) {
                mask |= 0xC0000000;
            }
            for (ScriptNode node = this.getParent(); node != null; node = node.getParent()) {
                this.idle();
                if (!(node instanceof ScriptCustomNode)) continue;
                ScriptCustomNode parentNode = (ScriptCustomNode)node;
                if (parentNode.inheritedAcl) continue;
                return userNode.getAccessMask(parentNode.acl) | mask;
            }
            return mask;
        }
        return userNode.getAccessMask(this.acl) | mask;
    }

    int calculateAccessMask(double nodeId) throws IOException, InformException, SQLException {
        this.idle();
        ScriptNode node = this.metaLib.getNode(nodeId);
        if (node == null || !(node instanceof ScriptUserNode)) {
            return 0;
        }
        ScriptUserNode userNode = (ScriptUserNode)node;
        return this.calculateAccessMask(userNode);
    }

    @Override
    public String getClassName() {
        return "CustomNode";
    }

    @Override
    void loadTag(int tag, TaggedReader reader) throws IOException {
        this.idle();
        switch (tag) {
            case 2: {
                this.acl = new Acl();
                this.acl.load(reader);
                break;
            }
            case 18: {
                this.inheritedAcl = reader.getBoolean();
                break;
            }
            case 14: {
                this.inlineContent = reader.getRaw();
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }

    @Override
    public ScriptCustomNode getRefNode() {
        this.idle();
        return this;
    }
}

