/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.RolesTable;
import inform.agent.mtd.Security;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.ScriptUserRoles;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptableObject;

public class ScriptTableUser
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"save"};
    private static final String[] jsRWProperties = new String[]{"activeDirectory", "changePasswordOnLogin", "locked", "fio", "phone", "email", "inheritedStartup", "startupRootNodeId", "startupStartNodeId", "startupStartNodeAction", "startupScriptId", "startupStartWebNodeId", "canSetupUser", "canCreateAnyNodes", "canCreateNodeTypes", "canWritePublicFilters", "canViewMetadataHistory", "canViewDataHistory", "canUploadPex", "canWritePex", "editNode", "savePerRecord", "simplePopup", "inheritedCanSetupUser", "inheritedCanCreateNodes", "inheritedCanWritePublicFilters", "inheritedCanViewMetadataHistory", "inheritedCanViewDataHistory", "inheritedCanUploadPex", "inheritedCanWritePex", "inheritedEditNode", "inheritedSavePerRecord", "inheritedSimplePopup", "stdGroup", "singleLogin", "possibleLoginCount", "accessLevel", "login", "password"};
    private static final String[] jsRProperties = new String[]{"id", "roles", "constants"};
    public final SSContext ssContext;
    public final MetadataLibrary metadataLibrary;
    private final ServerSideHost ssHost;
    private final UsersTable usersTable;
    private final RolesTable rolesTable;
    private final AccountNode.UserInterface userInterface;
    private Constants constants = null;
    private final ScriptUserRoles roles;
    protected final double id;
    protected boolean activeDirectory = false;
    protected boolean changePasswordOnLogin = false;
    protected boolean locked = true;
    protected boolean inheritedStartup = true;
    protected String fio;
    protected String phone;
    protected String email;
    protected double rootNode = 0.0;
    protected double startNode = 0.0;
    protected int startAction = 0;
    protected double startScript = 0.0;
    protected double webStartNode = 0.0;
    protected double stdGroup = 0.0;
    protected boolean singleLogin = false;
    protected int possibleLoginCount = 0;
    protected UserRole userRole;
    protected String login;
    protected String password;

    ScriptTableUser(MetadataLibrary metadataLibrary, ServerSideHost ssHost, UsersTable usersTable, RolesTable rolesTable, double userId) {
        this.id = userId == 0.0 ? Core.generateId() : userId;
        this.metadataLibrary = metadataLibrary;
        this.ssContext = metadataLibrary.getSsContext();
        this.ssHost = ssHost;
        this.usersTable = usersTable;
        this.rolesTable = rolesTable;
        this.userInterface = new AccountNode.UserInterface();
        this.userRole = UserRole.DEFAULT;
        this.roles = new ScriptUserRoles();
        this.login = "";
        this.password = "";
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
        for (String propertyName : jsRWProperties) {
            this.defineProperty(propertyName, this.getClass(), 0);
        }
        for (String propertyName : jsRProperties) {
            this.defineProperty(propertyName, this.getClass(), 1);
        }
        this.userInterface.setAllInherited(true);
        this.userInterface.canSetupUser = false;
    }

    @Override
    public String getClassName() {
        return "ScriptTableUser";
    }

    public boolean getActiveDirectory() {
        return this.activeDirectory;
    }

    public void setActiveDirectory(boolean value) {
        this.activeDirectory = value;
    }

    public boolean getChangePasswordOnLogin() {
        return this.changePasswordOnLogin;
    }

    public void setChangePasswordOnLogin(boolean value) {
        this.changePasswordOnLogin = value;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean value) {
        this.locked = value;
    }

    public boolean getInheritedStartup() {
        return this.inheritedStartup;
    }

    public void setInheritedStartup(boolean value) {
        this.inheritedStartup = value;
    }

    public String getFio() {
        return this.fio;
    }

    public void setFio(String value) {
        this.fio = value;
    }

    public double getStartupRootNodeId() {
        return this.rootNode;
    }

    public void setStartupRootNodeId(double value) {
        this.rootNode = value;
        this.inheritedStartup = false;
    }

    public double getStartupStartNodeId() {
        return this.startNode;
    }

    public void setStartupStartNodeId(double value) {
        this.startNode = value;
        this.inheritedStartup = false;
    }

    public int getStartupStartNodeAction() {
        return this.startAction;
    }

    public void setStartupStartNodeAction(int value) {
        this.startAction = value;
        this.inheritedStartup = false;
    }

    public double getStartupScriptId() {
        return this.startScript;
    }

    public void setStartupScriptId(double value) {
        this.startScript = value;
        this.inheritedStartup = false;
    }

    public double getStartupStartWebNodeId() {
        return this.webStartNode;
    }

    public void setStartupStartWebNodeId(double value) {
        this.webStartNode = value;
        this.inheritedStartup = false;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String value) {
        this.phone = value;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    public double getId() {
        return this.id;
    }

    public boolean getInheritedSavePerRecord() {
        return this.userInterface.inheritedSavePerRecord;
    }

    public void setInheritedSavePerRecord(boolean value) {
        this.userInterface.inheritedSavePerRecord = value;
    }

    public boolean getInheritedCanSetupUser() {
        return this.userInterface.inheritedCanSetupUser;
    }

    public void setInheritedCanSetupUser(boolean value) {
        this.userInterface.inheritedCanSetupUser = value;
    }

    public boolean getInheritedCanCreateNodes() {
        return this.userInterface.inheritedCanCreateNodes;
    }

    public void setInheritedCanCreateNodes(boolean value) {
        this.userInterface.inheritedCanCreateNodes = value;
    }

    public boolean getInheritedSimplePopup() {
        return this.userInterface.inheritedSimplePopup;
    }

    public void setInheritedSimplePopup(boolean value) {
        this.userInterface.inheritedSimplePopup = value;
    }

    public boolean getInheritedCanWritePublicFilters() {
        return this.userInterface.inheritedCanWritePublicFilters;
    }

    public void setInheritedCanWritePublicFilters(boolean value) {
        this.userInterface.inheritedCanWritePublicFilters = value;
    }

    public boolean getInheritedCanWritePex() {
        return this.userInterface.inheritedCanWritePex;
    }

    public void setInheritedCanWritePex(boolean value) {
        this.userInterface.inheritedCanWritePex = value;
    }

    public boolean getInheritedEditNode() {
        return this.userInterface.inheritedEditNode;
    }

    public void setInheritedEditNode(boolean value) {
        this.userInterface.inheritedEditNode = value;
    }

    public boolean getInheritedCanUploadPex() {
        return this.userInterface.inheritedCanUploadPex;
    }

    public void setInheritedCanUploadPex(boolean value) {
        this.userInterface.inheritedCanUploadPex = value;
    }

    public boolean getInheritedCanViewDataHistory() {
        return this.userInterface.inheritedCanViewDataHistory;
    }

    public void setInheritedCanViewDataHistory(boolean value) {
        this.userInterface.inheritedCanViewDataHistory = value;
    }

    public boolean getInheritedCanViewMetadataHistory() {
        return this.userInterface.inheritedCanViewMetadataHistory;
    }

    public void setInheritedCanViewMetadataHistory(boolean value) {
        this.userInterface.inheritedCanViewMetadataHistory = value;
    }

    public boolean getCanSetupUser() {
        return this.userInterface.canSetupUser;
    }

    public void setCanSetupUser(boolean value) {
        this.userInterface.canSetupUser = value;
        this.userInterface.inheritedCanSetupUser = false;
    }

    public boolean getCanCreateAnyNodes() {
        return this.userInterface.canCreateAnyNodes;
    }

    public void setCanCreateAnyNodes(boolean value) {
        this.userInterface.canCreateAnyNodes = value;
        this.userInterface.inheritedCanCreateNodes = false;
    }

    public NativeArray getCanCreateNodeTypes() {
        int[] types = this.userInterface.canCreateNodeTypes;
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int type : types) {
            al.add(type);
        }
        return new NativeArray(al.toArray());
    }

    public void setCanCreateNodeTypes(NativeArray value) {
        int[] array = new int[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            array[i] = ValueCaster.toInt(value.get(i));
        }
        this.userInterface.canCreateNodeTypes = array;
        this.userInterface.canCreateAnyNodes = false;
        this.userInterface.inheritedCanCreateNodes = false;
    }

    public boolean getCanWritePublicFilters() {
        return this.userInterface.canWritePublicFilters;
    }

    public void setCanWritePublicFilters(boolean value) {
        this.userInterface.canWritePublicFilters = value;
        this.userInterface.inheritedCanWritePublicFilters = false;
    }

    public boolean getCanViewMetadataHistory() {
        return this.userInterface.canViewMetadataHistory || this.userRole == UserRole.ADMIN;
    }

    public void setCanViewMetadataHistory(boolean value) {
        this.userInterface.canViewMetadataHistory = value;
        this.userInterface.inheritedCanViewMetadataHistory = false;
    }

    public boolean getCanViewDataHistory() {
        return this.userInterface.canViewDataHistory || this.userRole == UserRole.ADMIN;
    }

    public void setCanViewDataHistory(boolean value) {
        this.userInterface.canViewDataHistory = value;
        this.userInterface.inheritedCanViewDataHistory = false;
    }

    public boolean getCanUploadPex() {
        return this.userInterface.canUploadPex;
    }

    public void setCanUploadPex(boolean value) {
        this.userInterface.canUploadPex = value;
        this.userInterface.inheritedCanUploadPex = false;
    }

    public boolean getCanWritePex() {
        return this.userInterface.canWritePex;
    }

    public void setCanWritePex(boolean value) {
        this.userInterface.canWritePex = value;
        this.userInterface.inheritedCanWritePex = false;
    }

    public boolean getEditNode() {
        return this.userInterface.editNode;
    }

    public void setEditNode(boolean value) {
        this.userInterface.editNode = value;
        this.userInterface.inheritedEditNode = false;
    }

    public boolean getSavePerRecord() {
        return this.userInterface.savePerRecord;
    }

    public void setSavePerRecord(boolean value) {
        this.userInterface.savePerRecord = value;
        this.userInterface.inheritedSavePerRecord = false;
    }

    public boolean getSimplePopup() {
        return this.userInterface.simplePopup;
    }

    public void setSimplePopup(boolean value) {
        this.userInterface.simplePopup = value;
        this.userInterface.inheritedSimplePopup = false;
    }

    public double getStdGroup() {
        return this.stdGroup;
    }

    public void setStdGroup(double value) {
        this.stdGroup = value;
    }

    public boolean getSingleLogin() {
        return this.singleLogin;
    }

    public void setSingleLogin(boolean value) {
        this.singleLogin = value;
        this.possibleLoginCount = this.singleLogin ? 1 : 0;
    }

    public int getPossibleLoginCount() {
        return this.possibleLoginCount;
    }

    public void setPossibleLoginCount(int value) {
        this.possibleLoginCount = value;
    }

    public int getAccessLevel() {
        return this.userRole.toInt();
    }

    public void setAccessLevel(int value) {
        this.userRole = UserRole.get(value);
        if (this.userRole == null) {
            this.userRole = UserRole.DEFAULT;
        }
    }

    public Object getRoles() {
        return this.roles;
    }

    public Object getConstants() throws InformException, IOException {
        this.idle();
        if (this.constants == null) {
            this.constants = new Constants(this.getId());
            this.constants.loadFromUser(this.stdGroup, this.metadataLibrary.getGlobalConstantsContent(), null);
            this.constants.setParentScope(this);
        }
        return this.constants;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String value) {
        this.login = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    void idle() {
        if (this.metadataLibrary != null) {
            this.metadataLibrary.idle();
        }
    }

    private void getSettingContent(ByteArrayOutputStream stream) throws Throwable {
        TaggedWriter out = new TaggedWriter(stream);
        out.putInt32(38, this.userRole.toInt());
        byte[] sha256Salt = null;
        byte[] sha256Hash = null;
        if (!Strings.isVoid(this.login) || !Strings.isVoid(this.password)) {
            if (Strings.isVoid(this.login)) {
                throw new InformException("\u0414\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0430\u0440\u043e\u043b\u044f \u043b\u043e\u0433\u0438\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043f\u0443\u0441\u0442\u044b\u043c");
            }
            sha256Salt = Security.sha256GenerateSalt();
            sha256Hash = Security.sha256CalculateH1(this.login, this.password, sha256Salt);
        }
        out.putRaw(115, sha256Hash);
        out.putRaw(116, sha256Salt);
        if (this.usersTable.field(13) == null) {
            out.putBool(82, this.activeDirectory);
        }
        if (this.rolesTable != null && this.rolesTable.enabled()) {
            out.putBool(113, true);
        } else if (this.roles.getCount() > 0) {
            out.putRaw(34, LittleEndian.doubleArrayToBinary(this.roles.getList()));
        } else {
            out.putEmpty(34);
        }
        if (this.inheritedStartup) {
            out.putBool(35, this.inheritedStartup);
        }
        out.putEmpty(42);
        if (this.constants != null && this.constants.isModified()) {
            byte[] constantsContent = this.constants.storeActualConstants();
            out.putRaw(37, constantsContent);
        } else {
            out.putEmpty(37);
        }
        out.putBool(89, this.userInterface.inheritedSavePerRecord);
        if (!this.userInterface.inheritedSavePerRecord) {
            out.putBool(88, this.userInterface.savePerRecord);
        }
        out.putBool(91, this.userInterface.inheritedCanSetupUser);
        if (!this.userInterface.inheritedCanSetupUser) {
            out.putBool(90, this.userInterface.canSetupUser);
        }
        out.putBool(94, this.userInterface.inheritedCanCreateNodes);
        if (!this.userInterface.inheritedCanCreateNodes) {
            if (this.userInterface.canCreateAnyNodes) {
                out.putEmpty(92);
            } else {
                out.putIntArray(93, this.userInterface.canCreateNodeTypes);
            }
        }
        out.putBool(96, this.userInterface.inheritedSimplePopup);
        if (!this.userInterface.inheritedSimplePopup) {
            out.putBool(95, this.userInterface.simplePopup);
        }
        out.putBool(98, this.userInterface.inheritedCanWritePublicFilters);
        if (!this.userInterface.inheritedCanWritePublicFilters) {
            out.putBool(97, this.userInterface.canWritePublicFilters);
        }
        out.putBool(107, this.userInterface.inheritedCanWritePex);
        if (!this.userInterface.inheritedCanWritePex) {
            out.putBool(106, this.userInterface.canWritePex);
        }
        out.putBool(112, this.userInterface.inheritedEditNode);
        if (!this.userInterface.inheritedEditNode) {
            out.putBool(111, this.userInterface.editNode);
        }
        out.putBool(109, this.userInterface.inheritedCanUploadPex);
        if (!this.userInterface.inheritedCanUploadPex) {
            out.putBool(108, this.userInterface.canUploadPex);
        }
        out.putBool(103, this.userInterface.inheritedCanViewDataHistory);
        if (!this.userInterface.inheritedCanViewDataHistory) {
            out.putBool(102, this.userInterface.canViewDataHistory);
        }
        out.putBool(105, this.userInterface.inheritedCanViewMetadataHistory);
        if (!this.userInterface.inheritedCanViewMetadataHistory) {
            out.putBool(104, this.userInterface.canViewMetadataHistory);
        }
        out.putEmpty(45);
        out.putBool(80, this.singleLogin);
        out.putInt32(110, this.possibleLoginCount);
        out.putBool(81, this.changePasswordOnLogin);
        out.putBool(51, true);
        out.putBool(52, this.locked);
        if (!this.inheritedStartup && this.usersTable.field(14) == null) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter subStream = new TaggedWriter(data);
            subStream.putEmpty(1);
            subStream.putDouble(151, this.rootNode);
            subStream.putEmpty(2);
            subStream.putDouble(151, this.startNode);
            subStream.putInt32(3, this.startAction);
            subStream.putEmpty(4);
            subStream.putDouble(151, this.startScript);
            subStream.putEmpty(12);
            subStream.putDouble(151, this.webStartNode);
            subStream.flush();
            out.putRaw(83, data.internalBuffer(), data.size());
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Throwable {
        SqlStringBuilder rolesSql;
        FieldDescriptor fdEMail;
        FieldDescriptor fdPhone;
        FieldDescriptor fdFIO;
        FieldDescriptor fdStartWebNode;
        FieldDescriptor fdStartScript;
        FieldDescriptor fdStartAction;
        FieldDescriptor fdStartNode;
        FieldDescriptor fdRootNode;
        FieldDescriptor fdInheritedStartup;
        FieldDescriptor fdGroup;
        if (this.usersTable.table() == null) {
            throw new InformException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        }
        if (!this.usersTable.enabled()) {
            return;
        }
        FieldDescriptor recordId = this.usersTable.pkfield();
        FieldDescriptor fdId = this.usersTable.field(0);
        FieldDescriptor fdLocked = this.usersTable.field(4);
        FieldDescriptor fdSettings = this.usersTable.field(3);
        if (fdId == null) {
            throw new InformException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        }
        if (fdLocked == null) {
            throw new InformException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        }
        if (fdSettings == null) {
            throw new InformException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        }
        boolean useRecordId = recordId != null && recordId != fdId;
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        this.getSettingContent(content);
        StringBuilder values = new StringBuilder();
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("insert into ");
        sql.appendFull(this.usersTable.table());
        sql.append(" (");
        if (useRecordId) {
            sql.append(recordId).append(", ");
            values.append("?,");
        }
        sql.append(fdId).append(", ");
        values.append("?");
        FieldDescriptor fdLogin = this.usersTable.field(1);
        if (fdLogin != null) {
            sql.append(fdLogin).append(", ");
            values.append(",?");
        }
        if ((fdGroup = this.usersTable.field(2)) != null) {
            sql.append(fdGroup).append(", ");
            values.append(",?");
        }
        sql.append(fdLocked).append(", ");
        values.append(",?");
        FieldDescriptor fdActiveDirectory = this.usersTable.field(13);
        if (fdActiveDirectory != null) {
            sql.append(fdActiveDirectory).append(", ");
            values.append(",?");
        }
        if ((fdInheritedStartup = this.usersTable.field(14)) != null) {
            sql.append(fdInheritedStartup).append(", ");
            values.append(",?");
        }
        if ((fdRootNode = this.usersTable.field(15)) != null) {
            sql.append(fdRootNode).append(", ");
            values.append(",?");
        }
        if ((fdStartNode = this.usersTable.field(16)) != null) {
            sql.append(fdStartNode).append(", ");
            values.append(",?");
        }
        if ((fdStartAction = this.usersTable.field(17)) != null) {
            sql.append(fdStartAction).append(", ");
            values.append(",?");
        }
        if ((fdStartScript = this.usersTable.field(18)) != null) {
            sql.append(fdStartScript).append(", ");
            values.append(",?");
        }
        if ((fdStartWebNode = this.usersTable.field(19)) != null) {
            sql.append(fdStartWebNode).append(", ");
            values.append(",?");
        }
        if ((fdFIO = this.usersTable.field(5)) != null) {
            sql.append(fdFIO).append(", ");
            values.append(",?");
        }
        if ((fdPhone = this.usersTable.field(8)) != null) {
            sql.append(fdPhone).append(", ");
            values.append(",?");
        }
        if ((fdEMail = this.usersTable.field(9)) != null) {
            sql.append(fdEMail).append(", ");
            values.append(",?");
        }
        sql.append(fdSettings);
        values.append(",?");
        sql.append(") values (" + values + ")");
        double[] rolePrimaryKeys = null;
        if (!this.roles.isEmpty() && this.rolesTable != null && this.rolesTable.enabled()) {
            rolesSql = new SqlStringBuilder();
            rolesSql.append("insert into ").appendFull(this.rolesTable.table()).append('(');
            if (this.rolesTable.primaryKey() != null) {
                rolesSql.append(this.rolesTable.primaryKey()).append(", ");
                rolePrimaryKeys = new double[this.roles.getCount()];
                for (int i = 0; i < rolePrimaryKeys.length; ++i) {
                    rolePrimaryKeys[i] = Core.generateId();
                }
            }
            rolesSql.append(this.rolesTable.field(0)).append(", ").append(this.rolesTable.field(1)).append(") values (");
            if (rolePrimaryKeys != null) {
                rolesSql.append("?,");
            }
            rolesSql.append("?,?)");
        } else {
            rolesSql = null;
        }
        try (DatabaseConnection connection = this.usersTable.table().getDatabaseDescriptor().connect(this.ssHost, "UsersTable.insertUser");){
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.insertUser", sql.toString());){
                int i = 0;
                if (useRecordId) {
                    statement.setDouble(++i, Core.generateId());
                }
                statement.setDouble(++i, this.id);
                if (fdLogin != null) {
                    if (Strings.isVoid(this.login)) {
                        statement.setString(++i, "");
                    } else {
                        statement.setString(++i, this.login);
                    }
                }
                if (fdGroup != null) {
                    statement.setDouble(++i, this.stdGroup);
                }
                statement.setBoolean(++i, this.locked);
                if (fdActiveDirectory != null) {
                    statement.setBoolean(++i, this.activeDirectory);
                }
                if (fdInheritedStartup != null) {
                    statement.setBoolean(++i, this.inheritedStartup);
                }
                if (fdRootNode != null) {
                    if (this.inheritedStartup) {
                        statement.setNull(++i, SqlDataType.DOUBLE);
                    } else {
                        statement.setDouble(++i, this.rootNode);
                    }
                }
                if (fdStartNode != null) {
                    if (this.inheritedStartup) {
                        statement.setNull(++i, SqlDataType.DOUBLE);
                    } else {
                        statement.setDouble(++i, this.startNode);
                    }
                }
                if (fdStartAction != null) {
                    if (this.inheritedStartup) {
                        statement.setNull(++i, SqlDataType.INTEGER);
                    } else {
                        statement.setInt(++i, this.startAction);
                    }
                }
                if (fdStartScript != null) {
                    if (this.inheritedStartup) {
                        statement.setNull(++i, SqlDataType.DOUBLE);
                    } else {
                        statement.setDouble(++i, this.startScript);
                    }
                }
                if (fdStartWebNode != null) {
                    if (this.inheritedStartup) {
                        statement.setNull(++i, SqlDataType.DOUBLE);
                    } else {
                        statement.setDouble(++i, this.webStartNode);
                    }
                }
                if (fdFIO != null) {
                    statement.setString(++i, this.fio == null ? "" : this.fio);
                }
                if (fdPhone != null) {
                    statement.setString(++i, this.phone == null ? "" : this.phone);
                }
                if (fdEMail != null) {
                    statement.setString(++i, this.email == null ? "" : this.email);
                }
                statement.setBlob(++i, content.internalBuffer(), content.size());
                statement.executeUpdate(this.ssContext);
            }
            if (rolesSql != null) {
                statement = connection.prepareStatement("RolesTable.insertRoles", rolesSql.toString());
                try {
                    boolean needBatch = false;
                    int roleIndex = 0;
                    for (Double role : this.roles.arrayList()) {
                        if (needBatch) {
                            statement.addBatch();
                        } else {
                            needBatch = true;
                        }
                        int index = 0;
                        if (rolePrimaryKeys != null) {
                            statement.setDouble(++index, rolePrimaryKeys[roleIndex]);
                        }
                        statement.setDouble(++index, this.id);
                        statement.setDouble(++index, role);
                        ++roleIndex;
                    }
                    statement.executeUpdate(this.ssContext);
                }
                finally {
                    statement.close();
                }
            }
            connection.commit();
        }
    }
}

