/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.agent.db.types.ValueCaster;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptUserRoles
extends ScriptableObject {
    private static final String[] jsMethods = new String[]{"clear", "add", "contains", "remove"};
    private static final String[] jsProperties = new String[]{"count"};
    private final ArrayList<Double> roles = new ArrayList();

    public ScriptUserRoles() {
        this.defineFunctionProperties(jsMethods, this.getClass(), 0);
        for (String propertyName : jsProperties) {
            this.defineProperty(propertyName, this.getClass(), 1);
        }
    }

    @Override
    public String getClassName() {
        return "ScriptUserRoles";
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (index < this.roles.size()) {
            return this.roles.get(index);
        }
        return super.get(index, start);
    }

    public int getCount() {
        return this.roles.size();
    }

    public double[] getList() {
        double[] list = new double[this.roles.size()];
        for (int i = 0; i < this.roles.size(); ++i) {
            list[i] = this.roles.get(i);
        }
        return list;
    }

    public ArrayList<Double> arrayList() {
        return this.roles;
    }

    public static void clear(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ScriptUserRoles self = (ScriptUserRoles)thisObj;
        self.roles.clear();
    }

    public static void add(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ScriptUserRoles self = (ScriptUserRoles)thisObj;
        for (int i = 0; i < args.length; ++i) {
            double nodeId = ValueCaster.toDouble(args[i]);
            self.roles.add(nodeId);
        }
    }

    public static void remove(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ScriptUserRoles self = (ScriptUserRoles)thisObj;
        for (int i = 0; i < args.length; ++i) {
            double nodeId = ValueCaster.toDouble(args[i]);
            self.roles.remove(nodeId);
        }
    }

    public static boolean contains(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 0) {
            return false;
        }
        double nodeId = ValueCaster.toDouble(args[0]);
        ScriptUserRoles self = (ScriptUserRoles)thisObj;
        return self.roles.contains(nodeId);
    }
}

