/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.server;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.agent.AgentJARVersion;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.types.ValueCaster;
import inform.agent.net.Client;
import inform.agent.net.ClientSession;
import inform.agent.scripts.Task;
import inform.agent.scripts.server.ServerConnection;
import inform.agent.scripts.server.SessionLib;
import java.io.IOException;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ServerLib
extends ScriptableObject {
    private static final String[] jsMethods = new String[]{"getConnectedUserIDs", "compareServerVersion", "isUserConnected", "connectToServer"};
    private static final String[] jsProps = new String[]{"serverVersion", "agentID", "serverID", "agentName", "agentInstanceID"};
    private final Task task;

    public ServerLib(Task task, Scriptable scope) {
        this.task = task;
        this.setParentScope(scope);
        this.defineFunctionProperties(jsMethods, ServerLib.class, 0);
        for (String propertyName : jsProps) {
            this.defineProperty(propertyName, ServerLib.class, 1);
        }
    }

    @Override
    public String getClassName() {
        return "ServerLib";
    }

    public static Object getConnectedUserIDs(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        DoubleSet users = new DoubleSet();
        for (Client client : ClientSession.getClients()) {
            users.add(client.getUserId());
        }
        return Context.javaToJS(users.toArray(), thisObj);
    }

    public static Object isUserConnected(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (args.length == 0) {
            return Context.javaToJS(false, thisObj);
        }
        Collection<Client> users = ClientSession.getClients();
        for (Object arg : args) {
            if (arg == null) continue;
            double userId = ValueCaster.toNumber(arg).doubleValue();
            for (Client user : users) {
                if (user.getUserId() != userId) continue;
                return Context.javaToJS(true, thisObj);
            }
        }
        return Context.javaToJS(false, thisObj);
    }

    public Object getServerVersion() {
        StringBuilder v = new StringBuilder();
        v.append(AgentJARVersion.MAJOR).append('.').append(AgentJARVersion.MINOR).append('.').append(AgentJARVersion.RELEASE).append(AgentJARVersion.CHANNEL).append(AgentJARVersion.UPDATE);
        return v.toString();
    }

    public Object getAgentInstanceID() {
        return Core.getApplicationId();
    }

    public Object getAgentID() {
        return Ini.AgentID;
    }

    public String getAgentName() {
        return Ini.AgentName;
    }

    public Object getServerID() {
        return Ini.ServerID;
    }

    public static Object compareServerVersion(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException {
        long v1 = SessionLib.parseStringVersion(ValueCaster.toString(args[0]));
        long v2 = args.length > 1 ? SessionLib.parseStringVersion(ValueCaster.toString(args[1])) : SessionLib.versionToNumber(AgentJARVersion.MAJOR, AgentJARVersion.MINOR, AgentJARVersion.RELEASE);
        return v1 - v2;
    }

    public static Object connectToServer(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException {
        ServerLib self = (ServerLib)thisObj;
        String serverName = args.length > 0 ? ValueCaster.toString(args[0]) : "";
        String agentName = args.length > 1 ? ValueCaster.toString(args[1]) : "";
        double userId = args.length > 2 ? ValueCaster.toDouble(args[2]) : 0.0;
        String userName = args.length > 2 ? ValueCaster.toString(args[2]) : "";
        String password = args.length > 3 ? ValueCaster.toString(args[3]) : "";
        Object name = serverName;
        if (agentName != null && !agentName.isEmpty()) {
            name = (String)name + "/" + agentName;
        }
        ServerConnection server = new ServerConnection(self.task, self.getParentScope(), (String)name);
        server.connect(serverName, agentName, userId, userName, password);
        self.task.registerCloseable(server);
        return server;
    }
}

