/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.common.SmartScriptableObject;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Scriptable;

public class SoapMimeHeaders
extends SmartScriptableObject {
    private final SOAPMessage message;
    private final AttachmentPart attachmentPart;
    private final SOAPPart soapPart;

    public SoapMimeHeaders(Scriptable scope, SOAPMessage message) {
        this.setParentScope(scope);
        this.message = message;
        this.attachmentPart = null;
        this.soapPart = null;
    }

    public SoapMimeHeaders(Scriptable scope, AttachmentPart attachmentPart) {
        this.setParentScope(scope);
        this.message = null;
        this.attachmentPart = attachmentPart;
        this.soapPart = null;
    }

    public SoapMimeHeaders(Scriptable scope, SOAPPart soapPart) {
        this.setParentScope(scope);
        this.message = null;
        this.attachmentPart = null;
        this.soapPart = soapPart;
    }

    @Override
    public Object[] getIds() {
        return this.values().keySet().toArray();
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (this.values().containsKey(name)) {
            return true;
        }
        return super.has(name, start);
    }

    @Override
    public Object get(String name, Scriptable start) {
        String[] data = null;
        if (this.message != null) {
            data = this.message.getMimeHeaders().getHeader(name);
        } else if (this.attachmentPart != null) {
            data = this.attachmentPart.getMimeHeader(name);
        } else if (this.soapPart != null) {
            data = this.soapPart.getMimeHeader(name);
        }
        return data == null || data.length == 0 ? null : data[0];
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        String s;
        String string = s = value == null ? "" : value.toString();
        if (this.message != null) {
            this.message.getMimeHeaders().setHeader(name, s);
        } else if (this.attachmentPart != null) {
            this.attachmentPart.setMimeHeader(name, s);
        } else if (this.soapPart != null) {
            this.soapPart.setMimeHeader(name, s);
        }
    }

    public Map<String, String> values() {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator iterator = null;
        if (this.message != null) {
            iterator = this.message.getMimeHeaders().getAllHeaders();
        } else if (this.attachmentPart != null) {
            iterator = this.attachmentPart.getAllMimeHeaders();
        } else if (this.soapPart != null) {
            iterator = this.soapPart.getAllMimeHeaders();
        } else {
            return result;
        }
        while (iterator.hasNext()) {
            MimeHeader h = (MimeHeader)iterator.next();
            result.put(h.getName(), h.getValue());
        }
        return result;
    }
}

