/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.collections.ArrayMap;
import inform.agent.scripts.sql.DataQueryNode;
import inform.agent.scripts.sql.DirectoryQueryNode;
import inform.agent.scripts.sql.FolderQueryNode;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QuerySubjectsNode;
import inform.agent.scripts.sql.RootQueryNode;
import inform.agent.scripts.sql.UnionQueryNode;

public enum QueryNodeKind {
    ERROR(0){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return null;
        }
    }
    ,
    ROOT(1){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return null;
        }
    }
    ,
    UNION_ROOT(2){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            if (!(parentNode instanceof RootQueryNode)) {
                throw new IllegalStateException();
            }
            return new UnionQueryNode(query, (RootQueryNode)parentNode);
        }
    }
    ,
    FOLDER(3){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return new FolderQueryNode(query, parentNode, false);
        }
    }
    ,
    SUBJECT_FOLDER(4){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return new QuerySubjectsNode(query, parentNode);
        }
    }
    ,
    TABLE(5){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return new QueryNode(query, parentNode);
        }
    }
    ,
    QUERY(6){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return new DataQueryNode(query, parentNode);
        }
    }
    ,
    SEARCH(7){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return new DataQueryNode(query, parentNode);
        }
    }
    ,
    DIRECTORY(8){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return new DirectoryQueryNode(query, parentNode);
        }
    }
    ,
    SUBJECT_SOURCE(9){

        @Override
        public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
            return new DataQueryNode(query, parentNode);
        }
    };

    private final int typeId;
    static final ArrayMap<QueryNodeKind> kindMap;

    private QueryNodeKind(int value) {
        this.typeId = value;
    }

    public int toInt() {
        return this.typeId;
    }

    public static QueryNodeKind fromInt(int typeId) {
        return kindMap.get(typeId);
    }

    public GenericQueryNode create(Query query, GenericQueryNode parentNode) {
        return null;
    }

    static {
        kindMap = new ArrayMap<QueryNodeKind>(QueryNodeKind.values());
    }
}

