/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.taggedio.TaggedReader;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.sql.QueryTokenizer;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import java.io.IOException;
import java.util.ArrayList;

public class QueryOptimizerHint {
    private final ArrayList<OptimizerHint> hints = new ArrayList();

    public void load(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 36: {
                OptimizerHint hint = this.getOptimizer(DatabaseType.ORACLE);
                if (hint == null) {
                    hint = new OracleOptimizerHint();
                    this.hints.add(hint);
                }
                OracleOptimizerHint oracleHint = (OracleOptimizerHint)hint;
                oracleHint.hints.add(in.getString());
            }
        }
    }

    public OptimizerHint getOptimizer(DatabaseType databaseType) {
        for (OptimizerHint hint : this.hints) {
            if (hint.databaseType != databaseType) continue;
            return hint;
        }
        return null;
    }

    public static class OracleOptimizerHint
    extends OptimizerHint {
        final ArrayList<String> hints = new ArrayList();

        public OracleOptimizerHint() {
            super(DatabaseType.ORACLE);
        }

        @Override
        public void generateAfterSelectKeyword(Query query, DatasourceUsage datasourceUsage, StringBuilder sql) {
            if (this.hints == null || this.hints.isEmpty()) {
                return;
            }
            StringBuilder hint = null;
            for (String h : this.hints) {
                if (h.isEmpty()) continue;
                StringBuilder hintSql = new StringBuilder();
                QueryTokenizer parser = new QueryTokenizer(h);
                QueryTokenizer.Token tokenType = null;
                block7: while (hintSql != null && tokenType != QueryTokenizer.Token.Eof) {
                    QueryTokenizer.Token prevToken = tokenType;
                    tokenType = parser.nextToken();
                    if (tokenType == null) continue;
                    switch (tokenType) {
                        case Word: {
                            if (prevToken != null) {
                                hintSql.append(' ');
                            }
                            if (parser.value.charAt(0) == '#') {
                                QueryNode queryNode;
                                String name = parser.value.substring(1);
                                GenericQueryNode node = query.findNodeByName(name);
                                if (node == null) {
                                    query.throwError("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a '" + name + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                                }
                                if (datasourceUsage != null && node instanceof QueryNode && (queryNode = (QueryNode)node).canExclude(datasourceUsage)) {
                                    hintSql = null;
                                    break;
                                }
                                node.internalGenerateAlias(hintSql);
                                break;
                            }
                            hintSql.append(parser.value);
                            break;
                        }
                        case Line: {
                            int index;
                            if (prevToken == tokenType || (index = hintSql.length() - 1) < 0 || hintSql.charAt(index) == '\n') continue block7;
                            hintSql.append("\n");
                            break;
                        }
                        case Number: {
                            hintSql.append(' ').append(parser.value);
                            break;
                        }
                        case Eof: {
                            break;
                        }
                        default: {
                            hintSql.append(parser.value);
                        }
                    }
                }
                if (hintSql == null || hintSql.length() == 0) continue;
                if (hint == null) {
                    hint = hintSql;
                    continue;
                }
                hint.append(' ').append((CharSequence)hintSql);
            }
            if (hint != null) {
                sql.append("/*+ ").append((CharSequence)hint).append(" */");
            }
        }
    }

    public static abstract class OptimizerHint {
        final DatabaseType databaseType;

        public OptimizerHint(DatabaseType databaseType) {
            this.databaseType = databaseType;
        }

        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        public abstract void generateAfterSelectKeyword(Query var1, DatasourceUsage var2, StringBuilder var3);
    }
}

