/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.agent.db.types.SqlDataType;

public class QueryParameter {
    private SqlDataType type = SqlDataType.UNSUPPORTED;
    private boolean isNull = false;
    private double numberValue;
    private boolean booleanValue;
    private String stringValue;

    public QueryParameter(SqlDataType type) {
        this.isNull = true;
        this.type = type;
    }

    public QueryParameter(double value, SqlDataType type) {
        assert (type == SqlDataType.INTEGER || type == SqlDataType.DOUBLE || type == SqlDataType.DATE_TIME);
        this.numberValue = value;
        this.type = type;
    }

    public QueryParameter(String value, SqlDataType type) {
        assert (type == SqlDataType.STRING || type == SqlDataType.UNICODE);
        this.stringValue = value;
        this.type = type;
    }

    public QueryParameter(boolean value) {
        this.booleanValue = value;
        this.type = SqlDataType.BOOLEAN;
    }

    public boolean getIsNull() {
        return this.isNull;
    }

    public double getNumberValue() {
        return this.numberValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public SqlDataType getType() {
        return this.type;
    }

    public int getSqlTypeID() {
        if (this.type == null) {
            return SqlDataType.UNSUPPORTED.toInteger();
        }
        return this.type.toInteger();
    }

    public void setNull(SqlDataType type) {
        this.type = type;
        this.isNull = true;
    }

    public void getLog(StringBuilder log) {
        if (this.isNull) {
            log.append("null");
        } else {
            switch (this.type) {
                case BOOLEAN: {
                    log.append(this.booleanValue);
                    break;
                }
                case INTEGER: 
                case DOUBLE: {
                    log.append(NumberConverter.doubleToString(this.numberValue));
                    break;
                }
                case TIMESTAMP: 
                case DATE_TIME: {
                    log.append(DateTime.toLogString(this.numberValue));
                    break;
                }
                case STRING: 
                case UNICODE: {
                    log.append(this.stringValue);
                    break;
                }
                case BLOB: 
                case GEOMETRY: {
                    log.append("<blob>");
                    break;
                }
                default: {
                    log.append("<???>");
                }
            }
        }
    }
}

