/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr;

import inform.agent.db.connect.DatabaseCaps;
import inform.agent.expr.ConstantTerm;
import inform.agent.expr.Expression;
import inform.agent.expr.OperationTerm;
import inform.agent.expr.ParameterTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constants;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryField;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.expr.QueryFieldTerm;
import inform.agent.scripts.sql.expr.QueryInlineTerm;
import inform.agent.scripts.sql.expr.cnd.BinaryOperation;
import inform.agent.scripts.sql.expr.cnd.BraceEvaluator;
import inform.agent.scripts.sql.expr.cnd.CompareOperation;
import inform.agent.scripts.sql.expr.cnd.InlineEvaluator;
import inform.agent.scripts.sql.expr.cnd.LogicalOperation;
import inform.agent.scripts.sql.expr.cnd.NopEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryFieldEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryIgnoredEvaluator;
import inform.agent.scripts.sql.expr.cnd.QuerySubjectEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;
import inform.agent.scripts.sql.expr.cnd.UnaryOperation;
import inform.agent.scripts.sql.expr.fn.SQLAbsEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLAddDaysEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLAddMonthsEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLAddSeparators;
import inform.agent.scripts.sql.expr.fn.SQLAggregativeFunction;
import inform.agent.scripts.sql.expr.fn.SQLBlobSizeEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLCaseEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLDateExtractEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLDateValueEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLDaysBetweenEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLExists;
import inform.agent.scripts.sql.expr.fn.SQLMonthEndDateEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLMonthsBetweenEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLNVLEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLNumberToStringEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLPriorEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLRegexpSubstrEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLRoundToEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLToDateEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLToNumberEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLTruncDateEvaluator;
import inform.agent.scripts.sql.expr.fn.SQLTruncEvaluator;
import java.util.Collection;

public class Condition
extends Expression<QueryEvaluator> {
    private final Query query;
    private static final QueryEvaluator ignoredEvaluator = new QueryIgnoredEvaluator();
    private final boolean rootExpr;

    public Condition(Query query, boolean rootExpr) {
        super(query);
        this.query = query;
        this.rootExpr = rootExpr;
    }

    public void addTableParam(int entryId, int fieldId, int paramId) {
        if (!this.expr.isEmpty()) {
            this.expr.add(new OperationTerm(this.expr.size() + 1, 10, this));
        }
        this.expr.add(new QueryFieldTerm(this.expr.size() + 1, entryId, fieldId, this.query, this));
        this.expr.add(new OperationTerm(this.expr.size() + 1, 9, this));
        this.expr.add(new ParameterTerm(this.expr.size() + 1, paramId, this));
    }

    public Collection<Term> terms() {
        return this.expr;
    }

    @Override
    public QueryEvaluator compile() {
        return (QueryEvaluator)super.compile();
    }

    @Override
    public Constants getConstants() {
        return this.query.getConstants();
    }

    @Override
    public ParametersList getParameters() {
        return this.query.getInputParameters();
    }

    @Override
    public QueryEvaluator createIgnored() {
        return ignoredEvaluator;
    }

    @Override
    public QueryEvaluator createNOP(QueryEvaluator left, QueryEvaluator right) {
        return new NopEvaluator(nopOperation, left, right);
    }

    @Override
    public QueryEvaluator createEvaluator(Term term) {
        switch (term.getToken()) {
            case inline: {
                return new InlineEvaluator((QueryInlineTerm)term);
            }
            case field: {
                QueryFieldTerm fieldTerm = (QueryFieldTerm)term;
                QueryNode entry = fieldTerm.getNode();
                if (entry.isSubject()) {
                    return new QuerySubjectEvaluator(term, entry, fieldTerm.getFieldId());
                }
                return new QueryFieldEvaluator(fieldTerm, this.rootExpr);
            }
            case globalConst: {
                return new QueryValueEvaluator((ConstantTerm)term);
            }
            case param: {
                ParameterTerm paramTerm = (ParameterTerm)term;
                Parameter p = paramTerm.getParameter();
                QueryNode entry = p.getBindedToQueryNode();
                if (entry == null) {
                    return new QueryValueEvaluator(paramTerm);
                }
                if (entry.isSubject()) {
                    return new QuerySubjectEvaluator(term, entry, p.getFieldBinding());
                }
                return new QueryFieldEvaluator(term, entry, p.getFieldBinding(), this.rootExpr);
            }
            case value: {
                return new QueryValueEvaluator((ValueTerm)term);
            }
            case functionRoundTo: {
                return new SQLRoundToEvaluator(this.query, term);
            }
            case functionTrunc: {
                return new SQLTruncEvaluator(term);
            }
            case functionToNumber: {
                return new SQLToNumberEvaluator(term);
            }
            case functionNumberToString: {
                return new SQLNumberToStringEvaluator(term);
            }
            case functionAbs: {
                return new SQLAbsEvaluator(term);
            }
            case functionDayOf: 
            case functionMonthOf: 
            case functionQuarterOf: 
            case functionYearOf: 
            case functionHourOf: 
            case functionMinuteOf: 
            case functionSecondOf: 
            case functionDateOf: {
                return new SQLDateExtractEvaluator(term);
            }
            case functionTruncDateYear: {
                return new SQLTruncDateEvaluator(DatabaseCaps.TruncDateType.year, term);
            }
            case functionTruncDateMonth: {
                return new SQLTruncDateEvaluator(DatabaseCaps.TruncDateType.month, term);
            }
            case functionTruncDateQuarter: {
                return new SQLTruncDateEvaluator(DatabaseCaps.TruncDateType.quarter, term);
            }
            case functionTruncDateHour: {
                return new SQLTruncDateEvaluator(DatabaseCaps.TruncDateType.hour, term);
            }
            case functionTruncDateWeek: {
                return new SQLTruncDateEvaluator(DatabaseCaps.TruncDateType.week, term);
            }
            case functionDaysBetween: {
                return new SQLDaysBetweenEvaluator(term);
            }
            case functionMonthsBetween: {
                return new SQLMonthsBetweenEvaluator(term);
            }
            case functionAddMonths: {
                return new SQLAddMonthsEvaluator(term);
            }
            case functionAddDays: {
                return new SQLAddDaysEvaluator(term);
            }
            case functionToDate: {
                return new SQLToDateEvaluator(term);
            }
            case functionNVL: {
                return new SQLNVLEvaluator(term);
            }
            case functionBlobSize: {
                return new SQLBlobSizeEvaluator(term);
            }
            case functionRegexpSubstr: {
                return new SQLRegexpSubstrEvaluator(term);
            }
            case functionAddSeparators: {
                return new SQLAddSeparators(term);
            }
            case functionCase: {
                return new SQLCaseEvaluator(term);
            }
            case functionExists: {
                return new SQLExists(term);
            }
            case functionPrior: {
                return new SQLPriorEvaluator(term);
            }
            case functionAgrSum: 
            case functionAgrAvg: 
            case functionAgrCount: 
            case functionAgrCountAll: 
            case functionAgrMin: 
            case functionAgrMax: {
                return new SQLAggregativeFunction(term);
            }
            case functionDateValue: {
                return new SQLDateValueEvaluator(term);
            }
            case functionMonthEndDate: {
                return new SQLMonthEndDateEvaluator(term);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public QueryEvaluator createEvaluator(Term term, QueryEvaluator arg) {
        switch (term.getToken()) {
            case not: 
            case add: 
            case sub: {
                return new UnaryOperation((OperationTerm)term, arg);
            }
            case openBrace: {
                return new BraceEvaluator(term, arg);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public QueryEvaluator createEvaluator(Term term, QueryEvaluator left, QueryEvaluator right) {
        switch (term.getToken()) {
            case or: 
            case and: {
                return new LogicalOperation((OperationTerm)term, left, right);
            }
            case equal: 
            case notEqual: 
            case less: 
            case lessEqual: 
            case greater: 
            case greaterEqual: 
            case like: 
            case notLike: 
            case startWith: 
            case notStartWith: {
                return new CompareOperation((OperationTerm)term, left, right);
            }
            case add: 
            case sub: 
            case mul: 
            case div: 
            case mod: {
                return new BinaryOperation((OperationTerm)term, left, right);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected Term createTerm(int id) {
        switch (id) {
            case 1: {
                return new QueryFieldTerm(this.query, this);
            }
            case 9: {
                return new QueryInlineTerm(this);
            }
        }
        return super.createTerm(id);
    }

    @Override
    protected Term createObjectArg(Term term, Object arg) throws Exception {
        if (arg instanceof QueryField) {
            QueryField field = (QueryField)arg;
            QueryFieldTerm fieldTerm = new QueryFieldTerm(this.query, this);
            fieldTerm.setField(field.getEntryId(), field.key());
            int index = this.expr.indexOf(term);
            this.expr.add(index, fieldTerm);
            return fieldTerm;
        }
        if (arg instanceof DatasourceField) {
            DatasourceField field = (DatasourceField)arg;
            return this.addValue(term, field.getDataType(), field.getAvailableValue());
        }
        return super.createObjectArg(term, arg);
    }
}

