/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr;

import inform.adt.InformException;
import inform.agent.db.FieldDescriptor;
import inform.agent.expr.Expression;
import inform.agent.expr.FieldTerm;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import java.io.IOException;

public class QueryFieldTerm
extends FieldTerm {
    private final Query query;
    private QueryNode node = null;
    private FieldDescriptor field = null;

    public QueryFieldTerm(Query query, Expression expr) {
        super(expr);
        this.query = query;
    }

    public QueryFieldTerm(int elementId, int datasourceId, int fieldId, Query query, Expression expr) {
        super(elementId, datasourceId, fieldId, expr);
        this.query = query;
    }

    @Override
    public void afterLoad() {
        this.node = null;
        GenericQueryNode genericQueryNode = this.query.findNodeById(this.datasourceId);
        if (genericQueryNode == null) {
            this.query.throwError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a[id: " + this.datasourceId + "] \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        } else if (genericQueryNode instanceof QueryNode) {
            if (this.fieldIdPath == null || this.fieldIdPath.length == 0) {
                throw new IllegalStateException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435");
            }
            this.node = (QueryNode)genericQueryNode;
        } else {
            genericQueryNode.throwNodeError("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        this.field = null;
        StringBuilder msg = new StringBuilder();
        for (int fieldId : this.fieldIdPath) {
            if (this.field == null) {
                msg.append(" \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a ");
                this.node.getDetailing(msg);
            } else {
                try {
                    this.node = this.node.createDirectory(this.field.getReferenceId(), this.field.getId());
                }
                catch (IOException e) {
                    throw InformException.wrap(e);
                }
                msg.append(", \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a ");
                this.node.getDetailing(msg);
            }
            this.field = this.node.getFieldById(fieldId);
            if (this.field == null) {
                msg.append(" \u043f\u043e\u043b\u0435 ???[").append(this.field).append(']');
                this.node.getQuery().throwDetailingError("\u041f\u043e\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", msg);
                continue;
            }
            msg.append(this.field.getCaption()).append("(id: ").append(fieldId).append(')');
        }
    }

    @Override
    public int[] getFieldIdPath() {
        return this.fieldIdPath;
    }

    public QueryNode getNode() {
        return this.node;
    }

    public FieldDescriptor getField() {
        return this.field;
    }

    public int getFieldId() {
        return this.fieldIdPath[0];
    }

    public void setField(int datasourceId, int fieldId) {
        this.datasourceId = datasourceId;
        this.fieldIdPath = new int[]{fieldId};
    }

    public void replaceDatasourceID(int id) {
        this.datasourceId = id;
    }
}

