/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.agent.expr.OperationTerm;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.BinaryOperation;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;

public class LogicalOperation
extends BinaryOperation {
    public LogicalOperation(OperationTerm term, QueryEvaluator left, QueryEvaluator right) {
        super(term, left, right);
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.left.isIgnored()) {
            if (this.right.isIgnored()) {
                return;
            }
            this.right.generate(sql, query);
        } else if (this.right.isIgnored()) {
            this.left.generate(sql, query);
        } else {
            this.left.generate(sql, query);
            switch (this.term.getToken()) {
                case and: {
                    sql.append(" AND ");
                    break;
                }
                case or: {
                    sql.append(" OR ");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.right.generate(sql, query);
        }
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.left.isIgnored() && this.right.isIgnored();
    }
}

