/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.types.DataType;
import inform.agent.expr.Term;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.expr.QueryFieldTerm;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QuerySubjectEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;

public class QueryFieldEvaluator
extends QueryEvaluator {
    protected final QueryNode node;
    protected final FieldDescriptor field;
    private final boolean rootExpr;

    public QueryFieldEvaluator(QueryFieldTerm term, boolean rootExpr) {
        super(term);
        this.node = term.getNode();
        assert (this.node != null);
        this.field = term.getField();
        assert (this.field != null);
        this.rootExpr = rootExpr;
    }

    public QueryFieldEvaluator(Term term, QueryNode node, int fieldId, boolean rootExpr) {
        super(term);
        this.node = node;
        assert (this.node != null);
        this.field = this.node.getFieldById(fieldId);
        this.rootExpr = rootExpr;
        if (this.field == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435").append("[id \u043f\u043e\u043b\u044f: ").append(fieldId).append(']');
            node.throwNodeError(msg.toString());
        }
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.field == null) {
            throw new IllegalStateException();
        }
        this.node.generateFieldAlias(sql, this.field.getId(), this.rootExpr);
    }

    @Override
    public void generateAsString(StringBuilder sql, Query query) throws Exception {
        block0 : switch (this.field.getType()) {
            case STRING: 
            case UNICODE: {
                break;
            }
            case DATE_TIME: {
                switch (query.getDatabaseType()) {
                    case ORACLE: 
                    case ORACLE_ODBC: {
                        break block0;
                    }
                }
                DatabaseCaps caps = query.getDatabaseCaps();
                StringBuilder field = new StringBuilder();
                super.generateAsString(field, query);
                caps.dateTimeToStringFunction(sql, field.toString());
                return;
            }
            default: {
                switch (query.getDatabaseType()) {
                    case ORACLE: 
                    case ORACLE_ODBC: {
                        break block0;
                    }
                }
                DatabaseCaps caps = query.getDatabaseCaps();
                sql.append("''").append(caps.concatOperator);
            }
        }
        super.generateAsString(sql, query);
    }

    @Override
    public QueryValueEvaluator getValue() {
        return null;
    }

    @Override
    public void getDatasourceUsage(DatasourceUsage usage) {
        if (this.isIgnored() || this.node == null || this.field == null) {
            return;
        }
        usage.add(this.node.getEntryId(), this.field.getId());
    }

    @Override
    public boolean isAggregative() {
        return false;
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.node.isIgnored();
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.field != null && QueryFieldEvaluator.isStringable(this.field.getType());
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public boolean isMultipleValue() {
        return false;
    }

    @Override
    public QuerySubjectEvaluator getSubject() {
        return null;
    }

    public DataType getDataType() {
        if (this.field == null) {
            return null;
        }
        return this.field.getType();
    }
}

