/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.expr.ConstantTerm;
import inform.agent.expr.ParameterTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ScriptableValue;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryNullEvaluator;
import inform.agent.scripts.sql.expr.cnd.QuerySubjectEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluatorArray;
import inform.agent.web.utils.TypedValue;
import java.util.ArrayList;
import java.util.Arrays;

public class QueryValueEvaluator
extends QueryEvaluator
implements QueryValueEvaluatorArray {
    private final DataType dataType;
    private ScriptableValue value;
    private boolean isLeftLike = false;
    private boolean isRightLike = false;
    private char escapeChar = '\u0000';

    QueryValueEvaluator(Term term, DataType dataType, TypedValue value) {
        super(term);
        this.dataType = dataType;
        this.value = value;
    }

    public QueryValueEvaluator(ValueTerm term) {
        super(term);
        this.dataType = term.getType();
        this.value = term;
    }

    public QueryValueEvaluator(ParameterTerm term) {
        super(term);
        Parameter p = term.getParameter();
        this.dataType = p.getDataType();
        this.value = p;
    }

    public QueryValueEvaluator(ConstantTerm term) {
        super(term);
        Constant c = term.getConstant();
        this.dataType = c.getDataType();
        this.value = c;
    }

    public QueryValueEvaluator getNull() {
        switch (this.dataType) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DIRECTORY: 
            case INTERVAL: 
            case METATREE_NODE: 
            case PRIMARY_KEY: 
            case BIG_NUMBER: {
                return QueryNullEvaluator.numberNull;
            }
            case DATE_TIME: {
                return QueryNullEvaluator.dateNull;
            }
            case STRING: 
            case UNICODE: {
                return QueryNullEvaluator.stringNull;
            }
        }
        return QueryNullEvaluator.Null;
    }

    public double getNumber() {
        if (this.value == null) {
            return 0.0;
        }
        return ValueCaster.toDouble(this.value.getRawValue());
    }

    public String getAsString() {
        if (this.isMultipleValue()) {
            return null;
        }
        return ValueCaster.toString(this.value.getRawValue());
    }

    public static void generateValue(DataType dataType, Object v, StringBuilder sql, Query query) {
        QueryValueEvaluator.generateValue(dataType, v, sql, query, false, false);
    }

    private static String likeString(String value, boolean leftLike, boolean rightLike, Query query, QueryValueEvaluator evaluator) {
        if (evaluator != null && (leftLike || rightLike)) {
            DatabaseCaps caps = query.getDatabaseCaps();
            evaluator.escapeChar = caps.getEscapeLikeChar(value);
            value = caps.toLikeString(value, evaluator.escapeChar);
        }
        Object result = value;
        if (leftLike) {
            result = "%" + (String)result;
        }
        if (rightLike) {
            result = (String)result + "%";
        }
        return result;
    }

    public static void generateValue(DataType dataType, Object v, StringBuilder sql, Query query, boolean leftLike, boolean rightLike) {
        QueryValueEvaluator.generateValue(dataType, v, sql, query, leftLike, rightLike, null);
    }

    public static void generateValue(DataType dataType, Object v, StringBuilder sql, Query query, boolean leftLike, boolean rightLike, QueryValueEvaluator evaluator) {
        if (v == null) {
            sql.append(" NULL ");
        } else if (dataType == DataType.BOOLEAN) {
            boolean value = ValueCaster.toBoolean(v);
            query.generateBoolValueSql(value, sql);
        } else if (dataType == DataType.INTERVAL) {
            double number = ValueCaster.toDouble(v);
            query.generateInterval(number, sql);
        } else if (dataType.isNumberPresentation()) {
            double number = ValueCaster.toDouble(v);
            query.generateDoubleValueSql(number, sql);
        } else {
            switch (dataType) {
                case DATE_TIME: {
                    query.generateDateValueSql(ValueCaster.toDouble(v), sql);
                    break;
                }
                case STRING: {
                    query.generateAnsiStringValueSql(QueryValueEvaluator.likeString(ValueCaster.toString(v), leftLike, rightLike, query, evaluator), sql);
                    break;
                }
                case UNICODE: {
                    query.generateUTFStringValueSql(QueryValueEvaluator.likeString(ValueCaster.toString(v), leftLike, rightLike, query, evaluator), sql);
                    break;
                }
                case BIG_NUMBER: {
                    query.generateAnsiStringValueSql(ValueCaster.toString(v), sql);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void generate(StringBuilder sql, Query query) {
        if (this.isIgnored()) {
            return;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            sql.append(" NULL ");
        } else if (raw instanceof Object[]) {
            Object[] array = (Object[])raw;
            if (array.length == 0 || array.length == 1) {
                sql.append(" NULL ");
                return;
            }
            int comma = 32;
            for (Object v : array) {
                sql.append((char)comma);
                QueryValueEvaluator.generateValue(this.dataType, v, sql, query);
                comma = 44;
            }
        } else {
            QueryValueEvaluator.generateValue(this.dataType, raw, sql, query, this.isLeftLike, this.isRightLike, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateLike(StringBuilder sql, Query query, boolean leftLike, boolean rightLike) {
        this.escapeChar = '\u0000';
        boolean prevLeft = this.isLeftLike;
        boolean prevRight = this.isRightLike;
        this.isLeftLike = leftLike;
        this.isRightLike = rightLike;
        try {
            this.generate(sql, query);
        }
        finally {
            this.isLeftLike = prevLeft;
            this.isRightLike = prevRight;
        }
        if (this.escapeChar == '\u0000') {
            return null;
        }
        return " ESCAPE '" + this.escapeChar + "'";
    }

    public boolean isSingleNull() {
        if (this.isIgnored()) {
            return false;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            return true;
        }
        if (raw instanceof Object[]) {
            Object[] array;
            for (Object v : array = (Object[])raw) {
                if (v == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void compactNullValues() throws Exception {
        if (this.isIgnored()) {
            return;
        }
        if (!this.hasNull()) {
            return;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            return;
        }
        if (raw instanceof Object[]) {
            if (this.isSingleNull()) {
                this.value = new TypedValue(this.dataType, null);
                return;
            }
            Object[] array = (Object[])raw;
            if (array.length == 0) {
                return;
            }
            if (array.length == 1) {
                return;
            }
            Object[] compact = new Object[array.length];
            int compactCount = 0;
            for (Object v : array) {
                if (v == null) continue;
                compact[compactCount++] = v;
            }
            if (compactCount == array.length) {
                return;
            }
            this.value = new TypedValue(this.dataType, Arrays.copyOf(compact, compactCount));
        }
    }

    @Override
    public void compactNonNullValues(boolean findMin, boolean ignoreCase, String tokenAsString) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        boolean onlyNulls = true;
        Object raw = this.value.getRawValue();
        if (raw != null) {
            if (raw instanceof Object[]) {
                Object[] array = (Object[])raw;
                if (array.length == 0) {
                    throw new IllegalStateException();
                }
                if (array.length == 1) {
                    onlyNulls = array[0] != null;
                } else {
                    raw = null;
                    for (Object v : array) {
                        if (v == null) continue;
                        if (raw == null) {
                            raw = v;
                            continue;
                        }
                        try {
                            switch (this.dataType) {
                                case BOOLEAN: 
                                case INTEGER: 
                                case FLOAT: 
                                case DIRECTORY: 
                                case INTERVAL: 
                                case METATREE_NODE: 
                                case PRIMARY_KEY: 
                                case DATE_TIME: {
                                    if (findMin) {
                                        if (!(ValueCaster.toDouble(raw) > ValueCaster.toDouble(v))) break;
                                        raw = v;
                                        break;
                                    }
                                    if (!(ValueCaster.toDouble(raw) < ValueCaster.toDouble(v))) break;
                                    raw = v;
                                    break;
                                }
                                case BIG_NUMBER: 
                                case STRING: 
                                case UNICODE: {
                                    int cmp = ignoreCase ? ValueCaster.toString(raw).compareToIgnoreCase(ValueCaster.toString(v)) : ValueCaster.toString(raw).compareTo(ValueCaster.toString(v));
                                    if (findMin) {
                                        if (cmp <= 0) break;
                                        raw = v;
                                        break;
                                    }
                                    if (cmp >= 0) break;
                                    raw = v;
                                    break;
                                }
                            }
                        }
                        catch (InformException e) {
                            Core.logger.error(null, e);
                        }
                    }
                    if (raw != null) {
                        this.value = new TypedValue(this.dataType, raw);
                        onlyNulls = false;
                    }
                }
            } else {
                onlyNulls = false;
            }
        }
        if (onlyNulls) {
            return;
        }
    }

    @Override
    public void generateExceptForNull(StringBuilder sql, Query query) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            return;
        }
        if (raw instanceof Object[]) {
            Object[] array = (Object[])raw;
            if (array.length == 0 || array.length == 1) {
                return;
            }
            int comma = 32;
            for (Object v : array) {
                if (v == null) continue;
                sql.append((char)comma);
                QueryValueEvaluator.generateValue(this.dataType, v, sql, query);
                comma = 44;
            }
        } else {
            QueryValueEvaluator.generateValue(this.dataType, raw, sql, query);
        }
    }

    @Override
    public QueryValueEvaluator getValue() {
        return this;
    }

    @Override
    public void getDatasourceUsage(DatasourceUsage usage) {
    }

    @Override
    public boolean isAggregative() {
        return false;
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.value.getIsIgnored();
    }

    @Override
    public boolean isStringType() throws Exception {
        return QueryValueEvaluator.isStringable(this.dataType);
    }

    @Override
    public boolean isMultipleValue() {
        if (this.value == null) {
            return false;
        }
        if (this.value.getIsIgnored()) {
            return false;
        }
        Object raw = this.value.getRawValue();
        return raw instanceof Object[] && ((Object[])raw).length > 1;
    }

    @Override
    public boolean hasNull() {
        if (this.value == null) {
            return false;
        }
        if (this.value.getIsIgnored()) {
            return false;
        }
        Object raw = this.value.getRawValue();
        if (raw == null) {
            return true;
        }
        if (raw instanceof Object[]) {
            for (Object r : (Object[])raw) {
                if (r != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getArraySize(boolean withNull) {
        int size = 0;
        if (this.value != null) {
            Object raw = this.value.getRawValue();
            if (raw == null) {
                if (withNull) {
                    ++size;
                }
            } else if (raw instanceof Object[]) {
                for (Object r : (Object[])raw) {
                    if (!withNull && r == null) continue;
                    ++size;
                }
            } else {
                ++size;
            }
        } else if (withNull) {
            ++size;
        }
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public QueryValueEvaluator arrayTopEvaluator(boolean withNull) {
        if (this.value != null) {
            Object raw = this.value.getRawValue();
            if (raw == null) {
                if (!withNull) return null;
                return this.getNull();
            }
            if (!(raw instanceof Object[])) return this;
            for (Object r : (Object[])raw) {
                if (r == null && withNull) {
                    return this.getNull();
                }
                if (r == null) continue;
                return new QueryValueEvaluator(this.term, this.dataType, new TypedValue(this.dataType, r));
            }
            return null;
        } else {
            if (!withNull) return null;
            return this.getNull();
        }
    }

    @Override
    public void getArray(ArrayList<QueryValueEvaluator> values, boolean withNull) {
        values.clear();
        if (this.value != null) {
            Object raw = this.value.getRawValue();
            if (raw == null) {
                if (withNull) {
                    values.add(this);
                }
            } else if (raw instanceof Object[]) {
                for (Object r : (Object[])raw) {
                    if (!withNull && r == null) continue;
                    values.add(new QueryValueEvaluator(this.term, this.dataType, new TypedValue(this.dataType, r)));
                }
            } else {
                values.add(this);
            }
        } else if (withNull) {
            values.add(new QueryValueEvaluator(this.term, this.dataType, new TypedValue(this.dataType, null)));
        }
    }

    @Override
    public QuerySubjectEvaluator getSubject() {
        return null;
    }
}

