/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.odt;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.textdocuments.odt.OdtFont;
import inform.agent.scripts.textdocuments.odt.OdtParagraph;
import inform.agent.scripts.textdocuments.odt.OdtStyle;
import inform.agent.scripts.textdocuments.odt.OdtTable;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.incubator.search.TextNavigation;
import org.odftoolkit.odfdom.incubator.search.TextSelection;
import org.odftoolkit.odfdom.type.Color;
import org.w3c.dom.NodeList;

public class OdtDocument
extends SmartScriptableObject {
    private static final String MESSAGE_MISSINGFILE = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b '%s'. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0438 \u043c\u0435\u0441\u0442\u043e\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.";
    private static final String MESSAGE_UNKNOWNFILE = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
    private static final String MESSAGE_BADPARAMETRS = "\u0412\u0432\u0435\u0434\u0435\u043d\u044b \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
    private static final String MESSAGE_EMPTYBINARY = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Odt-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430";
    private static final String MESSAGE_EMPTYFIELD = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Odt-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
    private static final String MESSAGE_BADFIELDTYPE_READ = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Odt-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_BADTYPE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c Odt-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442 \u0441 \u0442\u0438\u043f\u043e\u043c '%s'. \u041f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c, \u043f\u043e\u043b\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b (\u0441 \u0442\u0438\u043f\u043e\u043c Blob \u0438\u043b\u0438 BlobFile) \u0438\u043b\u0438 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u0444\u0430\u0439\u043b\u0430.";
    private static final String MESSAGE_BADFIELDTYPE_WRITE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c Word-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u043f\u043e\u043b\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_BADFONT = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0448\u0440\u0438\u0444\u0442\u0430";
    static final String MESSAGE_BADSTYLE = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u0438\u043b\u044f";
    static final String MESSAGE_TABLE_NOTFOUND = "\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u043e\u043c '%s' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
    private static final String MESSAGE_BADINDEX = "\u0412\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441 '%s'";
    private static final String MESSAGE_BADCOLOR = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0446\u0432\u0435\u0442\u0430: '%s'";
    OdfTextDocument textDocument;

    private OdtDocument(Scriptable scope) {
        this.setParentScope(scope);
    }

    @Override
    public String getClassName() {
        return "OdtDocument";
    }

    public static OdtDocument openOdtDocument(Scriptable scope, String fileName) throws Exception {
        OdtDocument odtDocument;
        OdtDocument odtDocument2 = new OdtDocument(scope);
        File file = Core.mountfs.resolve(new File(fileName));
        if (!file.exists()) {
            throw new InformException(String.format(MESSAGE_MISSINGFILE, fileName));
        }
        FileInputStream is = new FileInputStream(file);
        try {
            odtDocument2.textDocument = OdfTextDocument.loadDocument((InputStream)is);
            odtDocument = odtDocument2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new InformException(MESSAGE_UNKNOWNFILE);
            }
        }
        ((InputStream)is).close();
        return odtDocument;
    }

    public static OdtDocument openOdtDocument(Scriptable scope, BinaryObject binary) throws Exception {
        OdtDocument odtDocument;
        OdtDocument odtDocument2 = new OdtDocument(scope);
        if (binary.getSize() == 0) {
            throw new InformException(MESSAGE_EMPTYBINARY);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(binary.getInternalBuffer());
        try {
            odtDocument2.textDocument = OdfTextDocument.loadDocument((InputStream)is);
            odtDocument = odtDocument2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new InformException(MESSAGE_UNKNOWNFILE);
            }
        }
        ((InputStream)is).close();
        return odtDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OdtDocument openOdtDocument(Scriptable scope, DatasourceField field) throws Exception {
        InputStream is;
        OdtDocument odtDocument = new OdtDocument(scope);
        if (field.getIsNull()) {
            throw new InformException(MESSAGE_EMPTYFIELD);
        }
        switch (field.getDataType()) {
            case BLOB: {
                if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                    throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                }
                BinaryObject binary = field.getAsBinary();
                assert (binary != null);
                is = new ByteArrayInputStream(binary.getInternalBuffer());
                break;
            }
            case FILE: {
                is = ((BlobFileField)field).openFileStream();
                break;
            }
            default: {
                throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, new Object[]{field.getDataType()}));
            }
        }
        assert (is != null);
        try {
            odtDocument.textDocument = OdfTextDocument.loadDocument((InputStream)is);
            OdtDocument odtDocument2 = odtDocument;
            return odtDocument2;
        }
        finally {
            is.close();
        }
    }

    @SmartScriptableObject.FunctionTag
    public void saveToFile(String fileName) throws Exception {
        assert (this.textDocument != null);
        try (FileOutputStream os = new FileOutputStream(Core.mountfs.resolve(new File(fileName)));){
            this.textDocument.save((OutputStream)os);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void saveToBlob(Object dataSource) throws Exception {
        if (dataSource instanceof BinaryObject) {
            this.saveToBinaryObject((BinaryObject)dataSource);
        } else if (dataSource instanceof DatasourceField) {
            this.saveToDatasourceField((DatasourceField)dataSource);
        } else {
            throw new InformException(String.format(MESSAGE_BADTYPE, dataSource == null ? "null" : dataSource.getClass().getName()));
        }
    }

    private void saveToBinaryObject(BinaryObject binary) throws Exception {
        assert (this.textDocument != null);
        assert (binary != null);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.textDocument.save((OutputStream)os);
            binary.clear();
            try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                binary.loadFromStream(is);
            }
        }
    }

    private void saveToDatasourceField(DatasourceField field) throws Exception {
        assert (this.textDocument != null);
        assert (field != null);
        field.clear();
        switch (field.getDataType()) {
            case BLOB: {
                if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                    throw new InformException(String.format(MESSAGE_BADFIELDTYPE_WRITE, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                }
                BinaryObject binary = new BinaryObject();
                this.saveToBinaryObject(binary);
                field.setAsBinary(binary);
                break;
            }
            case FILE: {
                BinaryObject binary = new BinaryObject();
                this.saveToBinaryObject(binary);
                field.setAsBinary(binary);
                break;
            }
            default: {
                throw new InformException(String.format(MESSAGE_BADFIELDTYPE_WRITE, new Object[]{field.getDataType()}));
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this.textDocument.close();
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceTextAll(Object sourceText, Object newText) throws Exception {
        boolean success = false;
        if (sourceText instanceof String && newText instanceof String) {
            TextNavigation search = new TextNavigation(sourceText.toString(), this.textDocument);
            while (search.hasNext()) {
                TextSelection item = (TextSelection)search.getCurrentItem();
                if (item.getText().contains(sourceText.toString())) {
                    success = true;
                }
                item.replaceWith(newText.toString());
            }
            return success;
        }
        throw new InformException(MESSAGE_BADPARAMETRS);
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceText(Object sourceText, Object newText) throws Exception {
        if (sourceText instanceof String && newText instanceof String) {
            TextNavigation search = new TextNavigation(sourceText.toString(), this.textDocument);
            while (search.hasNext()) {
                TextSelection item = (TextSelection)search.getCurrentItem();
                if (!item.getText().contains(sourceText.toString())) continue;
                item.replaceWith(newText.toString());
                return true;
            }
            return false;
        }
        throw new InformException(MESSAGE_BADPARAMETRS);
    }

    @SmartScriptableObject.FunctionTag
    public OdtParagraph insertParagraph(Object index, OdtStyle style) throws Exception {
        int parIndex = this.ParseIndex(index);
        return OdtParagraph.insert(this, parIndex, style);
    }

    @SmartScriptableObject.FunctionTag
    public OdtFont createFont(Object font) {
        if (font == null || font instanceof Undefined) {
            return new OdtFont(this);
        }
        if (font instanceof OdtFont) {
            return new OdtFont(this, (OdtFont)font);
        }
        throw new InformException(String.format(MESSAGE_BADFONT, new Object[0]));
    }

    @SmartScriptableObject.FunctionTag
    public OdtStyle createStyle(Object paragraphStyle) {
        if (paragraphStyle == null || paragraphStyle instanceof Undefined) {
            return new OdtStyle(this);
        }
        if (paragraphStyle instanceof OdtStyle) {
            return new OdtStyle(this, (OdtStyle)paragraphStyle);
        }
        throw new InformException(String.format(MESSAGE_BADSTYLE, new Object[0]));
    }

    @SmartScriptableObject.FunctionTag
    public OdtTable getTable(Object id) throws Exception {
        if (id instanceof String) {
            List tables = this.textDocument.getTableList();
            for (OdfTable odfTable : tables) {
                for (OdfTableRow row : odfTable.getRowList()) {
                    for (int j = 0; j < row.getCellCount(); ++j) {
                        OdfTableCell cell = row.getCellByIndex(j);
                        if (!cell.getDisplayText().contains(id.toString())) continue;
                        return new OdtTable(this, odfTable);
                    }
                }
            }
        } else if (id instanceof Number) {
            int tablePos = this.ParseIndex(id);
            List tables = this.textDocument.getTableList();
            if (tablePos < 0 || tablePos >= tables.size()) {
                throw new InformException(String.format(MESSAGE_TABLE_NOTFOUND, tablePos));
            }
            OdfTable table = (OdfTable)tables.get(tablePos);
            return new OdtTable(this, table);
        }
        return null;
    }

    @SmartScriptableObject.PropertyTag
    public int getElementCount() throws Exception {
        OfficeTextElement rootElement = this.textDocument.getContentRoot();
        return rootElement.getChildNodes().getLength() - 1;
    }

    @SmartScriptableObject.FunctionTag
    public OdtParagraph getParagraph(Object text) throws Exception {
        if (text instanceof String) {
            NodeList paragraphs = this.textDocument.getContentDom().getElementsByTagName("text:p");
            for (int i = 0; i < paragraphs.getLength(); ++i) {
                OdfTextParagraph paragraph = (OdfTextParagraph)paragraphs.item(i);
                if (!paragraph.getTextContent().contains(text.toString()) || paragraph.getParentNode().getLocalName().equals("table-cell")) continue;
                return new OdtParagraph(this, paragraph);
            }
            return null;
        }
        throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
    }

    private int ParseIndex(Object index) {
        if (index instanceof Number) {
            return ((Number)index).intValue();
        }
        throw new InformException(String.format(MESSAGE_BADINDEX, index == null ? "null" : index.toString()));
    }

    public static Color parseColor(Object value) {
        if (value instanceof Number) {
            int c = ((Number)value).intValue();
            return new Color(new java.awt.Color(c));
        }
        if (value instanceof String) {
            int c = Integer.parseInt(value.toString());
            return new Color(new java.awt.Color(c));
        }
        throw new InformException(String.format(MESSAGE_BADCOLOR, value));
    }
}

