/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.odt;

import inform.adt.InformException;
import inform.agent.scripts.textdocuments.odt.OdtDocument;
import inform.common.SmartScriptableObject;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableCellRange;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdtTable
extends SmartScriptableObject {
    private static final String MESSAGE_BADINDEX = "\u0412\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441 '%s'";
    private static final String MESSAGE_ROW_NOTFOUND = "\u0421\u0442\u0440\u043e\u043a\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u043e\u043c '%s' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
    private static final String MESSAGE_CELL_NOTFOUND = "\u042f\u0447\u0435\u0439\u043a\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u043e\u043c '%s' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
    private static final String MESSAGE_BADPARAMETRS = "\u0412\u0432\u0435\u0434\u0435\u043d\u044b \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
    private static final String MESSAGE_BADCOUNT_ROWS = "\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a '%s'";
    private static final String MESSAGE_BADCOUNT_COLUMNS = "\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043b\u043e\u043d\u043e\u043a '%s'";
    private final OdtDocument odtDocument;
    private OdfTable table;

    public OdtTable(OdtDocument odtDocument) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
    }

    public OdtTable(OdtDocument odtDocument, OdfTable table) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
        this.table = table;
    }

    @Override
    public String getClassName() {
        return "OdtTable";
    }

    @SmartScriptableObject.PropertyTag
    public int getType() {
        return 2;
    }

    @SmartScriptableObject.FunctionTag
    public void clearCell(Object rowPos, Object colPos) {
        int rowIndex = this.ParseIndex(rowPos);
        int colIndex = this.ParseIndex(colPos);
        int rowCount = this.table.getRowCount();
        if (rowIndex >= rowCount) {
            throw new InformException(String.format(MESSAGE_ROW_NOTFOUND, rowIndex));
        }
        int columnCount = this.table.getColumnCount();
        if (colIndex >= columnCount) {
            throw new InformException(String.format(MESSAGE_CELL_NOTFOUND, colIndex));
        }
        OdfTableCell cell = this.table.getCellByPosition(rowIndex, colIndex);
        cell.setStringValue("");
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceTextInCell(Object sourceText, Object newText, Object rowPos, Object colPos) {
        int rowIndex = this.ParseIndex(rowPos);
        int colIndex = this.ParseIndex(colPos);
        int rowCount = this.table.getRowCount();
        if (rowIndex >= rowCount) {
            throw new InformException(String.format(MESSAGE_ROW_NOTFOUND, rowIndex));
        }
        int columnCount = this.table.getColumnCount();
        if (colIndex >= columnCount) {
            throw new InformException(String.format(MESSAGE_CELL_NOTFOUND, colIndex));
        }
        if (sourceText instanceof String && newText instanceof String) {
            OdfTableCell cell = this.table.getCellByPosition(rowIndex, colIndex);
            NodeList paragraphs = cell.getOdfElement().getElementsByTagName("text:p");
            for (int i = 0; i < paragraphs.getLength(); ++i) {
                TextPElement paragraph = (TextPElement)paragraphs.item(i);
                String oldValue = paragraph.getTextContent();
                String newValue = oldValue.replaceAll(sourceText.toString(), newText.toString());
                if (newValue.equals(oldValue)) continue;
                paragraph.setTextContent(newValue);
                return true;
            }
            return false;
        }
        throw new InformException(MESSAGE_BADPARAMETRS);
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceTextAllInCell(Object sourceText, Object newText, Object rowPos, Object colPos) {
        int rowIndex = this.ParseIndex(rowPos);
        int colIndex = this.ParseIndex(colPos);
        int rowCount = this.table.getRowCount();
        if (rowIndex >= rowCount) {
            throw new InformException(String.format(MESSAGE_ROW_NOTFOUND, rowIndex));
        }
        int columnCount = this.table.getColumnCount();
        if (colIndex >= columnCount) {
            throw new InformException(String.format(MESSAGE_CELL_NOTFOUND, colIndex));
        }
        if (sourceText instanceof String && newText instanceof String) {
            OdfTableCell cell = this.table.getCellByPosition(rowIndex, colIndex);
            NodeList paragraphs = cell.getOdfElement().getElementsByTagName("text:p");
            boolean success = false;
            for (int i = 0; i < paragraphs.getLength(); ++i) {
                TextPElement paragraph = (TextPElement)paragraphs.item(i);
                String oldValue = paragraph.getTextContent();
                String newValue = oldValue.replaceAll(sourceText.toString(), newText.toString());
                if (newValue.equals(oldValue)) continue;
                paragraph.setTextContent(newValue);
                success = true;
            }
            return success;
        }
        throw new InformException(MESSAGE_BADPARAMETRS);
    }

    @SmartScriptableObject.FunctionTag
    public void insertRow(Object pos, Object count) {
        boolean toEnd;
        int index = this.ParseIndex(pos);
        boolean bl = toEnd = index >= this.table.getRowCount();
        if (index < 0) {
            throw new InformException(String.format(MESSAGE_BADINDEX, index));
        }
        if (count instanceof Number) {
            int cnt = ((Number)count).intValue();
            if (toEnd) {
                for (int i = 0; i < cnt; ++i) {
                    this.table.appendRow();
                }
            } else {
                for (int i = 0; i < cnt; ++i) {
                    this.table.insertRowsBefore(index, 1);
                }
            }
        } else {
            throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
        }
    }

    @SmartScriptableObject.FunctionTag
    public void insertColumn(Object pos, Object count) {
        boolean toEnd;
        int index = this.ParseIndex(pos);
        boolean bl = toEnd = index >= this.table.getRowByIndex(0).getCellCount();
        if (index < 0) {
            throw new InformException(String.format(MESSAGE_BADINDEX, index));
        }
        if (count instanceof Number) {
            int cnt = ((Number)count).intValue();
            if (toEnd) {
                for (int i = 0; i < cnt; ++i) {
                    this.table.appendColumn();
                }
            } else {
                for (int i = 0; i < cnt; ++i) {
                    this.table.insertColumnsBefore(index, 1);
                }
            }
        } else {
            throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
        }
    }

    @SmartScriptableObject.FunctionTag
    public void mergeCells(Object rowIndex, Object columnIndex, Object rowCount, Object columnCount) {
        int rn = this.ParseIndex(rowIndex);
        int cn = this.ParseIndex(columnIndex);
        int rCnt = this.ParseCount(rowCount);
        int cCnt = this.ParseCount(columnCount);
        int endRowIndex = rn + rCnt;
        int endColumnIndex = cn + cCnt;
        if (rn < 0 || rn >= this.table.getRowCount()) {
            throw new InformException(String.format(MESSAGE_BADINDEX, rn));
        }
        if (cn < 0 || cn >= this.table.getColumnCount()) {
            throw new InformException(String.format(MESSAGE_BADINDEX, cn));
        }
        if (rCnt < 0 || endRowIndex >= this.table.getRowCount()) {
            throw new InformException(String.format(MESSAGE_BADCOUNT_ROWS, rCnt + 1));
        }
        if (cCnt < 0 || endColumnIndex >= this.table.getColumnCount()) {
            throw new InformException(String.format(MESSAGE_BADCOUNT_COLUMNS, cCnt + 1));
        }
        OdfTableCellRange range = this.table.getCellRangeByPosition(cn, rn, endColumnIndex, endRowIndex);
        range.merge();
    }

    @SmartScriptableObject.PropertyTag
    public int getIndex() throws Exception {
        int parIndex = 0;
        for (Node node = this.odtDocument.textDocument.getContentRoot().getFirstChild(); node != null; node = node.getNextSibling()) {
            OdfTable currentTable;
            OdfElement element;
            if (node instanceof OdfElement && (element = (OdfElement)node) instanceof TableTableElement && this.table.equals(currentTable = OdfTable.getInstance((TableTableElement)((TableTableElement)element)))) {
                return parIndex - 1;
            }
            ++parIndex;
        }
        return -1;
    }

    private int ParseIndex(Object index) {
        if (index instanceof Number) {
            return ((Number)index).intValue();
        }
        throw new InformException(String.format(MESSAGE_BADINDEX, index == null ? "null" : index.toString()));
    }

    private int ParseCount(Object index) {
        if (index instanceof Number) {
            int count = ((Number)index).intValue() - 1;
            if (count == -1) {
                return 0;
            }
            if (count < -1) {
                throw new InformException(String.format(MESSAGE_BADINDEX, index.toString()));
            }
            return count;
        }
        throw new InformException(String.format(MESSAGE_BADINDEX, index == null ? "null" : index.toString()));
    }
}

