/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.word;

import inform.adt.InformException;
import inform.agent.scripts.textdocuments.word.WordDocument;
import inform.agent.scripts.textdocuments.word.WordParagraph;
import inform.common.SmartScriptableObject;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class WordTable
extends SmartScriptableObject {
    static final String MESSAGE_ROW_NOTFOUND = "\u0421\u0442\u0440\u043e\u043a\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u043e\u043c '%s' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
    static final String MESSAGE_CELL_NOTFOUND = "\u042f\u0447\u0435\u0439\u043a\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u043e\u043c '%s' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
    private static final String MESSAGE_BADPARAMETRS = "\u0412\u0432\u0435\u0434\u0435\u043d\u044b \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
    private static final String MESSAGE_BADINDEX = "\u0412\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441 '%s'";
    private static final String MESSAGE_BADCOUNT_ROWS = "\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a '%s'";
    private static final String MESSAGE_BADCOUNT_COLUMNS = "\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043b\u043e\u043d\u043e\u043a '%s'";
    private final WordDocument wordDocument;
    private XWPFTable table;

    public WordTable(WordDocument wordDocument) {
        this.setParentScope(wordDocument);
        this.wordDocument = wordDocument;
    }

    public WordTable(WordDocument wordDocument, XWPFTable table) {
        this.setParentScope(wordDocument);
        this.wordDocument = wordDocument;
        this.table = table;
    }

    @Override
    public String getClassName() {
        return "WordTable";
    }

    @SmartScriptableObject.PropertyTag
    public int getType() {
        return 2;
    }

    @SmartScriptableObject.FunctionTag
    public void clearCell(Object rowPos, Object colPos) {
        int rowIndex = this.ParseIndex(rowPos);
        int colIndex = this.ParseIndex(colPos);
        XWPFTableRow row = this.table.getRow(rowIndex);
        if (row == null) {
            throw new InformException(String.format(MESSAGE_ROW_NOTFOUND, rowIndex));
        }
        XWPFTableCell cell = row.getCell(colIndex);
        if (cell == null) {
            throw new InformException(String.format(MESSAGE_CELL_NOTFOUND, colIndex));
        }
        List cellParagraphs = cell.getParagraphs();
        for (XWPFParagraph cellParagraph : cellParagraphs) {
            for (XWPFRun run : cellParagraph.getRuns()) {
                run.setText("", 0);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceTextAllInCell(Object sourceText, Object newText, Object rowPos, Object colPos) {
        int rowIndex = this.ParseIndex(rowPos);
        int colIndex = this.ParseIndex(colPos);
        XWPFTableRow row = this.table.getRow(rowIndex);
        if (row == null) {
            throw new InformException(String.format(MESSAGE_ROW_NOTFOUND, rowIndex));
        }
        XWPFTableCell cell = row.getCell(colIndex);
        if (cell == null) {
            throw new InformException(String.format(MESSAGE_CELL_NOTFOUND, colIndex));
        }
        List cellParagraphs = cell.getParagraphs();
        boolean success = false;
        boolean successAll = false;
        if (sourceText instanceof String && newText instanceof String) {
            for (XWPFParagraph cellParagraph : cellParagraphs) {
                success = WordParagraph.replaceTextInParagraph(sourceText.toString(), newText.toString(), cellParagraph, true);
                if (!success) continue;
                successAll = true;
            }
            return successAll;
        }
        throw new InformException(MESSAGE_BADPARAMETRS);
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceTextInCell(Object sourceText, Object newText, Object rowPos, Object colPos) {
        if (sourceText instanceof String && newText instanceof String) {
            int rowIndex = this.ParseIndex(rowPos);
            int colIndex = this.ParseIndex(colPos);
            if (rowIndex < 0 || rowIndex >= this.table.getRows().size()) {
                throw new InformException(String.format(MESSAGE_ROW_NOTFOUND, rowIndex));
            }
            XWPFTableRow row = this.table.getRow(rowIndex);
            if (colIndex < 0 || colIndex >= row.getTableICells().size()) {
                throw new InformException(String.format(MESSAGE_CELL_NOTFOUND, colIndex));
            }
            XWPFTableCell cell = row.getCell(colIndex);
            List cellParagraphs = cell.getParagraphs();
            boolean success = false;
            for (XWPFParagraph cellParagraph : cellParagraphs) {
                success = WordParagraph.replaceTextInParagraph(sourceText.toString(), newText.toString(), cellParagraph, false);
                if (!success) continue;
                return true;
            }
            return success;
        }
        throw new InformException(MESSAGE_BADPARAMETRS);
    }

    @SmartScriptableObject.FunctionTag
    public void insertRow(Object pos, Object count) throws Exception {
        int index = this.ParseIndex(pos);
        boolean toEnd = false;
        if (index < 0) {
            throw new InformException(String.format(MESSAGE_BADINDEX, index));
        }
        if (index >= this.table.getRows().size()) {
            index = this.table.getRows().size() - 1;
            toEnd = true;
        }
        if (count instanceof Number && ((Number)count).intValue() > 0) {
            int cnt = ((Number)count).intValue();
            XWPFTableRow oldRow = this.table.getRow(index);
            CTRow ctrow = (CTRow)CTRow.Factory.parse(oldRow.getCtRow().newInputStream());
            XWPFTableRow newRow = new XWPFTableRow(ctrow, this.table);
            for (XWPFTableCell cell : newRow.getTableCells()) {
                cell.setText("");
            }
            if (toEnd) {
                for (int i = 0; i < cnt; ++i) {
                    this.table.addRow(newRow, index + 1 + i);
                }
            } else {
                for (int i = 0; i < cnt; ++i) {
                    this.table.addRow(newRow, index);
                }
            }
        } else {
            throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
        }
    }

    @SmartScriptableObject.FunctionTag
    public void insertColumn(Object pos, Object count) {
        int index = this.ParseIndex(pos);
        if (index < 0) {
            throw new InformException(String.format(MESSAGE_BADINDEX, index));
        }
        if (index >= this.table.getRow(0).getTableCells().size()) {
            index = this.table.getRow(0).getTableCells().size();
        }
        if (count instanceof Number && ((Number)count).intValue() > 0) {
            int cnt = ((Number)count).intValue();
            for (int j = 0; j < cnt; ++j) {
                for (XWPFTableRow row : this.table.getRows()) {
                    row.addNewTableCell();
                    for (int i = row.getTableCells().size() - 1; i > index; --i) {
                        XWPFTableCell prevCell = row.getCell(i - 1);
                        XWPFTableCell curCell = row.getCell(i);
                        curCell.setText(prevCell.getText());
                    }
                    XWPFTableCell cell = row.getCell(index);
                    cell.setText("");
                }
            }
        } else {
            throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
        }
    }

    @SmartScriptableObject.FunctionTag
    public void mergeCells(Object rowIndex, Object columnIndex, Object rowCount, Object columnCount) throws Exception {
        int i;
        int rn = this.ParseIndex(rowIndex);
        int cn = this.ParseIndex(columnIndex);
        int rCnt = this.ParseCount(rowCount);
        int cCnt = this.ParseCount(columnCount);
        if (rn < 0 || rn >= this.table.getRows().size()) {
            throw new InformException(String.format(MESSAGE_BADINDEX, rn));
        }
        if (cn < 0 || cn >= this.table.getRow(0).getTableCells().size()) {
            throw new InformException(String.format(MESSAGE_BADINDEX, cn));
        }
        if (rCnt < 0 || rn + rCnt >= this.table.getRows().size()) {
            throw new InformException(String.format(MESSAGE_BADCOUNT_ROWS, rCnt + 1));
        }
        if (cCnt < 0 || cn + cCnt >= this.table.getRow(0).getTableCells().size()) {
            throw new InformException(String.format(MESSAGE_BADCOUNT_COLUMNS, cCnt + 1));
        }
        for (i = rn; i <= rCnt + rn; ++i) {
            XWPFTableCell cell = this.table.getRow(i).getCell(cn);
            CTVMerge vMerge = (CTVMerge)CTVMerge.Factory.newInstance();
            if (i == rn) {
                vMerge.setVal(STMerge.RESTART);
            } else {
                vMerge.setVal(STMerge.CONTINUE);
                for (int k = cell.getParagraphs().size(); k > 0; --k) {
                    cell.removeParagraph(0);
                }
                cell.addParagraph();
            }
            CTTcPr tcPr = cell.getCTTc().getTcPr();
            if (tcPr == null) {
                tcPr = cell.getCTTc().addNewTcPr();
            }
            tcPr.setVMerge(vMerge);
        }
        for (i = rn; i <= rCnt + rn; ++i) {
            for (int j = cn; j <= cCnt + cn; ++j) {
                XWPFTableCell cell = this.table.getRow(i).getCell(j);
                CTHMerge hMerge = (CTHMerge)CTHMerge.Factory.newInstance();
                if (j == cn) {
                    hMerge.setVal(STMerge.RESTART);
                } else {
                    hMerge.setVal(STMerge.CONTINUE);
                    for (int k = cell.getParagraphs().size(); k > 0; --k) {
                        cell.removeParagraph(0);
                    }
                    cell.addParagraph();
                }
                CTTcPr tcPr = cell.getCTTc().getTcPr();
                if (tcPr == null) {
                    tcPr = cell.getCTTc().addNewTcPr();
                }
                tcPr.setHMerge(hMerge);
            }
        }
    }

    @SmartScriptableObject.PropertyTag
    public int getIndex() {
        List bodyElements = this.wordDocument.document.getBodyElements();
        int index = 0;
        for (IBodyElement element : bodyElements) {
            if (element instanceof XWPFTable && element.equals(this.table)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int ParseIndex(Object index) {
        if (index instanceof Number) {
            return ((Number)index).intValue();
        }
        throw new InformException(String.format(MESSAGE_BADINDEX, index == null ? "null" : index.toString()));
    }

    private int ParseCount(Object index) {
        if (index instanceof Number) {
            int count = ((Number)index).intValue() - 1;
            if (count == -1) {
                return 0;
            }
            if (count < -1) {
                throw new InformException(String.format(MESSAGE_BADINDEX, index.toString()));
            }
            return count;
        }
        throw new InformException(String.format(MESSAGE_BADINDEX, index == null ? "null" : index.toString()));
    }
}

