/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textutils;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.replication.ReplicationRecord;
import java.util.ArrayList;

public class ExtractionDataInfo {
    private final TableDescriptor td;
    private final FieldDescriptor fd;
    private final double rowId;
    private final ArrayList<ReplicationRecord.Value> pkValues;

    public ExtractionDataInfo(TableDescriptor td, FieldDescriptor fd, double rowId) {
        this.td = td;
        this.fd = fd;
        this.rowId = rowId;
        this.pkValues = null;
    }

    public ExtractionDataInfo(TableDescriptor td, FieldDescriptor fd, ArrayList<ReplicationRecord.Value> pkValues) {
        this.td = td;
        this.fd = fd;
        this.rowId = 0.0;
        this.pkValues = pkValues;
    }

    public String toString() {
        if (this.td == null || this.fd == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        sb.append(this.td.toString());
        sb.append(" ");
        this.fd.toLogString(sb);
        if (this.rowId != 0.0) {
            sb.append(" rowId=").append(this.rowId);
        } else if (this.pkValues != null) {
            String dlm = "";
            sb.append(" pKey=");
            block7: for (ReplicationRecord.Value pk : this.pkValues) {
                sb.append(dlm);
                dlm = ",";
                if (pk.isNull()) continue;
                switch (pk.getType()) {
                    case INTEGER: {
                        sb.append(pk.getInteger());
                        continue block7;
                    }
                    case BOOLEAN: {
                        sb.append(pk.getAsBoolean());
                        continue block7;
                    }
                    case DOUBLE: {
                        sb.append(pk.getDouble());
                        continue block7;
                    }
                    case DATE_TIME: {
                        sb.append(pk.getDateTime());
                    }
                    case TIMESTAMP: {
                        sb.append(pk.getTimestamp());
                        continue block7;
                    }
                }
                sb.append(pk.getString());
            }
        }
        sb.append(" )");
        return sb.toString();
    }
}

