/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.util;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.CancelRequestException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.scripts.Task;
import inform.common.SmartScriptableObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.FunctionObject;

public class RunnableProcess
extends SmartScriptableObject
implements Closeable {
    private final ServerSideHost host;
    private String application = null;
    private final ArrayList<String> arguments = new ArrayList();
    private Process process = null;

    public RunnableProcess(ServerSideHost host, Task task) {
        this.host = host;
        Method mWait = null;
        for (Method m : RunnableProcess.class.getDeclaredMethods()) {
            String mName = m.getName();
            if (mWait != null || !"scriptWait".equals(mName)) continue;
            mWait = m;
        }
        if (mWait != null) {
            FunctionObject f = new FunctionObject("wait", mWait, this);
            this.defineProperty("wait", (Object)f, 0);
        }
        if (task != null) {
            task.registerCloseable(this);
        }
    }

    @Override
    public void close() throws IOException {
        this.terminate();
    }

    @SmartScriptableObject.PropertyTag
    public String getApplication() {
        return this.application;
    }

    public void setApplication(String value) {
        this.application = value;
    }

    @SmartScriptableObject.FunctionTag
    public void clearArguments() {
        this.idle();
        this.arguments.clear();
    }

    @SmartScriptableObject.FunctionTag
    public Object addArgument(String value) {
        this.idle();
        if (!Strings.isVoid(value)) {
            this.arguments.add(value);
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public Object addFileArgument(String value) {
        value = Core.mountfs.resolvePath(value);
        this.addArgument(value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public boolean addFileToArgument(String filePath) {
        boolean result = false;
        if (filePath.isEmpty()) {
            return false;
        }
        File f = null;
        try {
            f = Core.mountfs.resolve(new File(filePath));
        }
        catch (Exception e) {
            throw InformException.wrap(e);
        }
        if (f == null) {
            return false;
        }
        if (!f.exists() || f.isDirectory()) {
            return false;
        }
        try (FileInputStream source = new FileInputStream(f);){
            String data = new String(source.readAllBytes());
            if (!data.isEmpty()) {
                result = true;
            }
            this.addArgument(data);
        }
        catch (Exception e) {
            throw InformException.wrap(e);
        }
        return result;
    }

    @SmartScriptableObject.FunctionTag
    public void run() {
        this.terminate();
        String[] command = this.command();
        try {
            this.process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void terminate() {
        if (this.process != null) {
            try {
                Process process = this.process;
                this.process = null;
                this.arguments.clear();
                if (process != null && process.isAlive()) {
                    process.destroy();
                    if (!process.waitFor(1L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new CancelRequestException();
            }
        }
    }

    public boolean scriptWait(double msec) {
        this.idle();
        if (this.process == null) {
            return false;
        }
        try {
            return !this.process.waitFor((long)msec, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new CancelRequestException();
        }
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsRunning() {
        this.idle();
        return this.process != null && this.process.isAlive();
    }

    @SmartScriptableObject.PropertyTag
    public int getResultCode() {
        this.idle();
        try {
            if (this.process != null && this.process.waitFor(0L, TimeUnit.MILLISECONDS)) {
                return this.process.exitValue();
            }
            return -1;
        }
        catch (InterruptedException e) {
            throw new CancelRequestException();
        }
    }

    @SmartScriptableObject.PropertyTag
    public String getConsoleOutput() {
        this.idle();
        if (this.process == null) {
            return "";
        }
        return RunnableProcess.readOutput(this.process.getInputStream());
    }

    @SmartScriptableObject.PropertyTag
    public String getConsoleError() {
        this.idle();
        if (this.process == null) {
            return "";
        }
        return RunnableProcess.readOutput(this.process.getErrorStream());
    }

    private static String readOutput(InputStream stream) {
        if (stream == null) {
            return "";
        }
        try {
            StringBuilder result = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(stream));){
                String s;
                while ((s = in.readLine()) != null) {
                    result.append(s).append('\n');
                }
            }
            return result.toString();
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
    }

    private void idle() {
        if (this.host != null) {
            this.host.idle();
        }
    }

    private String[] command() {
        String cmd = Core.mountfs.resolvePath(this.application);
        String[] command = new String[1 + this.arguments.size()];
        command[0] = cmd;
        int index = 0;
        int count = this.arguments.size();
        while (index < count) {
            String arg = this.arguments.get(index);
            command[++index] = arg;
        }
        return command;
    }
}

