/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.am.Telemeter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.web.AgentInfoServlet;
import inform.agent.web.AsyncTaskServlet;
import inform.agent.web.BlobBinaryServlet;
import inform.agent.web.DisableHttp09Filter;
import inform.agent.web.DocumentServlet;
import inform.agent.web.IconServlet;
import inform.agent.web.JWTServlet;
import inform.agent.web.LoginServlet;
import inform.agent.web.LogoutServlet;
import inform.agent.web.ModuleServlet;
import inform.agent.web.NodeServlet;
import inform.agent.web.OpenNodeServlet;
import inform.agent.web.PortUnificationSelectChannelConnector;
import inform.agent.web.PortUnificationSslSelectChannelConnector;
import inform.agent.web.RequestHandler;
import inform.agent.web.RequestLog;
import inform.agent.web.RobotsServlet;
import inform.agent.web.SchemeServlet;
import inform.agent.web.Session;
import inform.agent.web.SoapServlet;
import inform.agent.web.StaticContentServlet;
import inform.agent.web.TestServlet;
import inform.agent.web.WMDServiceProvider;
import inform.agent.web.WasmLoginServlet;
import inform.agent.web.WasmServlet;
import inform.agent.web.rq.BlobData;
import inform.agent.web.rq.CommitRecords;
import inform.agent.web.rq.ExecuteScript;
import inform.agent.web.rq.FetchRecords;
import inform.agent.web.rq.GenerateFieldValue;
import inform.agent.web.rq.GetDistinctValues;
import inform.agent.web.rq.NodeInfo;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpServer {
    public static final int REQUEST_FETCH_RECORDS = 1;
    public static final int REQUEST_GET_DISTINCT_VALUES = 2;
    public static final int REQUEST_COMMIT_RECORDS = 3;
    public static final int REQUEST_EXECUTE_SCRIPT = 4;
    public static final int REQUEST_GENERATE_FIELD_VALUE = 5;
    private static Server server;
    private static Session.Manager sessionManager;
    private static final WMDServiceProvider provider;
    private static DoubleSet anonHttpNodes;
    private static int _httpPort;
    private static boolean _isHttpsProtocol;

    public static void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
        RequestHandler.gatherTelemetry(gatherer);
    }

    public static void gatherWebUsers(TaggedWriter w) throws IOException, InformException {
        Session.Manager m = sessionManager;
        if (m != null) {
            m.webUsersInfoRequest(w);
        }
    }

    public static int sessionsCount() {
        if (sessionManager == null) {
            return 0;
        }
        return sessionManager.getSessions();
    }

    public static String getUserAgentOfSession(String sessionId) {
        Session session = (Session)sessionManager.getSession(sessionId);
        if (null == session) {
            return null;
        }
        return session.userAgent;
    }

    private static Object getAttributeFromSession(String sessionId, String attribute) {
        AbstractSession session = sessionManager.getSession(sessionId);
        if (null == session) {
            return null;
        }
        return session.getAttribute(attribute);
    }

    public static Double getPersistentSessionIdFromWasmSession(String sessionId) {
        return (Double)HttpServer.getAttributeFromSession(sessionId, "__asmo_persistent_session");
    }

    public static void removePersistentSessionIdFromWasmSession(String sessionId) {
        AbstractSession session = sessionManager.getSession(sessionId);
        if (session != null) {
            session.removeAttribute("__asmo_persistent_session");
        }
    }

    public static void setPersistentSessionIdForWasmSession(String sessionId, double persistentSessionId) {
        AbstractSession session = sessionManager.getSession(sessionId);
        if (null == session) {
            return;
        }
        session.setAttribute("__asmo_persistent_session", (Object)persistentSessionId);
    }

    public static String popJwtFromSession(String sessionId) {
        AbstractSession session = sessionManager.getSession(sessionId);
        if (null == session) {
            return null;
        }
        String jwt = (String)session.getAttribute("__asmo_encoded_jwt");
        session.removeAttribute("__asmo_encoded_jwt");
        return jwt;
    }

    public static boolean isValidWasmTicket(String ticket) {
        Session.Manager m = sessionManager;
        if (m == null) {
            return false;
        }
        return m.isTicketValid(ticket);
    }

    private static void initConnector(SelectChannelConnector connector) {
        if (Ini.httpRequestHeaderSize > 0) {
            int size = Ini.httpRequestHeaderSize * 1024;
            if (size > 0x100000) {
                size = 0x100000;
            }
            connector.setRequestHeaderSize(size);
            Core.logger.info("httpRequestHeaderSize: {}", (Object)size);
        }
    }

    public static void JNI_startMaster(int port, boolean secure) throws Exception {
        if (_httpPort == 0 || !_isHttpsProtocol) {
            _httpPort = port;
            _isHttpsProtocol = secure;
        }
        Object c = secure ? new PortUnificationSslSelectChannelConnector(HttpServer.createSslContextFactory()) : new PortUnificationSelectChannelConnector();
        c.setPort(port);
        HttpServer.initConnector(c);
        HttpServer.start((Connector)c);
    }

    public static void JNI_startSlave(final int handle, final int port, boolean secure) throws Exception {
        if (_httpPort == 0 || !_isHttpsProtocol) {
            _httpPort = port;
            _isHttpsProtocol = secure;
        }
        if (secure) {
            HttpServer.start((Connector)new PortUnificationSslSelectChannelConnector(HttpServer.createSslContextFactory()){
                private final Selector selector;
                {
                    super(sslContextFactory);
                    this.selector = Selector.open();
                }

                public void open() throws IOException {
                    this.setForwarded(true);
                    this.setPort(port);
                    HttpServer.initConnector((SelectChannelConnector)this);
                    sessionManager.setSessionCookie("JSESSIONID_" + port);
                    this._acceptChannel = provider.createChannel(handle);
                    this._acceptChannel.configureBlocking(false);
                    this._acceptChannel.register(this.selector, 16);
                }

                public void accept(int acceptorID) throws IOException {
                    ServerSocketChannel acceptChannel = this._acceptChannel;
                    SelectorManager _manager = this.getSelectorManager();
                    if (acceptChannel != null && acceptChannel.isOpen() && _manager.isStarted()) {
                        SocketChannel channel;
                        this.selector.select(300L);
                        while (acceptChannel.isOpen() && _manager.isStarted() && (channel = acceptChannel.accept()) != null) {
                            try {
                                channel.configureBlocking(false);
                                Socket socket = channel.socket();
                                this.configure(socket);
                                SocketChannel channelForRegister = channel;
                                channel = null;
                                _manager.register(channelForRegister);
                            }
                            catch (Throwable e) {
                                if (channel != null) {
                                    try {
                                        channel.close();
                                    }
                                    catch (Throwable ce) {
                                        Core.logger.error(null, ce);
                                    }
                                }
                                throw e;
                            }
                        }
                    }
                }
            });
            return;
        }
        HttpServer.start((Connector)new PortUnificationSelectChannelConnector(){
            private final Selector selector = Selector.open();

            public void open() throws IOException {
                this.setForwarded(true);
                this.setPort(port);
                HttpServer.initConnector(this);
                sessionManager.setSessionCookie("JSESSIONID_" + port);
                this._acceptChannel = provider.createChannel(handle);
                this._acceptChannel.configureBlocking(false);
                this._acceptChannel.register(this.selector, 16);
            }

            public void accept(int acceptorID) throws IOException {
                ServerSocketChannel acceptChannel = this._acceptChannel;
                SelectorManager _manager = this.getSelectorManager();
                if (acceptChannel != null && acceptChannel.isOpen() && _manager.isStarted()) {
                    SocketChannel channel;
                    this.selector.select(300L);
                    while (acceptChannel.isOpen() && _manager.isStarted() && (channel = acceptChannel.accept()) != null) {
                        try {
                            channel.configureBlocking(false);
                            Socket socket = channel.socket();
                            this.configure(socket);
                            SocketChannel channelForRegister = channel;
                            channel = null;
                            _manager.register(channelForRegister);
                        }
                        catch (Throwable e) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable ce) {
                                    Core.logger.error(null, ce);
                                }
                            }
                            throw e;
                        }
                    }
                }
            }
        });
    }

    private static SslContextFactory createSslContextFactory() {
        SslContextFactory result = new SslContextFactory();
        result.setKeyStoreType("PKCS12");
        if (Ini.KeyStore.isEmpty()) {
            throw new InformException("\u043d\u0435 \u0437\u0430\u0434\u0430\u043d keystore-\u0444\u0430\u0439\u043b (\u0441\u043c. \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 key_store)");
        }
        String[] ks = Ini.KeyStore.split("@");
        result.setKeyStorePath(ks[0]);
        if (ks.length > 1) {
            result.setKeyStorePassword(ks[1]);
        }
        return result;
    }

    private static void start(Connector connector) throws Exception {
        Server serv = HttpServer.start();
        serv.addConnector(connector);
        if (serv.getConnectors().length == 1) {
            sessionManager.setSessionCookie("JSESSIONID_" + connector.getPort());
        }
        connector.start();
    }

    private static void addCommonServlets(ServletContextHandler context) {
        if (!Strings.isVoid(Ini.jwtKeysDir)) {
            context.addServlet(JWTServlet.class, "/jwt/*");
        }
        context.addServlet(NodeServlet.class, "/node/*");
        context.addServlet(StaticContentServlet.class, "/static/*");
        context.addServlet(LoginServlet.class, "/login/*");
        context.addServlet(LogoutServlet.class, "/logout/*");
        context.addServlet(ModuleServlet.class, "/module/*");
        context.addServlet(OpenNodeServlet.class, "/openNode/*");
        context.addServlet(SoapServlet.class, "/soap/*");
        context.addServlet(RobotsServlet.class, "/robots.txt");
    }

    private static Server start() throws Exception {
        if (server != null) {
            return server;
        }
        Core.logger.info("Starting web server...");
        server = new Server();
        server.setSendServerVersion(false);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setServletHandler((ServletHandler)new RequestHandler());
        context.addFilter(DisableHttp09Filter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        sessionManager = new Session.Manager();
        context.getSessionHandler().setSessionManager((SessionManager)sessionManager);
        context.setContextPath("/");
        if (Ini.Wasm) {
            context.addServlet(WasmServlet.class, "/*");
            context.addServlet(AgentInfoServlet.class, "/agent_info/*");
            context.addServlet(WasmLoginServlet.class, "/reconnect/*");
            HttpServer.addCommonServlets(context);
            if (Ini.UsePersistentSessions) {
                Core.logger.info("Persistent sessions for wasm clients ENABLED");
            }
        } else if (Ini.Web) {
            context.addServlet(TestServlet.class, "/");
            context.addServlet(SchemeServlet.class, "/scheme/*");
            context.addServlet(IconServlet.class, "/images/icons/*");
            context.addServlet(GetDistinctValues.class, "/rq/getDistinctValues");
            context.addServlet(FetchRecords.class, "/rq/fetchRecords");
            context.addServlet(CommitRecords.class, "/rq/commitRecords");
            context.addServlet(BlobData.class, "/rq/blobData/*");
            context.addServlet(ExecuteScript.class, "/rq/executeScript");
            context.addServlet(GenerateFieldValue.class, "/rq/generateFieldValue");
            context.addServlet(NodeInfo.class, "/rq/nodeInfo");
            context.addServlet(AsyncTaskServlet.class, "/async/*");
            context.addServlet(DocumentServlet.class, "/bdoc/*");
            context.addServlet(BlobBinaryServlet.class, "/files/*");
            HttpServer.addCommonServlets(context);
        } else {
            context.addServlet(AgentInfoServlet.class, "/*");
        }
        if (Ini.TraceHttp) {
            server.setHandler((Handler)new RequestLog((Handler)context));
        } else {
            server.setHandler((Handler)context);
        }
        if (Ini.AnonHttpNodes != null && !Ini.AnonHttpNodes.isEmpty()) {
            String[] nodes;
            anonHttpNodes = new DoubleSet();
            for (String s : nodes = Ini.AnonHttpNodes.split(",")) {
                try {
                    double id = Long.parseLong(s);
                    anonHttpNodes.add(id);
                }
                catch (NumberFormatException e) {
                    Core.logger.error("Invalid parameter value (anon_http_nodes)", e);
                }
            }
        }
        server.start();
        Core.logger.info("... web server started");
        return server;
    }

    public static void JNI_stop() throws Exception {
        Core.logger.info("Stopping web server...");
        if (server == null) {
            Core.logger.warn("...web server already stopped");
            return;
        }
        sessionManager = null;
        server.stop();
        server.join();
        server = null;
        Core.logger.info("... web server stopped");
    }

    public static int port() {
        Connector[] connectors;
        if (_httpPort == 0 && server != null && (connectors = server.getConnectors()) != null) {
            for (int i = 0; i < connectors.length; ++i) {
                Connector c = connectors[i];
                if (c == null) continue;
                _httpPort = c.getPort();
                _isHttpsProtocol = c instanceof SslConnector;
                return _httpPort;
            }
        }
        return _httpPort;
    }

    public static boolean isHttpsProtocol() {
        return _isHttpsProtocol;
    }

    public static void serverNodeUpdated(ServerNode.Descriptor sd) {
        Session.Manager sm = sessionManager;
        if (sm == null) {
            return;
        }
        int sto = sd.webSessionTimeout;
        if (sto == 0) {
            sto = 7200;
        }
        sm.setMaxInactiveInterval(sto);
    }

    public static boolean isAnonHttpNode(double nodeId) {
        if (anonHttpNodes == null || anonHttpNodes.empty()) {
            return false;
        }
        if (anonHttpNodes.contains(nodeId)) {
            return true;
        }
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            return false;
        }
        return anonHttpNodes.contains(node.getParentId());
    }

    static {
        provider = new WMDServiceProvider();
        _httpPort = 0;
        _isHttpsProtocol = false;
    }
}

