/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;

public class JSON {
    public static String toString(double v) {
        long lv = (long)v;
        return (double)lv == v ? Long.toString(lv) : Double.toString(v);
    }

    public static String toString(Object o) {
        if (o instanceof Serializable) {
            HashSet<String> serialized = new HashSet<String>();
            StringBuilder result = new StringBuilder();
            result.append('{');
            boolean nc = false;
            Class<?> clazz = o.getClass();
            do {
                String name;
                Object v;
                Serializable.Serialize s;
                for (Field field : clazz.getDeclaredFields()) {
                    s = field.getAnnotation(Serializable.Serialize.class);
                    if (s == null || !serialized.add(field.getName())) continue;
                    try {
                        v = field.get(o);
                    }
                    catch (IllegalAccessException e) {
                        throw InformException.wrap(e);
                    }
                    if (v == null) continue;
                    name = s.value();
                    if (name.isEmpty()) {
                        name = field.getName();
                    }
                    if (nc) {
                        result.append(',');
                    }
                    result.append('\"').append(name).append("\":").append(JSON.toString(v));
                    nc = true;
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    s = ((Method)accessibleObject).getAnnotation(Serializable.Serialize.class);
                    if (s == null || !serialized.add(((Method)accessibleObject).getName())) continue;
                    try {
                        v = ((Method)accessibleObject).invoke(o, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw InformException.wrap(e);
                    }
                    if (v == null) continue;
                    name = s.value();
                    if (name.isEmpty()) {
                        name = ((Method)accessibleObject).getName();
                    }
                    if (nc) {
                        result.append(',');
                    }
                    result.append('\"').append(name).append("\":").append(JSON.toString(v));
                    nc = true;
                }
            } while ((clazz = clazz.getSuperclass()) != Object.class);
            result.append('}');
            return result.toString();
        }
        if (o instanceof Double) {
            return JSON.toString((Double)o);
        }
        return org.eclipse.jetty.util.ajax.JSON.toString((Object)o);
    }

    public static Object parse(String s) {
        return org.eclipse.jetty.util.ajax.JSON.parse((String)s);
    }

    public static Object parse(Reader r) throws IOException {
        return org.eclipse.jetty.util.ajax.JSON.parse((Reader)r);
    }

    public static String mkError(Object message) {
        return "{\"error\":" + JSON.toString(message) + "}";
    }

    public static interface Serializable {

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD, ElementType.METHOD})
        public static @interface Serialize {
            public String value() default "";
        }
    }
}

