/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActiveDirectory;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Resource;
import inform.agent.web.Session;
import inform.common.Base64BinString;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.B64Code;

public class LoginServlet
extends AsmoServlet {
    private static final String SKEY = "__asmo_disposable_key";

    private String subPath(String pathInfo) {
        if (pathInfo == null) {
            return null;
        }
        String[] sp = pathInfo.split("/");
        if (sp.length < 2) {
            return null;
        }
        return sp[1];
    }

    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        block21: {
            resp.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
            Session session = (Session)req.getSession(true);
            String sUser = req.getParameter("$user");
            if ("json".equals(this.subPath(req.getPathInfo()))) {
                resp.setCharacterEncoding("UTF-8");
                PrintWriter w = resp.getWriter();
                if (sUser != null) {
                    UserNode user = MtdEngine.getUserNodeByName(sUser);
                    if (user == null) {
                        w.write("{\"error\":\"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\"}");
                        return;
                    }
                    String h = req.getParameter("$hash");
                    if (h != null) {
                        byte[] hash = B64Code.decode((String)h);
                        byte[] uh = user.getSecurityHash();
                        byte[] disp = (byte[])session.getAttribute(SKEY);
                        if (disp != null) {
                            MessageDigest md = MessageDigest.getInstance("md5");
                            md.update(uh);
                            md.update((byte)58);
                            uh = md.digest(disp);
                        }
                        if (Arrays.equals(hash, uh)) {
                            ServerNode.Descriptor sd = MtdEngine.serverNode().descriptor();
                            if (!sd.webAllowEmptyPasswords && user.checkPassword("")) {
                                w.write("{\"error\":\"\u041f\u0443\u0441\u0442\u044b\u0435 \u043f\u0430\u0440\u043e\u043b\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b\"}");
                                return;
                            }
                            session.removeAttribute(SKEY);
                            Session.User u = session.authAs(user, req.getRemoteAddr());
                            w.write(JSON.toString(u));
                        } else {
                            w.write("{\"error\":\"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c\"}");
                        }
                        return;
                    }
                    StringBuilder result = new StringBuilder();
                    result.append("{\"name\":").append(JSON.toString(user.getName()));
                    if (user.isActiveDirectoryAuthorization()) {
                        String host = req.getRemoteHost();
                        result.append(",\"ad\":{\"domain\":").append(JSON.toString(ActiveDirectory.getComputerDomainName())).append(",\"hostname\":").append(JSON.toString(host)).append("}}");
                        w.write(result.toString());
                        return;
                    }
                    byte[] disp = (byte[])session.getAttribute(SKEY);
                    if (disp == null) {
                        disp = new byte[24];
                        Session.random(disp);
                        session.setAttribute(SKEY, disp);
                    }
                    result.append(",\"salt\":").append(JSON.toString(new String(user.getSecuritySalt(), TaggedWriter.ANSI)));
                    result.append(",\"disp\":").append(JSON.toString(new String(B64Code.encode((byte[])disp))));
                    result.append('}');
                    w.write(result.toString());
                    return;
                }
                String ad = req.getParameter("$ad");
                if (ad != null) {
                    ActiveDirectory activeDirectory = (ActiveDirectory)session.getAttribute("__asmo_active_directory");
                    if (activeDirectory == null) {
                        activeDirectory = ActiveDirectory.createInstance(1);
                        session.setAttribute("__asmo_active_directory", activeDirectory);
                    }
                    try {
                        byte[] data = Base64BinString.Decode(ad);
                        data = activeDirectory.processRaw(data);
                        if (activeDirectory.isSuccessful()) {
                            String uname = activeDirectory.getUserName();
                            UserNode node = MtdEngine.getAcitiveDirectoryUserNodes(uname);
                            if (node == null) {
                                throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                            }
                            if (!node.isActiveDirectoryAuthorization()) {
                                throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u0432\u0445\u043e\u0434 \u0447\u0435\u0440\u0435\u0437 AD");
                            }
                            session.removeAttribute("__asmo_active_directory");
                            activeDirectory.close();
                            Session.User u = session.authAs(node, req.getRemoteAddr());
                            w.write(JSON.toString(u));
                            return;
                        }
                        w.write("{\"ad\":" + JSON.toString(Base64BinString.Encode(data)) + "}");
                    }
                    catch (Throwable e) {
                        Core.logger.error(null, e);
                        session.removeAttribute("__asmo_active_directory");
                        activeDirectory.close();
                        if (e instanceof ActiveDirectory.Error) {
                            Core.logger.warn("AD", e);
                            w.write("{\"error\":" + JSON.toString("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c") + "}");
                            break block21;
                        }
                        Core.logger.warn("AD {}", (Object)e.toString());
                        w.write("{\"error\":" + JSON.toString(e.toString()) + "}");
                    }
                }
            } else {
                Object redir = this.root() + req.getParameter("$redirect");
                if (Strings.isVoid((String)redir)) {
                    redir = "/";
                }
                String app = Ini.AgentName;
                resp.setHeader("Content-Type", "text/html; charset=windows-1251");
                resp.setHeader("X-UA-Compatible", "IE=edge,chrome=1");
                resp.setCharacterEncoding("WINDOWS-1251");
                String form = Resource.asString(LoginServlet.class, "LoginForm.html", this.root());
                String fattr = "method='get' action='" + (String)redir + "'";
                StringBuilder fbody = new StringBuilder();
                Enumeration i = req.getParameterNames();
                while (i.hasMoreElements()) {
                    String n = (String)i.nextElement();
                    if (n.startsWith("$")) continue;
                    String v = req.getParameter(n);
                    fbody.append("<input type='hidden' name='").append(n).append("' value='").append(v).append("'/>");
                }
                resp.getWriter().append(form.replace("{{TITLE}}", app).replace("DATA-FORM-ATTR", fattr).replace("{{FORM-BODY}}", fbody));
            }
        }
    }
}

