/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.Strings;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.web.RequestTask;
import inform.agent.web.utils.HtmlUtils;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class RequestTaskResponse
extends SmartScriptableObject {
    private final RequestTask requestTask;
    private final HttpServletResponse rs;
    private final Headers headers = new Headers();
    private Charset cs;
    private String delimiter = "";
    private String location;
    private static final String space = " ";

    public RequestTaskResponse(RequestTask requestTask, Scriptable scope) {
        this.requestTask = requestTask;
        this.setParentScope(scope);
        RequestTaskResponse.putConstProperty(this, "headers", this.headers);
        this.rs = requestTask.resp;
        this.cs = Charset.forName(this.rs.getCharacterEncoding());
    }

    private void writeString(String s) throws IOException {
        if (!this.requestTask.needResponse) {
            return;
        }
        if (this.delimiter.isEmpty()) {
            this.delimiter = space;
        } else {
            s = this.delimiter + (String)s;
        }
        ByteBuffer b = this.cs.encode((String)s);
        this.rs.getOutputStream().write(b.array(), b.position(), b.remaining());
    }

    void internalWriteText(String s) throws IOException {
        if ("text/html".equals(this.headers.contentType)) {
            s = HtmlUtils.htmlEnquote(s);
        }
        this.writeString(s);
    }

    @SmartScriptableObject.FunctionTag
    public static Object writeText(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        RequestTaskResponse self = (RequestTaskResponse)thisObj;
        if (!self.requestTask.needResponse) {
            return Undefined.instance;
        }
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                self.internalWriteText(ValueCaster.toString(args[0]));
                break;
            }
            default: {
                StringBuilder s = null;
                for (Object o : args) {
                    if (s == null) {
                        s = new StringBuilder();
                    } else {
                        s.append(' ');
                    }
                    s.append(ValueCaster.toString(o));
                }
                self.internalWriteText(s.toString());
            }
        }
        return Undefined.instance;
    }

    @SmartScriptableObject.FunctionTag
    public void write(Object o) throws IOException {
        if (!this.requestTask.needResponse) {
            return;
        }
        ServletOutputStream out = this.rs.getOutputStream();
        if (o instanceof BinaryObject) {
            BinaryObject b = (BinaryObject)o;
            out.write(b.getInternalBuffer(), 0, b.getSize());
        } else if (o instanceof FileSystemLibrary.BinaryReader) {
            int l;
            FileSystemLibrary.BinaryReader r = (FileSystemLibrary.BinaryReader)o;
            byte[] buffer = new byte[4096];
            while ((l = r.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, l);
            }
        } else if (o instanceof FileSystemLibrary.TextReader) {
            int l;
            FileSystemLibrary.TextReader r = (FileSystemLibrary.TextReader)o;
            char[] buffer = new char[4096];
            while ((l = r.read(buffer, 0, buffer.length)) >= 0) {
                out.write(this.cs.encode(new String(buffer, 0, l)).array());
            }
        } else {
            this.writeString(o.toString());
        }
    }

    @SmartScriptableObject.FunctionTag(name="redirect")
    public void redirect(String to) throws IOException {
        String r = this.translateLocation(to);
        this.rs.sendRedirect(r);
    }

    private String forceGetLocation() {
        String webRoot = this.requestTask.req.getHeader("X-Asmo-Web-Root");
        if (Strings.isVoid(webRoot)) {
            return "";
        }
        Object loc = webRoot;
        if (((String)loc).endsWith("/")) {
            loc = ((String)loc).substring(0, webRoot.length() - 1);
        }
        if (((String)loc).isEmpty()) {
            return loc;
        }
        if (!((String)loc).startsWith("/")) {
            loc = "/" + (String)loc;
        }
        return loc;
    }

    @SmartScriptableObject.PropertyTag(name="location")
    public String getLocation() {
        if (this.location == null) {
            this.location = this.forceGetLocation();
        }
        return this.location;
    }

    private String translateLocation(String url) {
        String loc;
        if (url.isEmpty()) {
            return url;
        }
        Object r = url;
        char firstChar = url.charAt(0);
        if (firstChar == '/' && !(loc = this.getLocation()).isEmpty()) {
            r = loc + url;
        }
        return r;
    }

    @SmartScriptableObject.FunctionTag(name="redirectRaw")
    public void redirectRaw(String to) throws IOException {
        this.rs.sendRedirect(to);
    }

    @SmartScriptableObject.PropertyTag
    public int getStatus() {
        return this.requestTask.status;
    }

    public void setStatus(int s) {
        this.requestTask.status = s;
        this.rs.setStatus(this.requestTask.status);
    }

    @SmartScriptableObject.PropertyTag
    public String getCharset() {
        return this.rs.getCharacterEncoding();
    }

    public void setCharset(String v) {
        this.rs.setCharacterEncoding(v);
        this.cs = Charset.forName(this.rs.getCharacterEncoding());
    }

    @Override
    public String getClassName() {
        return "Response";
    }

    class Headers
    extends ScriptableObject {
        private String contentType;

        Headers() {
        }

        @Override
        public void put(String name, Scriptable start, Object value) {
            if ("Content-Type".equalsIgnoreCase(name)) {
                this.contentType = value == null ? null : value.toString();
            }
            RequestTaskResponse.this.rs.setHeader(name, value == null ? null : value.toString());
            super.put(name, start, value);
        }

        @Override
        public String getClassName() {
            return "Headers";
        }
    }
}

