/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.AbstractScriptableTask;
import inform.agent.scripts.ComponentsFactory;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.soap.SoapMessage;
import inform.agent.web.AsmoServlet;
import inform.agent.web.Helpers;
import inform.agent.web.Session;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.jetty.server.Response;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SOAPTask
extends AbstractScriptableTask {
    private static final int TAG_SCRIPT = 1;
    private static final int TAG_ON_EXECUTE = 3;
    private static final int TAG_VERSION = 11;
    private static final int TAG_WSDL = 12;
    private static final int TAG_COMPONENT_NAME = 20;
    private final String script;
    private final String onExecute;
    private final HttpServletResponse resp;
    private SOAPMessage requestMessage = null;
    private SOAPMessage responseMessage = null;
    private String protocol = "SOAP 1.1 Protocol";
    private double wsdlNodeId = 0.0;
    private final String pathInfo;
    private boolean needResponse = true;

    public SOAPTask(ServerSideHost ssHost, BasicNode node, HttpServletRequest req, HttpServletResponse resp, Session.User user, String rootInfo) throws InformException, IOException, TaggedReaderException, ServletException, IllegalAccessException, InstantiationException, InvocationTargetException, SOAPException {
        super(node, null, ssHost, new ParametersList(), null, null);
        this.resp = resp;
        this.pathInfo = req.getRequestURL().toString();
        TaggedReader in = new TaggedReader(node.getContent());
        String _script = "";
        String _execCall = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 152: {
                    Helpers.datamodelParameters(this.parameters, in.getSubStreamData(), this.constants);
                    break;
                }
                case 1: {
                    _script = in.getAnsi();
                    break;
                }
                case 3: {
                    _execCall = in.getAnsi();
                    break;
                }
                case 20: {
                    ServerSideComponent c = ComponentsFactory.readAndCreateComponent(null, this, this, 20, in);
                    if (c == null) break;
                    c.setParentScope(this);
                    this.components.add(c);
                    SOAPTask.putConstProperty(this, c.getName(), c);
                    break;
                }
                case 11: {
                    if (in.getCurrentTagSize() <= 0) break;
                    this.protocol = in.getAnsi();
                    break;
                }
                case 12: {
                    this.wsdlNodeId = in.getDouble();
                }
            }
        }
        this.components.afterLoad();
        this.script = _script;
        this.onExecute = _execCall;
        if (!this.initWsdlResponse(req, resp)) {
            this.responseMessage = this.createMessage(null, null);
            SOAPTask.putConstProperty(this, "responseMessage", new SoapMessage(this, this.responseMessage, this.protocol));
            MimeHeaders headers = new MimeHeaders();
            Enumeration headerNames = req.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String value = req.getHeader(name);
                headers.setHeader(name, value);
            }
            try {
                this.requestMessage = this.createMessage((InputStream)req.getInputStream(), headers);
                SOAPTask.putConstProperty(this, "requestMessage", new SoapMessage(this, this.requestMessage, this.protocol));
            }
            catch (Exception e) {
                Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 requestMessage \u0432 \u0443\u0437\u043b\u0435 " + this.pathInfo, e);
                this.initFault(e);
                this.initResponse();
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void sendResponse() throws IOException, SOAPException {
        if (this.resp == null) {
            return;
        }
        this.resp.setStatus(this.responseMessage.getSOAPBody().getFault() == null ? 200 : 500);
        this.initResponse();
        this.resp.flushBuffer();
        if (this.resp instanceof Response) {
            ((Response)this.resp).complete();
            this.needResponse = false;
        }
    }

    private SOAPMessage createMessage(InputStream is, MimeHeaders headers) throws SOAPException, IOException {
        MessageFactory mf = MessageFactory.newInstance((String)this.protocol);
        return is == null ? mf.createMessage() : mf.createMessage(headers, is);
    }

    private void initResponse() throws IOException, SOAPException {
        if (!this.needResponse) {
            return;
        }
        if (!this.responseMessage.getSOAPBody().hasChildNodes()) {
            return;
        }
        ServletOutputStream os = this.resp.getOutputStream();
        this.responseMessage.writeTo((OutputStream)os);
        Iterator it = this.responseMessage.getMimeHeaders().getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            this.resp.setHeader(header.getName(), header.getValue());
        }
    }

    private void initFault(Exception e) throws SOAPException {
        if (!this.needResponse) {
            return;
        }
        SOAPFault fault = this.responseMessage.getSOAPBody().addFault();
        fault.setFaultString(e.getMessage());
        if (this.pathInfo != null && !this.pathInfo.isEmpty()) {
            fault.setFaultActor(this.pathInfo);
        }
        StringWriter tmp = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)tmp, true));
        fault.addDetail().setValue(tmp.toString());
        this.resp.setStatus(500);
    }

    public void execute() throws SOAPException, IOException {
        if (this.responseMessage == null) {
            return;
        }
        if (this.resp.getStatus() >= 500) {
            return;
        }
        try {
            this.execute(new AbstractScriptableTask.ExecuteAction<Void>(){

                @Override
                public Void execute(Context context) {
                    context.evaluateString(SOAPTask.this, SOAPTask.this.script, SOAPTask.this.node.toLogString(), 1, null);
                    if (SOAPTask.this.onExecute != null) {
                        ScriptableObject.callMethod(context, SOAPTask.this, SOAPTask.this.onExecute, null);
                    }
                    return null;
                }
            });
            this.resp.setStatus(this.responseMessage.getSOAPBody().getFault() == null ? 200 : 500);
        }
        catch (Exception e) {
            Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0432 \u0443\u0437\u043b\u0435 " + this.pathInfo, e);
            this.initFault(e);
        }
        finally {
            this.initResponse();
        }
    }

    @Override
    public String getClassName() {
        return "SOAP";
    }

    private boolean initWsdlResponse(HttpServletRequest req, HttpServletResponse rsp) {
        if (this.wsdlNodeId != 0.0 && req.getParameter("wsdl") != null && req.getParameterMap().keySet().size() == 1) {
            Node nod = MtdEngine.getNode(this.wsdlNodeId);
            if (nod == null) {
                return false;
            }
            BasicNode wsdlNode = nod.getRealNode();
            byte[] content = wsdlNode.getContent();
            if (content == null || content.length == 0) {
                return false;
            }
            try {
                Document doc = CryptoUtils.loadDocument(content);
                rsp.getOutputStream().write(CryptoUtils.documentAsBytes(doc));
                rsp.setContentType("text/xml;charset=UTF-8");
                rsp.setStatus(200);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException ex) {
                rsp.setStatus(500);
                Core.logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f WSDL \u0438\u0437 \u0443\u0437\u043b\u0430 %.0f", this.wsdlNodeId), ex);
                try {
                    AsmoServlet.Type.RAW.sendServerError(this.resp, ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }
}

