/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.agent.CancelRequestException;
import inform.agent.Core;
import inform.agent.RequestStatistics;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.DBLogin;
import inform.agent.db.PersonalSessionHelper;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.web.FutureInfo;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.AbstractConnection;
import org.mozilla.javascript.Scriptable;

public class WebServerSideHost
implements ServerSideHost,
Future<Void>,
FutureInfo {
    private static final VersionInfo CLIENT_VERSION = new VersionInfo();
    private final double nodeId;
    private final Session.User user;
    private final Collection<DBLogin> dbLogins;
    private final StringBuilder json = new StringBuilder();
    private ConnectionManager[] personalSessions = PersonalSessionHelper.init();
    private boolean cancelThrowed;
    private volatile boolean done;
    private volatile boolean cancelled;
    private final AbstractConnection connection;
    private SSContext ssContext;

    public WebServerSideHost(double nodeId, Session.User user, AbstractConnection connection) {
        this.nodeId = nodeId;
        this.user = user;
        this.dbLogins = user.dbLogins();
        this.connection = connection;
    }

    public WebServerSideHost(double nodeId, Session session, String asyncId, AbstractConnection connection) {
        this(nodeId, session.user(), connection);
        session.store().put(asyncId, this);
    }

    public void setSSContext(SSContext ssContext) {
        this.ssContext = ssContext;
    }

    public void close() {
        PersonalSessionHelper.closeAll(this, this.personalSessions);
        this.done = true;
        if (this.dbLogins != null) {
            for (DBLogin d : this.dbLogins) {
                try {
                    d.close();
                }
                catch (SQLException ex) {
                    Core.logger.error(null, ex);
                }
            }
        }
    }

    @Override
    public long getHostID() {
        return 0L;
    }

    @Override
    public String toLogString() {
        return "web request(nodeId: " + NumberConverter.doubleToString(this.nodeId) + ")";
    }

    @Override
    public double getUserID() {
        return this.user.id();
    }

    @Override
    public int getTimeZoneOffset() {
        return DateTime.serverZoneOffset();
    }

    @Override
    public double getEffectiveUserID() {
        return this.user.id();
    }

    @Override
    public void idle() {
        if (!this.cancelThrowed && this.isCancelled()) {
            this.cancelThrowed = true;
            throw new CancelRequestException();
        }
    }

    @Override
    public void putRequestStateCaption(String caption) throws Exception {
        this.putJSON("capt", caption);
    }

    @Override
    public void putRequestStateText(String msg) throws Exception {
        this.putJSON("text", msg);
    }

    @Override
    public void putRequestStateResultText(String text) throws Exception {
        this.putJSON("resultText", text);
    }

    @Override
    public void putRequestStateInstruction(String message) throws Exception {
        this.putJSON("inst", message);
    }

    @Override
    public void putRequestStateProgressMin(int min) throws Exception {
        this.putJSON("p_mn", min);
    }

    @Override
    public void putRequestStateProgressMax(int max) throws Exception {
        this.putJSON("p_mx", max);
    }

    @Override
    public void putRequestStateProgressPosition(int pos) throws Exception {
        this.putJSON("p_ps", pos);
    }

    @Override
    public void putRequestStateProgressVisible(boolean isVisible) throws Exception {
        this.putJSON("p_vs", isVisible);
    }

    @Override
    public void putRequestStateLog(String msg) throws Exception {
        this.putJSON("r_lg", msg);
    }

    @Override
    public void putRequestStateEnter() throws Exception {
        this.putJSON("enter", null);
    }

    @Override
    public void putRequestStateLeave() throws Exception {
        this.putJSON("leave", null);
    }

    @Override
    public void writeLog(String msg) throws Exception {
        this.putJSON("lg_w", msg);
    }

    @Override
    public void appendToLog(String msg) throws Exception {
        this.putJSON("lg_a", msg);
    }

    @Override
    public void writeLogLine(String msg) throws Exception {
        this.putJSON("lg_l", msg);
    }

    @Override
    public VersionInfo getClientVersion() {
        return CLIENT_VERSION;
    }

    @Override
    public double getNodeID() {
        return this.nodeId;
    }

    public double getLoginRecordID() {
        return 0.0;
    }

    public int getClientID() {
        return 0;
    }

    @Override
    public double getSessionID() {
        return 0.0;
    }

    @Override
    public void sendResult() throws Exception {
    }

    @Override
    public Client client() {
        return null;
    }

    @Override
    public Security security() {
        return Security.ZERO;
    }

    @Override
    public DatabaseDescriptor getDBLogin(DatabaseDescriptor db) throws SQLException {
        if (this.dbLogins == null) {
            return null;
        }
        for (DBLogin dbl : this.dbLogins) {
            if (dbl.getDatabaseId() != db.getNodeId()) continue;
            return dbl.adjust(db);
        }
        return null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        if (this.cancelled) {
            return true;
        }
        return this.isClientInputShutdown();
    }

    @Override
    public String getCancelReason() {
        return null;
    }

    @Override
    public void sendTraceLabel(SSContext context, String text) {
    }

    private boolean isClientInputShutdown() {
        return this.connection != null && this.connection.getEndPoint().isInputShutdown();
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get() throws InterruptedException, ExecutionException {
        WebServerSideHost webServerSideHost = this;
        synchronized (webServerSideHost) {
            while (!this.done) {
                this.wait();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            WebServerSideHost webServerSideHost = this;
            synchronized (webServerSideHost) {
                unit.timedWait(this, timeout);
            }
        }
        if (!this.done) {
            throw new TimeoutException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String poolJSON() {
        StringBuilder stringBuilder = this.json;
        synchronized (stringBuilder) {
            String result = this.json.toString();
            this.json.setLength(0);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putJSON(String cmd, Object arg) {
        StringBuilder stringBuilder = this.json;
        synchronized (stringBuilder) {
            if (this.json.length() > 0) {
                this.json.append(',');
            }
            this.json.append('[').append(JSON.toString(cmd)).append(',').append(JSON.toString(arg)).append(']');
        }
    }

    @Override
    public RequestStatistics.Value rqstat() {
        return null;
    }

    @Override
    public void rqstat(RequestStatistics.Value value) {
    }

    @Override
    public void personalSessionCreated(ConnectionManager ps) {
        this.personalSessions = PersonalSessionHelper.add(this.personalSessions, ps);
    }

    @Override
    public void personalSessionClosed(ConnectionManager ps) {
        PersonalSessionHelper.remove(this.personalSessions, ps);
    }

    @Override
    public SSContext getSSContext() {
        return this.ssContext;
    }

    @Override
    public void standing(long time) {
    }

    public static class WithScriptable
    extends WebServerSideHost
    implements ScriptableHost {
        Scriptable topLevelScope;
        Constants constants;

        public WithScriptable(double nodeId, Session.User user, AbstractConnection connection) {
            super(nodeId, user, connection);
        }

        @Override
        public Scriptable getTopLevelScope() {
            return this.topLevelScope;
        }

        @Override
        public void setTopLevelScope(Scriptable topLevelScope) {
            this.topLevelScope = topLevelScope;
        }

        @Override
        public Constants getConstants() {
            return this.constants;
        }

        @Override
        public void setConstants(Constants constants) {
            this.constants = constants;
        }

        @Override
        public SSContext getRootContext() {
            return this.getSSContext();
        }
    }
}

