/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.data;

import inform.adt.collections.IntegerHash;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.util.DatasourceRelation;
import inform.agent.web.data.DataNode;
import inform.agent.web.data.DatamodelCallback;
import java.util.ArrayList;

public class Datamodel {
    private final IntegerHash<DataNode> nodes = new IntegerHash();
    private int level = 0;
    private ArrayList<Layer> layers = null;
    private ArrayList<DataNode> explicitNodes = null;
    private DatamodelCallback callback = null;

    public void reset() {
        this.layers = null;
        this.explicitNodes = null;
        if (this.level < 0) {
            return;
        }
        this.layers = new ArrayList(this.level + 1);
        this.explicitNodes = new ArrayList();
        for (int l = 0; l <= this.level; ++l) {
            Layer layer = new Layer();
            layer.initRecordIndex = 0;
            this.layers.add(layer);
            for (DataNode node : this.nodes) {
                if (node.level != l) continue;
                layer.add(node);
                if (!node.explicit) continue;
                this.explicitNodes.add(node);
                layer.hasExplicit = true;
            }
        }
    }

    public void first() throws Exception {
        this.reset();
        this.resetLayer(this.level);
    }

    public void enumerate(DatamodelCallback callback) throws Exception {
        this.callback = callback;
        try {
            this.reset();
            this.resetLayer(this.level);
            this.enumerate(this.level);
        }
        finally {
            this.callback = null;
        }
    }

    public void add(Dataset datasource) {
        DataNode node = this.nodes.get(datasource.getId());
        if (node != null) {
            node.explicit = true;
            return;
        }
        int level = 0;
        this.updateLevel(level);
        node = new DataNode(datasource, level, true);
        this.nodes.add(node);
        if (datasource.hasRelation()) {
            this.addParents(node, level + 1);
        }
    }

    private void addParent(Dataset datasource, int level) {
        DataNode parent = this.nodes.get(datasource.getId());
        if (parent != null) {
            parent.setLevel(level);
        } else {
            parent = new DataNode(datasource, level, false);
            this.nodes.add(parent);
        }
        if (datasource.hasRelation()) {
            this.addParents(parent, level + 1);
        }
    }

    private void addParents(DataNode node, int level) {
        DatasourceRelation relation;
        assert (node.datasource.hasRelation());
        this.updateLevel(level);
        if (node.datasource.getParentDataset() != null && node.datasource.getDataLinkId() != 0) {
            this.addParent(node.datasource.getParentDataset(), level);
        }
        if ((relation = node.datasource.getRelation()) != null) {
            int count = relation.size();
            for (int index = 0; index < count; ++index) {
                Datasource datasource = relation.getParent(index);
                this.addParent(datasource, level);
            }
        }
    }

    private void updateLevel(int level) {
        if (this.level < level) {
            this.level = level;
        }
    }

    private void resetLayer(int fromLevel) throws Exception {
        for (int level = fromLevel; level >= 0; --level) {
            Layer layer = this.layers.get(level);
            layer.recordIndex = layer.initRecordIndex;
            for (DataNode node : layer) {
                node.reset();
            }
        }
    }

    private void setLayersPosition(int fromLevel) {
        for (int level = fromLevel; level >= 0; --level) {
            Layer layer = this.layers.get(level);
            layer.recordIndex = layer.initRecordIndex;
            for (DataNode node : layer) {
                node.setPosition(layer.recordIndex);
            }
        }
    }

    private void enumerate(int level) throws Exception {
        if (level < 0) {
            return;
        }
        Layer layer = this.layers.get(level);
        while (!layer.isEof()) {
            if (layer.recordIndex == layer.initRecordIndex && layer.hasExplicit) {
                this.callbackStep();
            }
            this.enumerate(level - 1);
            this.enumerateStep(layer, level - 1);
        }
    }

    private void enumerateStep(Layer layer, int nextLevel) throws Exception {
        boolean needCallback = false;
        int nextRecordIndex = layer.recordIndex + 1;
        for (DataNode node : layer) {
            node.setPosition(nextRecordIndex);
            if (needCallback || !node.explicit || node.isEof()) continue;
            needCallback = true;
        }
        layer.recordIndex = nextRecordIndex;
        this.resetLayer(nextLevel);
        if (needCallback) {
            this.doCallback();
        }
    }

    private void doCallback() throws Exception {
        if (this.callback != null) {
            for (DataNode node : this.explicitNodes) {
                node.recordId = node.getCurrentRecordId();
            }
            this.callback.datamodelStep();
        }
    }

    private void callbackStep() throws Exception {
        for (DataNode node : this.explicitNodes) {
            if (node.getCurrentRecordId() == node.recordId) continue;
            this.doCallback();
            break;
        }
    }

    private static class Layer
    extends ArrayList<DataNode> {
        int initRecordIndex;
        int recordIndex;
        boolean hasExplicit;

        private Layer() {
        }

        boolean isEof() {
            if (this.recordIndex >= this.initRecordIndex) {
                for (DataNode node : this) {
                    if (node.isEof()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

