/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval.op;

import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.expr.Term;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.expr.eval.op.WebBinaryEvaluator;
import inform.agent.web.utils.TypedValue;

public class WebAddEvaluator
extends WebBinaryEvaluator {
    public WebAddEvaluator(Term term, WebEvaluator left, WebEvaluator right) {
        super(term, left, right);
    }

    @Override
    protected TypedValue calc(TypedValue left, TypedValue right) {
        if (WebAddEvaluator.isStringable(left.getType())) {
            return new TypedValue(DataType.STRING, ValueCaster.toString(left.getValue()) + ValueCaster.toString(right.getValue()));
        }
        return super.calc(left, right);
    }

    @Override
    protected TypedValue calcNumber(double left, double right) {
        if (right == 0.0 || Double.isInfinite(right) || Double.isNaN(right) || Double.isInfinite(left) || Double.isNaN(left)) {
            return null;
        }
        return new TypedValue(DataType.FLOAT, left + right);
    }
}

