/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerDoubleMap;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.components.WebComponent;
import java.io.IOException;

public interface DatasourceUsage {
    public void appendUsedDirectoriesTo(Scanner var1) throws IOException;

    public static class Scanner {
        private final ParametersList parameters;
        IntegerDoubleMap dsmap = new IntegerDoubleMap();
        public final IntegerHash<Fields.Ds> datasources = new IntegerHash();
        final DoubleHash<Fields.Dir> directories = new DoubleHash();

        public Scanner(ParametersList parameters) {
            this.parameters = parameters;
        }

        public void append(int ds, Iterable<Cursor.Integer> fields) {
            Fields.Ds d = this.datasources.get(ds);
            if (d == null) {
                d = new Fields.Ds(ds);
                this.datasources.add(d);
            }
            for (Cursor.Integer i : fields) {
                d.fields.add(i.value);
            }
        }

        private void append(Object owner, double ref, int ... fpath) {
            for (int i = 1; i < fpath.length; ++i) {
                FieldDescriptor fd;
                Fields.Dir dr = this.directories.get(ref);
                if (dr == null) {
                    dr = new Fields.Dir(ref);
                    this.directories.add(dr);
                }
                try {
                    fd = TableDescriptor.get(ref).getValidFieldDescriptor(fpath[i], null);
                }
                catch (Exception e) {
                    StringBuilder detail = new StringBuilder();
                    while (owner != null) {
                        IntegerHash.Entry wc;
                        String cname;
                        if (detail.length() > 0) {
                            detail.append(" < ");
                        }
                        if ((cname = owner.getClass().getSimpleName()).startsWith("Web")) {
                            cname = cname.substring(3);
                        }
                        detail.append(cname);
                        if (owner instanceof WebControl) {
                            wc = (WebControl)owner;
                            detail.append("(id=").append(((WebControl)wc).id);
                            Scanner.appendStringPropertyIf(detail, "name", ((WebControl)wc).name());
                            detail.append(')');
                            owner = ((WebControl)wc).parent;
                            continue;
                        }
                        if (owner instanceof WebComponent) {
                            wc = (WebComponent)owner;
                            detail.append("(id=").append(((WebComponent)wc).id);
                            Scanner.appendStringPropertyIf(detail, "name", ((WebComponent)wc).name());
                            Scanner.appendStringPropertyIf(detail, "title", ((WebComponent)wc).title());
                            detail.append(')');
                            owner = ((WebComponent)wc).parent;
                            continue;
                        }
                        owner = null;
                    }
                    throw InformException.detail(e, detail.toString());
                }
                dr.fields.add(fpath[i]);
                for (FieldDescriptor.LookupField lf : fd.multiLookupFields()) {
                    dr.fields.add(lf.path[0]);
                    this.append(owner, ref, lf.path);
                }
                ref = fd.getReferenceId();
            }
        }

        private static void appendStringPropertyIf(StringBuilder out, String pname, String pvalue) {
            if (Strings.isVoid(pvalue)) {
                return;
            }
            out.append(',').append(pname).append('=').append(pvalue);
        }

        public void append(Object owner, int ds, int ... fpath) {
            double ref;
            if (ds == 0 || fpath == null) {
                return;
            }
            if (ds == -1) {
                if (fpath.length == 0) {
                    return;
                }
                Parameter p = this.parameters.get(fpath[0]);
                if (p == null) {
                    return;
                }
                ref = p.refTableId();
            } else {
                if (!this.dsmap.contains(ds)) {
                    return;
                }
                Fields.Ds d = this.datasources.get(ds);
                if (d == null) {
                    d = new Fields.Ds(ds);
                    this.datasources.add(d);
                }
                if (fpath.length == 0) {
                    return;
                }
                d.fields.add(fpath[0]);
                TableDescriptor td = TableDescriptor.get(this.dsmap.lget());
                FieldDescriptor fd = td.getFieldDescriptor(fpath[0]);
                if (fd != null) {
                    for (FieldDescriptor.LookupField lf : fd.multiLookupFields()) {
                        this.append(owner, ds, lf.path);
                    }
                    ref = fd.getReferenceId();
                } else {
                    ref = 0.0;
                }
            }
            if (ref != 0.0) {
                this.append(owner, ref, fpath);
            }
        }

        public void appendPBindings(Object owner, TaggedReader reader) throws IOException {
            int dsid = 0;
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 21: {
                        dsid = reader.getInt();
                        break;
                    }
                    case 22: {
                        this.append(owner, dsid, reader.getInt());
                    }
                }
            }
        }

        public static abstract class Fields {
            public final IntegerSet fields = new IntegerSet();

            static class Dir
            extends Fields
            implements DoubleHash.Entry {
                final double id;

                Dir(double id) {
                    this.id = id;
                }

                @Override
                public double key() {
                    return this.id;
                }
            }

            public static class Ds
            extends Fields
            implements IntegerHash.Entry {
                final int id;

                Ds(int id) {
                    this.id = id;
                }

                @Override
                public int key() {
                    return this.id;
                }
            }
        }
    }
}

