/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponent;
import inform.agent.web.forms.components.WebDatasource;
import java.io.IOException;

public abstract class Resolver {
    public final WebForm.Task arg;
    public boolean hasFormScript = false;

    Resolver(WebForm.Task arg) {
        this.arg = arg;
    }

    public abstract WebComponent resolveComponent(int var1);

    public abstract WebControl resolveControl(int var1);

    public abstract ParametersList parameters();

    public abstract Constants constants();

    public DataType resolveDataType(int dsid, int ... fpath) throws IOException {
        if (dsid == -1) {
            ParametersList pp = this.parameters();
            Parameter p = pp.get(fpath[0]);
            return p != null ? p.getDataType() : DataType.NONE;
        }
        WebComponent wcm = this.resolveComponent(dsid);
        if (wcm != null) {
            return ((WebDatasource)wcm).resolveDataType(fpath);
        }
        return this.resolveControl(dsid).resolveDataType(fpath);
    }

    public int resolveFormatId(int dsid, int ... fpath) throws IOException {
        FieldDescriptor fd;
        if (dsid == -1) {
            Parameter p = this.parameters().get(fpath[0]);
            return p != null ? p.getFormatId() : 0;
        }
        WebComponent wcm = this.resolveComponent(dsid);
        if (wcm != null && (fd = ((WebDatasource)wcm).resolveFieldDescriptor(fpath)) != null) {
            return fd.getFormat();
        }
        return 0;
    }
}

