/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebButton;
import inform.agent.web.forms.WebControlContainer;
import java.io.IOException;

@JSRequire(value={"WebCheckbox"})
public class WebCheckbox
extends WebButton
implements DatasourceUsage {
    private static final int TAG_WEB_BUTTON_CHEKED = 44;
    private static final int TAG_WEB_BUTTON_DATASOURCE = 46;
    private static final int TAG_WEB_BUTTON_FIELD = 47;
    private static final int TAG_WEB_BUTTON_CAPTION_TOLEFT = 55;
    protected boolean checked;
    protected boolean captionLeft;
    protected int datasourceId;
    protected int[] fieldId;

    public WebCheckbox(int id, int options, WebControlContainer parent) {
        super(id, options, parent);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 44: {
                this.checked = true;
                break;
            }
            case 46: {
                this.datasourceId = reader.getInt();
                break;
            }
            case 47: {
                this.fieldId = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 55: {
                this.captionLeft = true;
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        json.object().underscore("WebCheckbox.WclControl", this).prop("id").val(this.id).prop("caption").val(this.text).prop("cleft").val(this.captionLeft).prop("cmps").js("components");
        if (this.hasdb(this.datasourceId, this.fieldId)) {
            json.prop("fpath").js("DM.mkFieldPath(").val(this.fieldId).js(",").val(this.datasourceId).js(",components)");
        }
        if (this.event != null) {
            json.prop("action").val(this.event.toValue());
        }
        json.end();
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        out.append((Object)this, this.datasourceId, this.fieldId);
    }

    @Override
    DataType resolveDataType(int ... fpath) {
        return DataType.BOOLEAN;
    }
}

