/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.ParametersList;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.ParameterSyncs;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponent;
import java.io.IOException;
import java.util.Collections;

@JSRequire(value={"WebFrame"})
public class WebFrame
extends WebControl
implements DatasourceUsage {
    private static final int TAG_WEB_FRAME_NODE_ID = 40;
    private static final int TAG_WEB_FRAME_AUTOSIZE = 41;
    private static final int TAG_WEB_FRAME_WIDTH = 42;
    private static final int TAG_WEB_FRAME_HEIGHT = 43;
    private static final int TAG_WEB_FRAME_PARAMS = 44;
    private static final int TAG_WEB_FRAME_PARAM_SYNC = 45;
    private WebForm.NodeData<ND, IOException> node;
    private boolean autosize;
    private byte[] pbindings;
    private Iterable<ParameterSyncs.Entry> syncs = Collections.emptyList();

    public WebFrame(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.node = new WebForm.NodeData<ND, IOException>(reader.getNodeID()){

                    @Override
                    protected ND read(Node node) throws IOException {
                        TaggedReader reader = new TaggedReader(((BasicNode)node).getContent());
                        while (reader.next()) {
                            if (reader.getCurrentTag() != 152) continue;
                            TaggedReader r = reader.getSubStreamReader();
                            while (r.next()) {
                                if (r.getCurrentTag() != 153) continue;
                                return new ND(node.getType(), r.getSubStreamData());
                            }
                        }
                        return null;
                    }
                };
                break;
            }
            case 41: {
                this.autosize = reader.getBoolean();
                break;
            }
            case 42: {
                this.width = reader.getDouble();
                break;
            }
            case 43: {
                this.height = reader.getDouble();
                break;
            }
            case 44: {
                reader.skip();
                this.pbindings = reader.getSubStreamData();
                break;
            }
            case 45: {
                this.syncs = new ParameterSyncs(reader.getSubStreamReader());
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        json.object().underscore("WebFrame", this).prop("id").val(this.id).prop("cmps").js("components").prop("node").val(this.node.id);
        StringBuilder pbinds = new StringBuilder();
        ND nd = this.node.fetch();
        if (nd != null) {
            ParametersList plist = new ParametersList();
            plist.load(resolver.arg.getConstants(), new TaggedReader(nd.parameters), Core.serverTimeZoneHost);
            if (this.pbindings != null) {
                plist.loadParametersBindings(resolver.arg.getParameters(), resolver.arg.getConstants(), new TaggedReader(this.pbindings));
            }
            WebComponent.generateParametersBindingsTo(pbinds, plist, "datamodel._datasources", "\n\t\t", false, null);
        }
        StringBuilder psyncs = new StringBuilder();
        boolean nc = false;
        for (ParameterSyncs.Entry p : this.syncs) {
            if (nc) {
                psyncs.append(',');
            }
            psyncs.append("\n\t\t").append(JSON.toString(p.name)).append(':');
            psyncs.append("datamodel._datasources[").append(p.dsid).append("]._fbyid[").append(p.fpath[0]).append(']');
            nc = true;
        }
        if (nd != null && nd.type == 45) {
            json.prop("isform").val(true);
        }
        if (pbinds.length() > 0) {
            json.prop("p_bindings").object().js(pbinds.toString()).end();
        }
        if (psyncs.length() > 0) {
            json.prop("paramsyncs").object().js(psyncs.toString()).end();
        }
        json.end();
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        for (ParameterSyncs.Entry p : this.syncs) {
            out.append((Object)this, p.dsid, p.fpath);
        }
        if (this.pbindings != null) {
            out.appendPBindings(this, new TaggedReader(this.pbindings));
        }
    }

    private static class ND {
        final int type;
        final byte[] parameters;

        ND(int type, byte[] parameters) {
            this.type = type;
            this.parameters = parameters;
        }
    }
}

