/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.Collections;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebBorders;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebGridCommon;
import inform.agent.web.forms.WebGridVeer;
import inform.agent.web.forms.expr.JsEvaluator;
import inform.agent.web.forms.expr.JsExpression;
import inform.agent.web.utils.Color;
import inform.common.Base64BinString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@JSRequire(value={"WebGrid", "css!WebGrid", "WebGridCommon"})
@WebControlContainer.ContainsChildren(type=508, cls=WebGridCommon.Footer.class)
public class WebGrid
extends WebControlContainer
implements DatasourceUsage {
    private static final int WF_GRID_COLUMN = 501;
    private static final int TAG_WEB_BORDERS = 11;
    private static final int TAG_WF_GRID_DATASOURCE = 42;
    private static final int TAG_WF_GRID_ROW_COLOR_EXPRESSION = 44;
    private static final int TAG_WF_GRID_ROW_TEXT_COLOR_EXPRESSION = 45;
    private static final int TAG_WF_GRID_ROW_TEXT_STYLE_EXPRESSION = 46;
    private static final int TAG_WF_GRID_PAGING = 47;
    private static final int TAG_WF_GRID_PAGING_PAGESIZE = 1;
    private static final int TAG_WF_GRID_HIDE_SELECTION = 48;
    private static final int TAG_WF_GRID_EVENT = 49;
    private static final int TAG_WF_GRID_MAX_HEIGHT = 50;
    private static final int TAG_WF_GRID_MIN_HEIGHT = 51;
    private WebBorders borders;
    private int datasourceId;
    private JsEvaluator rowColorExpression;
    private JsEvaluator rowTextColorExpression;
    private JsEvaluator rowTextStyleExpression;
    private int pageSize = -1;
    private WebControl.WebEvent event;
    private int minHeight;
    private int maxHeight;
    private boolean hideSelection;

    public WebGrid(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 11: {
                this.borders = new WebBorders(reader.getSubStreamReader());
                break;
            }
            case 42: {
                this.datasourceId = reader.getInt();
                break;
            }
            case 44: {
                this.rowColorExpression = JsExpression.loadAndCompile(reader.getStreamReader());
                break;
            }
            case 45: {
                this.rowTextColorExpression = JsExpression.loadAndCompile(reader.getStreamReader());
                break;
            }
            case 46: {
                this.rowTextStyleExpression = JsExpression.loadAndCompile(reader.getStreamReader());
                break;
            }
            case 47: {
                this.pageSize = 0;
                if (reader.getNextTag() == 202) {
                    TaggedReader r = reader.getStreamReader();
                    while (r.next()) {
                        if (r.getCurrentTag() != 1) continue;
                        this.pageSize = r.getInt();
                    }
                    break;
                }
                reader.tagback();
                break;
            }
            case 48: {
                this.hideSelection = true;
                break;
            }
            case 49: {
                this.event = new WebControl.WebEvent(reader.getRaw());
                break;
            }
            case 51: {
                this.minHeight = reader.getInt();
                break;
            }
            case 50: {
                this.maxHeight = reader.getInt();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        ArrayList<Column> roots = new ArrayList<Column>();
        WebGridCommon.Footer footer = null;
        ArrayList<Column> leafs = new ArrayList<Column>();
        for (WebControl i : this.controls) {
            if (i instanceof WebGridCommon.Footer) {
                footer = (WebGridCommon.Footer)i;
                continue;
            }
            if (!(i instanceof Column)) continue;
            roots.add((Column)i);
            ((Column)i).leafs(leafs);
        }
        writer.tag("div").attr("id", this.id).attr("class", "grid" + (this.hideSelection ? "" : " showsel"));
        if (this.pageSize < 0) {
            if (this.width > 0.0) {
                writer.style("width", this.width, "mm");
            }
            if (this.height > 0.0) {
                writer.style("height", this.height, "mm");
            }
            this.appendStyles(writer, resolver);
            this.appendAttributes(writer, resolver);
            this.generateStyleSheet(writer, resolver, leafs);
            writer.tag("div").attr("class", "gbody");
            if (this.width > 0.0) {
                writer.style("width", this.width, "mm");
            }
            if (this.height > 0.0) {
                writer.style("height", this.height, "mm");
            }
            this.effectiveFont().appendCssTo(writer);
            writer.end();
            writer.tag("div").attr("class", "ghead").tag("div").attr("class", "cutter").tag("div").attr("class", "rester").tag("table").attr("id", this.id).attr("class", "grid");
            this.effectiveFont().appendCssTo(writer);
            this.generateAttributes(writer, resolver);
            this.generateColumns(writer, resolver, leafs);
            WebGridCommon.generateHeader(writer, resolver, Collections.castingIterator(roots.iterator(), WebGridCommon.ColumnCaption.class), true);
            writer.end().end().end().end();
            if (footer != null) {
                writer.tag("div").attr("class", "gfoot").tag("div").attr("class", "cutter").tag("div").attr("class", "rester").tag("table").attr("id", this.id).attr("class", "grid");
                WebGridCommon.generateFooter(writer, resolver, footer, true, true);
                writer.end().end().end().end();
            }
        } else {
            if (this.width > 0.0) {
                writer.style("width", this.width, "mm");
            }
            if (this.height > 0.0) {
                writer.style("min-height", this.height, "mm");
            }
            this.generateStyleSheet(writer, resolver, leafs);
            writer.tag("table").attr("id", this.id).attr("class", "grid paging");
            writer.attr("data-pagesize", this.pageSize).style("margin-bottom", "4px");
            this.effectiveFont().appendCssTo(writer);
            this.generateAttributes(writer, resolver);
            this.generateColumns(writer, resolver, leafs);
            writer.tag("thead").attr("class", "tlb").tag("tr").tag("td").attr("colspan", leafs.size() + 1).end().end().end();
            WebGridCommon.generateHeader(writer, resolver, Collections.castingIterator(roots.iterator(), WebGridCommon.ColumnCaption.class), true);
            writer.tag("tbody").attr("class", "empty").end();
            writer.end();
        }
        writer.end();
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        this.generate(html, resolver);
        json.object().underscore("WebGrid.WclControl", this).prop("minh").val(this.minHeight).prop("maxh").val(this.maxHeight).prop("item").js("cbi(" + this.id + ")").end();
    }

    private void generateAttributes(HtmlWriter writer, Resolver resolver) throws IOException {
        if (this.datasourceId != 0) {
            writer.attr("data-datasource", this.datasourceId);
        }
        if (this.rowColorExpression != null) {
            writer.attr("data-color-expression", this.expr2str(this.rowColorExpression, resolver));
        }
        if (this.rowTextColorExpression != null) {
            writer.attr("data-textcolor-expression", this.expr2str(this.rowTextColorExpression, resolver));
        }
        if (this.rowTextStyleExpression != null) {
            writer.attr("data-textstyle-expression", this.expr2str(this.rowTextStyleExpression, resolver));
        }
        if (this.event != null) {
            writer.attr("data-action", this.event.toValue());
        }
    }

    private String getColumnFontDescription(Column col) {
        StringBuilder descr = new StringBuilder();
        if (col.font == null) {
            return "";
        }
        descr.append(col.font.getName()).append(col.font.getSize());
        return descr.toString();
    }

    private void generateColumns(HtmlWriter writer, Resolver resolver, Iterable<Column> leafs) throws IOException {
        writer.tag("col").end();
        for (Column c : leafs) {
            writer.tag("col");
            writer.attr("id", c.id);
            int fmtid = c.formatId;
            if (fmtid == 0 && this.hasdb(c.datasourceId, c.fieldId)) {
                fmtid = resolver.resolveFormatId(c.datasourceId, c.fieldId);
            }
            if (fmtid != 0) {
                writer.attr("data-format", fmtid);
                if (c.formatOption != null) {
                    writer.attr("data-format-option", Base64BinString.Encode(c.formatOption));
                }
            }
            if (c.expression != null) {
                writer.attr("data-expression", this.expr2str(c.expression, resolver));
            } else {
                this.appendDataBindingsAsExpressionTo(writer, c.datasourceId, c.fieldId);
            }
            if (c.colorExpression != null) {
                writer.attr("data-color-expression", this.expr2str(c.colorExpression, resolver));
            }
            if (c.textColorExpression != null) {
                writer.attr("data-textcolor-expression", this.expr2str(c.textColorExpression, resolver));
            }
            if (c.textStyleExpression != null) {
                writer.attr("data-textstyle-expression", this.expr2str(c.textStyleExpression, resolver));
            }
            if (c.dataType != 0) {
                writer.attr("data-datatype", c.dataType);
            }
            this.appendDataBindingsTo(writer, c.datasourceId, c.fieldId);
            if (c.event != null) {
                writer.attr("data-action", c.event.toValue());
            }
            if (c.wordWrap) {
                writer.attr("data-wordwrap");
            }
            if (c.rangingKind == ColRangingKind.DEFAULT) {
                c.rangingKind = c.dataType == DataType.STRING.toInt() || c.dataType == DataType.UNICODE.toInt() ? ColRangingKind.VARIABLE : ColRangingKind.FIXED;
            }
            writer.attr("data-ranging", c.rangingKind.name().toLowerCase());
            writer.attr("start-width", this.mmToPx(c.width));
            writer.attr("font-descr", this.getColumnFontDescription(c));
            if (c.veer != null) {
                this.appendDataBindingsToWithSuffix(writer, c.veer.getVeerId(), c.veer.getVeerFieldPath(), "-veer");
                this.appendDataBindingsToWithSuffix(writer, c.veer.getDataId(), c.veer.getDataFieldPath(), "-veer-data");
                this.appendDataBindingsToWithSuffix(writer, c.veer.getVeerId(), c.veer.getCaptionDataFieldPath(), "-veer-caption");
                int vfmtid = c.veer.getCaptionFormatId();
                byte[] vfmtopt = c.veer.getCaptionFormatOptions();
                if (vfmtid != 0) {
                    writer.attr("data-veer-caption-format", vfmtid);
                    if (vfmtopt != null) {
                        writer.attr("data-veer-caption-format-option", Base64BinString.Encode(vfmtopt));
                    }
                }
            }
            writer.end();
        }
    }

    private long mmToPx(double width) {
        return Math.round(width * 3.8);
    }

    private void generateStyleSheet(HtmlWriter writer, Resolver resolver, Iterable<Column> leafs) throws IOException {
        writer.tag("style").attr("type", "text/css");
        for (Column c : leafs) {
            String rid = ".grid[id='" + this.id + "'] .c" + c.id;
            writer.html(rid + "{");
            if (c.alignVert != WebControl.VertAlign.DEFAULT) {
                writer.html("vertical-align:" + c.alignVert.name().toLowerCase() + ";");
            }
            if (c.rangingKind == ColRangingKind.FIXED) {
                writer.html("max-width:" + this.mmToPx(c.width) + "px;");
            }
            writer.html("width:" + this.mmToPx(c.width) + "px;").html("min-width:" + this.mmToPx(c.width) + "px;");
            if (c.rangingKind == ColRangingKind.DEFAULT && c.dataType != DataType.STRING.toInt() && c.dataType != DataType.UNICODE.toInt()) {
                writer.html("max-width:" + this.mmToPx(c.width) + "px;");
            }
            if (c.alignHorz != WebControl.HorzAlign.DEFAULT) {
                writer.html("text-align:" + c.alignHorz.name().toLowerCase() + ";");
            } else if (c.datasourceId != 0 && c.fieldId != null) {
                int fmtid = c.formatId;
                if (fmtid == 0) {
                    fmtid = resolver.resolveFormatId(c.datasourceId, c.fieldId);
                }
                DataType dt = resolver.resolveDataType(c.datasourceId, c.fieldId);
                Format fmt = FormatManager.createFormat(fmtid, dt, c.formatOption);
                writer.html("text-align:" + fmt.getAlignment().name().toLowerCase() + ";");
            }
            if (c.font != null) {
                writer.html(c.font.toCss());
            }
            if (c.wordWrap) {
                writer.html("white-space:pre-wrap !important;");
            }
            writer.html(Character.valueOf('}'));
        }
        writer.end();
    }

    @Override
    protected WebControl createTypedControl(int type, int id, int options) {
        if (type == 501) {
            Column c = new Column(id, options, this);
            c.grid = this;
            return c;
        }
        return super.createTypedControl(type, id, options);
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        out.append((Object)this, this.datasourceId, new int[0]);
        if (this.rowColorExpression != null) {
            this.rowColorExpression.appendUsedDirectoriesTo(this, out);
        }
        if (this.rowTextColorExpression != null) {
            this.rowTextColorExpression.appendUsedDirectoriesTo(this, out);
        }
        if (this.rowTextStyleExpression != null) {
            this.rowTextStyleExpression.appendUsedDirectoriesTo(this, out);
        }
    }

    private static class Column
    extends WebControlContainer
    implements DatasourceUsage,
    WebGridCommon.ColumnCaption {
        static final int TAG_WF_GRID_COLUMN_CAPTION = 40;
        static final int TAG_WF_GRID_COLUMN_WIDTH = 41;
        static final int TAG_WF_GRID_COLUMN_DATASOURCE = 42;
        static final int TAG_WF_GRID_COLUMN_FIELD = 43;
        static final int TAG_WF_GRID_COLUMN_FORMAT = 44;
        static final int TAG_WF_GRID_COLUMN_FORMAT_OPTION = 45;
        static final int TAG_WF_GRID_COLUMN_DATA_TYPE = 46;
        static final int TAG_WF_GRID_COLUMN_EXPRESSION = 47;
        static final int TAG_WF_GRID_COLUMN_COLOR_EXPRESSION = 50;
        static final int TAG_WF_GRID_COLUMN_EVENT = 51;
        static final int TAG_WF_GRID_COLUMN_TEXT_COLOR_EXPRESSION = 52;
        static final int TAG_WF_GRID_COLUMN_TEXT_STYLE_EXPRESSION = 53;
        static final int TAG_WF_GRID_COLUMN_WORD_WRAP = 54;
        static final int TAG_WF_GRID_COLUMN_VEER = 55;
        static final int TAG_WF_GRID_COLUMN_RANGING = 56;
        static final int TAG_WF_GRID_COLUMN_ON_CLICK = 57;
        Caption caption;
        ColRangingKind rangingKind = ColRangingKind.DEFAULT;
        WebBorders borders;
        int datasourceId;
        int[] fieldId;
        int formatId;
        byte[] formatOption;
        int dataType;
        JsEvaluator expression;
        JsEvaluator colorExpression;
        JsEvaluator textColorExpression;
        JsEvaluator textStyleExpression;
        boolean wordWrap;
        WebControl.WebEvent event;
        WebGridVeer veer;
        WebGrid grid = null;
        String onClick;
        static final int DEFAULT_COLUMN_WIDTH = 20;

        public Column(int id, int options, WebControlContainer parent) {
            super(id, parent, true);
            this.width = 20.0;
        }

        @Override
        public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
            if (!this.controls.isEmpty()) {
                return;
            }
            out.append((Object)this, this.datasourceId, this.fieldId);
            if (this.expression != null) {
                this.expression.appendUsedDirectoriesTo(this, out);
            }
            if (this.colorExpression != null) {
                this.colorExpression.appendUsedDirectoriesTo(this, out);
            }
            if (this.textColorExpression != null) {
                this.textColorExpression.appendUsedDirectoriesTo(this, out);
            }
            if (this.textStyleExpression != null) {
                this.textStyleExpression.appendUsedDirectoriesTo(this, out);
            }
            if (this.veer != null) {
                out.append((Object)this, this.veer.getVeerId(), this.veer.getVeerFieldPath());
                out.append((Object)this, this.veer.getVeerId(), this.veer.getCaptionDataFieldPath());
                out.append((Object)this, this.veer.getDataId(), this.veer.getDataFieldPath());
            }
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public String captionText() {
            return this.caption == null ? null : this.caption.text;
        }

        @Override
        public void appendCaptionStyles(HtmlWriter writer, Resolver resolver) throws IOException {
            if (this.caption != null) {
                String fontName = this.caption.effectiveFont().getName();
                int fontSize = this.caption.effectiveFont().getSize();
                int fontStyle = this.caption.effectiveFont().getStyleAsInt();
                int fontColor = this.caption.effectiveFont().getColor();
                writer.style("font-family", fontName);
                writer.style("font-size", fontSize, "pt");
                writer.style("font-weight", (fontStyle & 1) != 0 ? "bold" : "normal").style("font-style", (fontStyle & 2) != 0 ? "italic" : "normal");
                Object td = "";
                if ((fontStyle & 0xC) != 0) {
                    if ((fontStyle & 4) != 0) {
                        td = "underline";
                    }
                    if ((fontStyle & 8) != 0) {
                        td = (String)td + " line-through";
                    }
                } else {
                    td = "none";
                }
                writer.style("text-decoration", td);
                writer.style("color", Color.toHtml(fontColor));
                if (this.caption.alignHorz != WebControl.HorzAlign.DEFAULT) {
                    writer.style("text-align", this.caption.alignHorz.name().toLowerCase());
                }
                if (this.caption.color != 0x1FFFFFFF) {
                    writer.style("background-color", Color.toHtml(this.caption.color));
                }
            }
        }

        @Override
        public Iterator<WebGridCommon.ColumnCaption> childrenIterator() {
            return Collections.castingIterator(this.controls.iterator(), WebGridCommon.ColumnCaption.class);
        }

        @Override
        protected void loadTag(TaggedReader reader) throws IOException {
            switch (reader.getCurrentTag()) {
                case 11: {
                    this.borders = new WebBorders(reader.getSubStreamReader());
                    break;
                }
                case 40: {
                    this.caption = new Caption(this, reader.getSubStreamReader(), this.grid);
                    break;
                }
                case 41: {
                    this.width = reader.getDouble();
                    break;
                }
                case 42: {
                    this.datasourceId = reader.getInt();
                    break;
                }
                case 43: {
                    this.fieldId = LittleEndian.toIntArray(reader.getRaw());
                    break;
                }
                case 44: {
                    this.formatId = reader.getInt();
                    break;
                }
                case 45: {
                    this.formatOption = reader.getRaw();
                    break;
                }
                case 46: {
                    this.dataType = reader.getInt();
                    break;
                }
                case 47: {
                    this.expression = JsExpression.loadAndCompile(reader.getStreamReader());
                    break;
                }
                case 50: {
                    this.colorExpression = JsExpression.loadAndCompile(reader.getStreamReader());
                    break;
                }
                case 52: {
                    this.textColorExpression = JsExpression.loadAndCompile(reader.getStreamReader());
                    break;
                }
                case 53: {
                    this.textStyleExpression = JsExpression.loadAndCompile(reader.getStreamReader());
                    break;
                }
                case 51: {
                    this.event = new WebControl.WebEvent(reader.getRaw());
                    break;
                }
                case 57: {
                    this.onClick = reader.getAnsi();
                    break;
                }
                case 54: {
                    this.wordWrap = true;
                    break;
                }
                case 55: {
                    this.veer = new WebGridVeer(reader.getSubStreamReader());
                    break;
                }
                case 56: {
                    this.rangingKind = ColRangingKind.values()[reader.getInt()];
                    break;
                }
                default: {
                    super.loadTag(reader);
                }
            }
        }

        @Override
        protected WebControl createTypedControl(int type, int id, int options) {
            if (type == 501) {
                Column c = new Column(id, options, this);
                c.grid = this.grid;
                return c;
            }
            return super.createTypedControl(type, id, options);
        }

        private void leafs(Collection<Column> leafs) {
            if (!this.visible) {
                return;
            }
            if (this.controls.isEmpty()) {
                leafs.add(this);
            } else {
                for (WebControl i : this.controls) {
                    ((Column)i).leafs(leafs);
                }
            }
        }

        private static class Caption
        extends WebControl {
            static final int TAG_WF_GRID_COLUMN_CAPTION_TEXT = 1;
            static final int TAG_WF_GRID_COLUMN_CAPTION_HALIGN = 2;
            static final int TAG_WF_GRID_COLUMN_CAPTION_VALIGN = 3;
            static final int TAG_WF_GRID_COLUMN_CAPTION_FONT = 4;
            static final int TAG_WF_GRID_COLUMN_CAPTION_COLOR = 5;
            static final int TAG_WF_GRID_COLUMN_CAPTION_BORDERS = 6;
            String text = "";
            WebBorders borders;
            WebGrid grid = null;
            private WebControl.WebFont _effectiveFont = null;

            private WebControl.WebFont gridEffectiveFont() {
                return this.grid == null ? WebControl.WebFont.DEFAULT : this.grid.getFont();
            }

            @Override
            protected WebControl.WebFont effectiveFont() {
                if (this._effectiveFont != null) {
                    return this._effectiveFont;
                }
                String nm = this.font == null || this.font.getName() == null ? this.gridEffectiveFont().getName() : this.font.getName();
                nm = nm == null ? WebControl.WebFont.DEFAULT.getName() : nm;
                int sz = this.font == null || this.font.getSize() <= 0 ? this.gridEffectiveFont().getSize() : this.font.getSize();
                sz = sz <= 0 ? WebControl.WebFont.DEFAULT.getSize() : sz;
                int cl = this.font == null || this.font.getColor() == 0x1FFFFFFF ? this.gridEffectiveFont().getColor() : this.font.getColor();
                cl = cl == 0x1FFFFFFF ? WebControl.WebFont.DEFAULT.getColor() : cl;
                int st = this.font == null || this.font.getStyleAsInt() == 0 ? this.gridEffectiveFont().getStyleAsInt() : this.font.getStyleAsInt();
                st = st == 0 ? WebControl.WebFont.DEFAULT.getStyleAsInt() : st;
                this._effectiveFont = new WebControl.WebFont(nm, sz, cl, st, this);
                return this._effectiveFont;
            }

            public Caption(WebControlContainer parent, TaggedReader reader, WebGrid grid) throws IOException {
                super(0, parent, true);
                this.grid = grid;
                while (reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            this.text = reader.getString();
                            break;
                        }
                        case 2: {
                            this.alignHorz = WebControl.HorzAlign.values()[reader.getInt()];
                            break;
                        }
                        case 3: {
                            this.alignVert = WebControl.VertAlign.values()[reader.getInt()];
                            break;
                        }
                        case 4: {
                            this.font = new WebControl.WebFont(reader.getStreamReader(), this);
                            break;
                        }
                        case 5: {
                            this.color = reader.getInt();
                            break;
                        }
                        case 6: {
                            this.borders = new WebBorders(reader.getSubStreamReader());
                        }
                    }
                }
            }
        }
    }

    private static enum ColRangingKind {
        DEFAULT,
        FIXED,
        VARIABLE;

    }
}

